/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BusState;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageBusImplKt;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.RootBus;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 [2\u00020\u0001:\u0002[\\B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u001d\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0010\u00a2\u0006\u0004\b$\u0010%J#\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001b2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0010\u00a2\u0006\u0004\b(\u0010)J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\tH\u0016J\u0010\u0010*\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J/\u00100\u001a\b\u0012\u0004\u0012\u0002H201\"\u0004\b\u0000\u001022\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H20\u00162\u0006\u00103\u001a\u000204H\u0010\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020 2\u0006\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\b9J\u001a\u0010:\u001a\u00020 2\u0010\u0010;\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030=0<H\u0016J\b\u0010>\u001a\u00020 H\u0016J\r\u0010?\u001a\u00020 H\u0010\u00a2\u0006\u0002\b@J\u0006\u0010A\u001a\u00020 J\u0006\u0010B\u001a\u00020 J1\u0010C\u001a\u00020 2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00162\u000e\u0010D\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170E2\u0006\u0010F\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bGJ\r\u0010H\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bIJ\u0014\u0010J\u001a\u00020\r2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\u001d\u0010K\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0010\u00a2\u0006\u0004\bL\u0010MJ\u0019\u0010N\u001a\u00020 2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0000\u00a2\u0006\u0002\bOJ\u0019\u0010P\u001a\u00020 2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0010\u00a2\u0006\u0002\bQJ\b\u0010R\u001a\u00020 H\u0016J\u0010\u0010S\u001a\u00020 2\b\u0010T\u001a\u0004\u0018\u00010\u0010J\b\u0010U\u001a\u00020-H\u0016J%\u0010V\u001a\u0002H2\"\b\b\u0000\u00102*\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H20\u0016H\u0016\u00a2\u0006\u0002\u0010WJ%\u0010X\u001a\u0002H2\"\b\b\u0000\u00102*\u00020\u00172\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H20\u0016H\u0016\u00a2\u0006\u0002\u0010WJ\b\u0010Y\u001a\u00020ZH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u00170\u00158\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001b0\u00158\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/MessageBus;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "connectionDisposable", "Lcom/intellij/openapi/Disposable;", "disposeState", "Lcom/intellij/util/messages/impl/BusState;", "isDisposed", "", "()Z", "messageDeliveryListener", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "parent", "getParent", "()Lcom/intellij/util/messages/MessageBus;", "publisherCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/messages/Topic;", "", "rootBus", "Lcom/intellij/util/messages/impl/RootBus;", "subscriberCache", "", "subscribers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "checkNotDisposed", "", "checkNotDisposed$intellij_platform_core", "clearSubscriberCache", "topicAndHandlerPairs", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "computeSubscribers", "topic", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "connect", "Lcom/intellij/util/messages/MessageBusConnection;", "parentDisposable", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "deliverImmediately", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "deliverImmediately$intellij_platform_core", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "dispose", "disposeChildren", "disposeChildren$intellij_platform_core", "disposeConnection", "disposeConnectionChildren", "doComputeSubscribers", "result", "", "subscribeLazyListeners", "doComputeSubscribers$intellij_platform_core", "hasChildren", "hasChildren$intellij_platform_core", "hasUndeliveredEvents", "notifyConnectionTerminated", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "notifyOnSubscription", "notifyOnSubscription$intellij_platform_core", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "removeEmptyConnectionsRecursively", "setMessageDeliveryListener", "listener", "simpleConnect", "syncAndPreloadPublisher", "(Lcom/intellij/util/messages/Topic;)Ljava/lang/Object;", "syncPublisher", "toString", "", "Companion", "MessageHandlerHolder", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMessageBusImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,719:1\n1747#2,3:720\n37#3,2:723\n1#4:725\n10#5:726\n*S KotlinDebug\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImpl\n*L\n198#1:720,3\n219#1:723,2\n45#1:726\n*E\n"})
public class MessageBusImpl
implements MessageBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object> publisherCache;
    @JvmField
    @NotNull
    public final ConcurrentLinkedQueue<MessageHandlerHolder> subscribers;
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object[]> subscriberCache;
    @JvmField
    @Nullable
    public final CompositeMessageBus parentBus;
    @JvmField
    @NotNull
    public final RootBus rootBus;
    @JvmField
    @NotNull
    public final MessageBusOwner owner;
    @NotNull
    private BusState disposeState;
    @Nullable
    private Disposable connectionDisposable;
    @JvmField
    @Nullable
    public MessageDeliveryListener messageDeliveryListener;
    @JvmField
    @NotNull
    public static final Logger LOG;

    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(parentBus, "parentBus");
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.disposeState = BusState.ALIVE;
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.parentBus = parentBus;
        this.rootBus = parentBus.rootBus;
        parentBus.addChild(this);
    }

    public MessageBusImpl(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.disposeState = BusState.ALIVE;
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type com.intellij.util.messages.impl.RootBus");
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    @Override
    @Nullable
    public MessageBus getParent() {
        return this.parentBus;
    }

    @NotNull
    public String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + (Object)((Object)this.disposeState) + ')';
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull(disposable);
        return this.connect(disposable);
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        this.checkNotDisposed$intellij_platform_core();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register(parentDisposable, connection);
        return connection;
    }

    @Override
    @NotNull
    public SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SimpleMessageBusConnection connect(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(coroutineScope, "coroutineScope");
        Job scopeJob = JobKt.getJob(coroutineScope.getCoroutineContext());
        JobKt.ensureActive(scopeJob);
        this.checkNotDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        try {
            this.subscribers.add(connection);
            scopeJob.invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(connection){
                final /* synthetic */ SimpleMessageBusConnectionImpl $connection;
                {
                    this.$connection = $connection;
                    super(1);
                }

                public final void invoke(@Nullable Throwable it) {
                    this.$connection.disconnect();
                }
            });
        }
        catch (Throwable throwable) {
            scopeJob.invokeOnCompletion((Function1<? super Throwable, Unit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        return connection;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        if (this.isDisposed()) {
            PluginException.logPluginError(LOG, "Already disposed: " + this, null, topic.getClass());
        }
        Object object = this.publisherCache.computeIfAbsent(topic, arg_0 -> MessageBusImpl.syncPublisher$lambda$0(new Function1<Topic<?>, Object>(this){
            final /* synthetic */ MessageBusImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Object invoke(Topic<?> topic1) {
                Class<?> clazz = topic1.getListenerClass();
                Intrinsics.checkNotNullExpressionValue(clazz, "getListenerClass(...)");
                Class<?> aClass = clazz;
                Intrinsics.checkNotNull(topic1);
                Topic.BroadcastDirection broadcastDirection = topic1.getBroadcastDirection();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)broadcastDirection), "getBroadcastDirection(...)");
                MessagePublisher<?> publisher = this.this$0.createPublisher$intellij_platform_core(topic1, broadcastDirection);
                Class[] classArray = new Class[]{aClass};
                return Proxy.newProxyInstance(aClass.getClassLoader(), classArray, (InvocationHandler)publisher);
            }
        }, arg_0));
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type L of com.intellij.util.messages.impl.MessageBusImpl.syncPublisher");
        return (L)object;
    }

    @Override
    @NotNull
    public <L> L syncAndPreloadPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        L publisher = this.syncPublisher(topic);
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(publisher);
        Intrinsics.checkNotNull(invocationHandler, "null cannot be cast to non-null type com.intellij.util.messages.impl.MessagePublisher<*>");
        ((MessagePublisher)invocationHandler).preload();
        return publisher;
    }

    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
            }
            default: {
                LOG.error("Topic " + topic.getListenerClass().getName() + " broadcast direction TO_CHILDREN is not allowed for module level message bus. Please change to NONE or TO_PARENT");
                messagePublisher = new MessagePublisher<L>(topic, this);
            }
        }
        return messagePublisher;
    }

    public final void disposeConnectionChildren() {
        this.disposeState = BusState.DISPOSE_IN_PROGRESS;
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull(disposable);
        Disposer.disposeChildren(disposable, arg_0 -> MessageBusImpl.disposeConnectionChildren$lambda$1(disposeConnectionChildren.1.INSTANCE, arg_0));
    }

    public final void disposeConnection() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull(disposable);
        Disposer.dispose(disposable);
        this.connectionDisposable = null;
    }

    @Override
    public void dispose() {
        block2: {
            if (this.disposeState == BusState.DISPOSED_STATE) {
                LOG.error("Already disposed: " + this);
            }
            this.disposeState = BusState.DISPOSED_STATE;
            this.disposeChildren$intellij_platform_core();
            Disposable disposable = this.connectionDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose(it);
            }
            this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> MessageBusImpl.dispose$lambda$3(new Function1<Message, Boolean>(this){
                final /* synthetic */ MessageBusImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Message it) {
                    return it.bus == this.this$0;
                }
            }, arg_0));
            CompositeMessageBus compositeMessageBus = this.parentBus;
            if (compositeMessageBus == null) break block2;
            compositeMessageBus.onChildBusDisposed(this);
        }
    }

    public void disposeChildren$intellij_platform_core() {
    }

    @Override
    public boolean isDisposed() {
        return this.disposeState == BusState.DISPOSED_STATE || this.owner.isDisposed();
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(topic, "topic");
            if (this.isDisposed()) {
                return false;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            Message current = queue.current;
            if (current != null && current.topic == topic && current.bus == this) {
                return true;
            }
            Iterable $this$any$iv = queue.queue;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(it.topic == topic && it.bus == this)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkNotDisposed$intellij_platform_core() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    public void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result2, boolean subscribeLazyListeners2) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(result2, "result");
        for (MessageHandlerHolder subscriber : this.subscribers) {
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result2);
        }
    }

    @NotNull
    public Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, "topic");
        List result2 = new ArrayList();
        this.doComputeSubscribers$intellij_platform_core(topic, result2, true);
        if (result2.isEmpty()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue(ArrayUtilRt.EMPTY_OBJECT_ARRAY, "EMPTY_OBJECT_ARRAY");
        } else {
            Collection $this$toTypedArray$iv = result2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        }
        return objectArray;
    }

    public boolean hasChildren$intellij_platform_core() {
        return false;
    }

    public final void notifyOnSubscription$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while (true) {
            CompositeMessageBus compositeMessageBus = parentBus.parentBus;
            if (compositeMessageBus == null) {
                break;
            }
            parentBus = compositeMessageBus;
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren$intellij_platform_core()) {
            this.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    public void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
    }

    public void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(arg_0 -> MessageBusImpl.removeEmptyConnectionsRecursively$lambda$5(removeEmptyConnectionsRecursively.1.INSTANCE, arg_0));
    }

    public boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        if (this.disposeState != BusState.ALIVE) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImplKt.access$clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    public void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Map map2 = this.subscriberCache;
            Object object = topicAndHandlerPairs[i];
            TypeIntrinsics.asMutableMap(map2).remove(object);
        }
    }

    public final void deliverImmediately$intellij_platform_core(@NotNull MessageBusConnectionImpl connection) {
        block7: {
            Intrinsics.checkNotNullParameter(connection, "connection");
            if (this.disposeState == BusState.DISPOSED_STATE) {
                LOG.error("Already disposed: " + this);
            }
            if (this.owner.isDisposed()) {
                return;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            ArrayDeque<Message> jobs = queue.queue;
            if (jobs.isEmpty()) {
                return;
            }
            List list = MessageBusImplKt.access$deliverImmediately(connection, jobs);
            if (list == null) {
                return;
            }
            List newJobs = list;
            int n = newJobs.size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    jobs.addFirst((Message)newJobs.get(i));
                } while (0 <= n);
            }
            Throwable error = null;
            for (Message job : newJobs) {
                jobs.removeFirstOccurrence(job);
                error = MessageBusImplKt.access$deliverMessage(job, queue, error);
            }
            Throwable throwable = error;
            if (throwable == null) break block7;
            Throwable p0 = throwable;
            boolean bl = false;
            MessageBusImplKt.throwError(p0);
        }
    }

    public final void setMessageDeliveryListener(@Nullable MessageDeliveryListener listener) {
        if (!(this.messageDeliveryListener == null || listener == null)) {
            boolean bl = false;
            String string2 = "Already set: " + this.messageDeliveryListener;
            throw new IllegalStateException(string2.toString());
        }
        this.messageDeliveryListener = listener;
    }

    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        for (MessageHandlerHolder holder : this.subscribers) {
            holder.disconnectIfNeeded(predicate);
        }
        this.subscriberCache.clear();
    }

    private static final Object syncPublisher$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final boolean disposeConnectionChildren$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean dispose$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEmptyConnectionsRecursively$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MessageBusImpl.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\nH&J\u001a\u0010\u000b\u001a\u00020\u00062\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "", "isDisposed", "", "()Z", "collectHandlers", "", "topic", "Lcom/intellij/util/messages/Topic;", "result", "", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "intellij.platform.core"})
    public static interface MessageHandlerHolder {
        public boolean isDisposed();

        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<? super Object> var2);

        public void disconnectIfNeeded(@NotNull Predicate<Class<?>> var1);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

