/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Hash;
import java.util.NoSuchElementException;

final class StrippedLongSet {
    public transient long[] keys;
    private transient int mask;
    private transient boolean containsNull;
    private transient int n;
    private transient int maxFill;
    private int size;
    private final float loadFactor;

    StrippedLongSet(int expected, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be non-negative");
        }
        this.loadFactor = loadFactor;
        this.n = Hash.arraySize(expected, loadFactor);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill(this.n, loadFactor);
        this.keys = new long[this.n + 1];
    }

    StrippedLongSet() {
        this(16, 0.5f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public boolean hasNull() {
        return this.containsNull;
    }

    public boolean add(long k) {
        if (k == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            long[] key = this.keys;
            int pos = (int)k & this.mask;
            long curr = key[pos];
            if (curr != 0L) {
                if (curr == k) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, this.loadFactor));
        }
        return true;
    }

    public boolean contains(long k) {
        if (k == 0L) {
            return this.containsNull;
        }
        long[] key = this.keys;
        int pos = (int)k & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public SetIterator iterator() {
        return new SetIterator();
    }

    private void rehash(int newN) {
        long[] key = this.keys;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0L) {
            }
            int pos = (int)key[i] & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.n, this.loadFactor);
        this.keys = newKey;
    }

    public long[] toArray() {
        long[] result2 = new long[this.size];
        SetIterator iterator2 = this.iterator();
        int i = 0;
        while (iterator2.hasNext()) {
            result2[i++] = iterator2.nextLong();
        }
        return result2;
    }

    final class SetIterator {
        int pos;
        int c;
        boolean mustReturnNull;

        SetIterator() {
            this.pos = StrippedLongSet.this.n;
            this.c = StrippedLongSet.this.size;
            this.mustReturnNull = StrippedLongSet.this.containsNull;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public long nextLong() {
            long v;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                return StrippedLongSet.this.keys[StrippedLongSet.this.n];
            }
            long[] key = StrippedLongSet.this.keys;
            while ((v = key[--this.pos]) == 0L) {
            }
            return v;
        }
    }
}

