/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage.lf;

import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.lf.AbstractRecordsTableLF;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

final class RefCountingRecordsTableLF
extends AbstractRecordsTableLF {
    private static final int VERSION = 1;
    private static final int REF_COUNT_OFFSET = 16;
    private static final int RECORD_SIZE = 20;
    private static final byte[] ZEROES = new byte[20];

    RefCountingRecordsTableLF(@NotNull Path recordsFile, StorageLockContext context2) throws IOException {
        if (recordsFile == null) {
            RefCountingRecordsTableLF.$$$reportNull$$$0(0);
        }
        super(recordsFile, context2);
    }

    @Override
    protected int getImplVersion() {
        return 1;
    }

    @Override
    protected int getRecordSize() {
        return 20;
    }

    @Override
    protected byte[] getZeros() {
        return ZEROES;
    }

    public void incRefCount(int record) throws IOException {
        this.markDirty();
        int offset = this.getOffset(record, 16);
        this.storage.putInt(offset, this.storage.getInt(offset) + 1);
    }

    public boolean decRefCount(int record) throws IOException {
        this.markDirty();
        int offset = this.getOffset(record, 16);
        int count2 = this.storage.getInt(offset);
        assert (count2 > 0);
        this.storage.putInt(offset, --count2);
        return count2 == 0;
    }

    public int getRefCount(int record) throws IOException {
        return this.storage.getInt(this.getOffset(record, 16));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordsFile", "com/intellij/util/io/storage/lf/RefCountingRecordsTableLF", "<init>"));
    }
}

