/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public final class MathUtil {
    public static int nonNegativeAbs(int a) {
        return a >= 0 ? a : (a == Integer.MIN_VALUE ? Integer.MAX_VALUE : -a);
    }

    public static int clamp(int value, int min2, int max) {
        if (min2 > max) {
            throw new IllegalArgumentException(min2 + ">" + max);
        }
        return Math.min(max, Math.max(value, min2));
    }

    public static long clamp(long value, long min2, long max) {
        if (min2 > max) {
            throw new IllegalArgumentException(min2 + ">" + max);
        }
        return Math.min(max, Math.max(value, min2));
    }

    public static double clamp(double value, double min2, double max) {
        if (min2 > max) {
            throw new IllegalArgumentException(min2 + ">" + max);
        }
        return Math.min(max, Math.max(value, min2));
    }

    public static float clamp(float value, float min2, float max) {
        if (min2 > max) {
            throw new IllegalArgumentException(min2 + ">" + max);
        }
        return Math.min(max, Math.max(value, min2));
    }

    public static boolean equals(float a, float b, float epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static boolean equals(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static int compare(float a, float b, float epsilon) {
        return Math.abs(a - b) < epsilon ? 0 : Float.compare(a, b);
    }

    public static int compare(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon ? 0 : Double.compare(a, b);
    }

    public static boolean between(float min2, float med, float max, float epsilon) {
        return MathUtil.compare(min2, med, epsilon) < 0 && MathUtil.compare(med, max, epsilon) < 0;
    }

    public static boolean between(double min2, double med, double max, double epsilon) {
        return MathUtil.compare(min2, med, epsilon) < 0 && MathUtil.compare(med, max, epsilon) < 0;
    }
}

