/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public final class CodeWriter
extends PrintWriter {
    private final int myIndent;
    private int myIndentLevel = 0;
    private boolean myNewLineStarted = true;

    public CodeWriter(PrintWriter writer) {
        super(writer);
        this.myIndent = 2;
    }

    @Override
    public void print(@NonNls String s2) {
        this.possiblyIndent(s2);
        super.print(s2);
        for (int i = 0; i < s2.length(); ++i) {
            if (CodeWriter.isOpenBrace(s2, i)) {
                ++this.myIndentLevel;
            }
            if (!CodeWriter.isCloseBrace(s2, i)) continue;
            --this.myIndentLevel;
        }
    }

    private static boolean isCloseBrace(String s2, int index) {
        char c = s2.charAt(index);
        return c == ')' || c == ']' || c == '}';
    }

    private static boolean isOpenBrace(String s2, int index) {
        char c = s2.charAt(index);
        return c == '(' || c == '[' || c == '{';
    }

    @Override
    public void println() {
        ((PrintWriter)this.out).println();
        this.myNewLineStarted = true;
    }

    private void possiblyIndent(String s2) {
        if (this.myNewLineStarted) {
            int firstNonBlank;
            int i;
            for (i = 0; i < s2.length() && s2.charAt(i) == ' '; ++i) {
            }
            int n = firstNonBlank = i < s2.length() && s2.charAt(i) != ' ' ? i : -1;
            if (firstNonBlank >= 0) {
                if (CodeWriter.isCloseBrace(s2, firstNonBlank)) {
                    --this.myIndentLevel;
                }
                int blanksToPrint = this.myIndent * this.myIndentLevel - firstNonBlank;
                for (int j = 0; j < blanksToPrint; ++j) {
                    this.write(" ");
                }
                if (CodeWriter.isCloseBrace(s2, firstNonBlank)) {
                    ++this.myIndentLevel;
                }
            }
            this.myNewLineStarted = false;
        }
    }

    @Override
    public void println(String s2) {
        StringTokenizer st = new StringTokenizer(s2, "\r\n", false);
        while (st.hasMoreTokens()) {
            super.println(st.nextToken());
        }
    }
}

