/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance(PsiUtil.class);
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create("VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final Pattern IGNORED_NAMES = Pattern.compile("ignored?[A-Za-z\\d]*");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = LanguageLevel.FILE_LANGUAGE_LEVEL_KEY;
    public static final Comparator<PsiElement> BY_POSITION = (o1, o2) -> PsiUtil.compareElementsByPosition(o1, o2);

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(@NotNull PsiExpression expr) {
        PsiElement parent;
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        return (parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false);
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if (aPackage == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        if (element.hasModifierProperty("public")) {
            return true;
        }
        return !element.hasModifierProperty("private") && JavaPsiFacade.getInstance(element.getProject()).isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(@NotNull PsiExpression expr) {
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return PsiUtil.isIncrementDecrementOperation(parent);
    }

    public static boolean isAccessedForReading(@NotNull PsiExpression expr) {
        PsiElement parent;
        if (expr == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        return !((parent = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class)) instanceof PsiAssignmentExpression) || !PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent).getLExpression(), expr, false) || ((PsiAssignmentExpression)parent).getOperationTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        return PsiUtil.isAccessible(place.getProject(), member, place, accessObjectClass);
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        return JavaPsiFacade.getInstance(project).getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    public static boolean isMemberAccessibleAt(@NotNull PsiMember member, @NotNull PsiElement place) {
        VirtualFile virtualFile;
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(11);
        }
        return ((virtualFile = PsiUtilCore.getVirtualFile(member)) == null || place.getResolveScope().contains(virtualFile)) && PsiUtil.isAccessible(member, place, null);
    }

    @NotNull
    public static JavaResolveResult getAccessObjectClass(@NotNull PsiExpression expression) {
        JavaResolveResult resolveResult;
        if (expression == null) {
            PsiUtil.$$$reportNull$$$0(12);
        }
        if (expression instanceof PsiSuperExpression) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(13);
            }
            return javaResolveResult;
        }
        PsiType type = expression.getType();
        JavaResolveResult accessObject = PsiUtil.getAccessObjectClass(type, expression);
        if (accessObject != null) {
            JavaResolveResult javaResolveResult = accessObject;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(14);
            }
            return javaResolveResult;
        }
        if (type == null && expression instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement() instanceof PsiClass) {
            JavaResolveResult javaResolveResult = resolveResult;
            if (javaResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(15);
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(16);
        }
        return javaResolveResult;
    }

    @Nullable
    private static JavaResolveResult getAccessObjectClass(@Nullable PsiType type, @NotNull PsiElement place) {
        PsiType upperBound;
        PsiType lub;
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(17);
        }
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolveGenerics();
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolveGenerics();
        }
        if (type instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)type).getUpperBound()) instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)upperBound).resolve();
            PsiFile containingFile = resolved != null ? resolved.getContainingFile() : null;
            String packageName = containingFile instanceof PsiClassOwner ? ((PsiClassOwner)containingFile).getPackageName() : null;
            String classText = StringUtil.isEmptyOrSpaces(packageName) ? "" : "package " + packageName + ";\n ";
            classText = classText + "class I<T extends " + upperBound.getCanonicalText() + "> {}";
            PsiJavaFile file2 = (PsiJavaFile)PsiFileFactory.getInstance(place.getProject()).createFileFromText("inference_dummy.java", JavaLanguage.INSTANCE, (CharSequence)classText);
            PsiTypeParameter freshParameter = file2.getClasses()[0].getTypeParameters()[0];
            return new ClassCandidateInfo(freshParameter, PsiSubstitutor.EMPTY);
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.getAccessObjectClass(((PsiArrayType)type).getComponentType(), place);
        }
        return null;
    }

    public static boolean isConstantExpression(@Nullable PsiExpression expression) {
        return expression != null && JavaPsiFacade.getInstance(expression.getProject()).isConstantExpression(expression);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull String exceptionFQName) throws IncorrectOperationException {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(18);
        }
        if (exceptionFQName == null) {
            PsiUtil.$$$reportNull$$$0(19);
        }
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull PsiClass exceptionClass) throws IncorrectOperationException {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(20);
        }
        if (exceptionClass == null) {
            PsiUtil.$$$reportNull$$$0(21);
        }
        PsiUtil.addException(method, exceptionClass, exceptionClass instanceof PsiTypeParameter ? exceptionClass.getName() : exceptionClass.getQualifiedName());
    }

    private static void addException(@NotNull PsiMethod method, @Nullable PsiClass exceptionClass, @Nullable String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(22);
        }
        if (exceptionClass == null && exceptionName == null) {
            throw new IllegalArgumentException("One of exceptionName, exceptionClass must be not null");
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
        boolean replaced = false;
        for (PsiJavaCodeReferenceElement ref2 : refs) {
            if (exceptionClass != null && ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                if (replaced) {
                    ref2.delete();
                    continue;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(method.getProject());
                if (exceptionName != null) {
                    ref1 = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type = factory.createType(exceptionClass);
                    ref1 = factory.createReferenceElementByType(type);
                }
                ref2.replace(ref1);
                replaced = true;
                continue;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        if (replaced) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(method.getProject());
        if (exceptionName != null) {
            ref = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClass superClass;
            for (superClass = exceptionClass.getSuperClass(); superClass != null && PsiUtil.isLocalOrAnonymousClass(superClass); superClass = superClass.getSuperClass()) {
            }
            PsiClassType type = factory.createType(superClass != null ? superClass : exceptionClass);
            ref = factory.createReferenceElementByType(type);
        }
        throwsList.add(ref);
    }

    public static void removeException(@NotNull PsiMethod method, String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(23);
        }
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(@NotNull String name, @NotNull PsiElement place) {
        PsiResolveHelper helper;
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(24);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(25);
        }
        return (helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper()).resolveAccessibleReferencedVariable(name, place) == null;
    }

    @Nullable
    public static PsiElement getTopLevelEnclosingCodeBlock(@Nullable PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpression) || parent instanceof PsiLambdaExpression) {
                if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiMethod && parent.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent.getParent()) || parent instanceof PsiClassInitializer && !(parent.getParent() instanceof PsiAnonymousClass)) break;
                if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                    blockSoFar = element;
                }
                if (parent instanceof PsiClassLevelDeclarationStatement) {
                    parent = parent.getParent();
                }
                if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
                if (element instanceof PsiFile && PsiUtilCore.getTemplateLanguageFile(element) != null) {
                    return element;
                }
            }
            if (element == scope) break;
            element = parent;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(26);
        }
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(@NotNull PsiClass psiClass) {
        PsiElement parent;
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(27);
        }
        if ((parent = psiClass.getParent()) instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return true;
        }
        if (parent instanceof PsiClass) {
            return PsiUtil.isLocalOrAnonymousClass((PsiClass)parent);
        }
        return false;
    }

    public static boolean isAbstractClass(@NotNull PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(28);
        }
        return (modifierList = clazz.getModifierList()) != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(@NotNull PsiVariable variable, @Nullable PsiElement context2) {
        if (variable == null) {
            PsiUtil.$$$reportNull$$$0(29);
        }
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeBlock = ((PsiLambdaExpression)declarationScope).getBody();
            } else if (declarationScope instanceof PsiCodeBlock) {
                codeBlock = declarationScope;
            }
        } else {
            if (variable instanceof PsiResourceVariable) {
                PsiElement resourceList = variable.getParent();
                return resourceList != null ? resourceList.getParent() : null;
            }
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context2 != null) {
                PsiClass aClass = ((PsiField)variable).getContainingClass();
                while (context2 != null && context2.getParent() != aClass) {
                    if (!((context2 = context2.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context2 instanceof PsiMethod ? ((PsiMethod)context2).getBody() : (context2 instanceof PsiClassInitializer ? ((PsiClassInitializer)context2).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    @Contract(value="null -> false")
    public static boolean isIncrementDecrementOperation(@Nullable PsiElement element) {
        if (element instanceof PsiUnaryExpression) {
            IElementType sign = ((PsiUnaryExpression)element).getOperationTokenType();
            return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    public static @Unmodifiable @NotNull List<PsiExpression> getSwitchResultExpressions(@NotNull PsiSwitchExpression switchExpression) {
        PsiCodeBlock body;
        if (switchExpression == null) {
            PsiUtil.$$$reportNull$$$0(30);
        }
        if ((body = switchExpression.getBody()) != null) {
            PsiStatement[] statements;
            ArrayList<PsiExpression> result2 = new ArrayList<PsiExpression>();
            for (PsiStatement statement : statements = body.getStatements()) {
                if (statement instanceof PsiSwitchLabeledRuleStatement) {
                    PsiStatement ruleBody = ((PsiSwitchLabeledRuleStatement)statement).getBody();
                    if (ruleBody instanceof PsiExpressionStatement) {
                        result2.add(((PsiExpressionStatement)ruleBody).getExpression());
                        continue;
                    }
                    if (!(ruleBody instanceof PsiBlockStatement)) continue;
                    PsiUtil.collectSwitchResultExpressions(result2, ruleBody);
                    continue;
                }
                PsiUtil.collectSwitchResultExpressions(result2, statement);
            }
            ArrayList<PsiExpression> arrayList = result2;
            if (arrayList == null) {
                PsiUtil.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        List<PsiExpression> list = Collections.emptyList();
        if (list == null) {
            PsiUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static void collectSwitchResultExpressions(@NotNull List<? super PsiExpression> result2, @NotNull PsiElement container) {
        if (result2 == null) {
            PsiUtil.$$$reportNull$$$0(33);
        }
        if (container == null) {
            PsiUtil.$$$reportNull$$$0(34);
        }
        ArrayList yields = new ArrayList();
        PsiUtil.addStatements(yields, container, PsiYieldStatement.class, element -> element instanceof PsiSwitchExpression);
        for (PsiYieldStatement statement : yields) {
            ContainerUtil.addIfNotNull(result2, statement.getExpression());
        }
    }

    @AccessLevel
    public static int getAccessLevel(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            PsiUtil.$$$reportNull$$$0(35);
        }
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getAccessModifier(@AccessLevel int accessLevel) {
        String modifier;
        if (accessLevel <= 0 || accessLevel > accessModifiers.length) {
            throw new IllegalArgumentException("Unknown level:" + accessLevel);
        }
        String string2 = modifier = accessModifiers[accessLevel - 1];
        if (string2 == null) {
            PsiUtil.$$$reportNull$$$0(36);
        }
        return string2;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(37);
        }
        PsiElement parent = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            if (!(parent instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return parent instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)parent).getEnclosingSwitchBlock() instanceof PsiSwitchExpression || PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent instanceof PsiCodeBlock) {
                return true;
            }
            if (parent instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent instanceof PsiForStatement) || ((PsiForStatement)parent).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(@NotNull PsiElement scope, @NotNull TextRange range) {
        PsiElement psiElement;
        if (scope == null) {
            PsiUtil.$$$reportNull$$$0(38);
        }
        if (range == null) {
            PsiUtil.$$$reportNull$$$0(39);
        }
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolve();
        }
        return null;
    }

    @Nullable
    public static PsiClass resolveClassInClassTypeOnly(@Nullable PsiType type) {
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @NotNull
    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(@Nullable PsiType type) {
        PsiType lub;
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(40);
            }
            return classResolveResult;
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveGenericsClassInType(((PsiArrayType)type).getComponentType());
        }
        if (type instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type).getLeastUpperBound()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)lub).resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(41);
            }
            return classResolveResult;
        }
        PsiClassType.ClassResolveResult classResolveResult = PsiClassType.ClassResolveResult.EMPTY;
        if (classResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(42);
        }
        return classResolveResult;
    }

    @NotNull
    public static PsiType convertAnonymousToBaseType(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(43);
        }
        if ((psiClass = PsiUtil.resolveClassInType(type)) instanceof PsiAnonymousClass) {
            type = PsiTypesUtil.createArrayType(((PsiAnonymousClass)psiClass).getBaseClassType(), type.getArrayDimensions());
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiUtil.$$$reportNull$$$0(44);
        }
        return psiType;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(45);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(46);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(47);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, PsiExpression @NotNull [] argList) {
        PsiType[] types;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(48);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(49);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(50);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, types = ContainerUtil.map2Array(argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE), PsiUtil.getLanguageLevel(method)) != 1;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(51);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(52);
        }
        if (argList == null) {
            PsiUtil.$$$reportNull$$$0(53);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, PsiType @NotNull [] args2, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(54);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(55);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(56);
        }
        if (args2 == null) {
            PsiUtil.$$$reportNull$$$0(57);
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args2, languageLevel, true, true, ApplicabilityChecker.ASSIGNABILITY_CHECKER);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, PsiType @NotNull [] args2, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs, @NotNull ApplicabilityChecker function) {
        boolean isRaw;
        PsiParameter[] parameters;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(58);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(59);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(60);
        }
        if (function == null) {
            PsiUtil.$$$reportNull$$$0(61);
        }
        if (args2 == null) {
            PsiUtil.$$$reportNull$$$0(62);
        }
        if (args2.length < (parameters = method.getParameterList().getParameters()).length - 1) {
            return 1;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor(method, substitutorForMethod) && PsiUtil.isRawSubstitutor(containingClass, substitutorForMethod);
        if (!PsiUtil.areFirstArgumentsApplicable(args2, parameters, languageLevel, substitutorForMethod, isRaw, allowUncheckedConversion, function)) {
            return 1;
        }
        if (args2.length == parameters.length) {
            PsiType erasedParamType;
            if (parameters.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parameters[parameters.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args2[args2.length - 1];
            if (argType == null) {
                return 1;
            }
            if (function.isApplicable(parmType, argType, allowUncheckedConversion, parameters.length - 1)) {
                return 3;
            }
            if (isRaw && (erasedParamType = TypeConversionUtil.erasure(parmType)) != null && function.isApplicable(erasedParamType, argType, allowUncheckedConversion, parameters.length - 1)) {
                return 3;
            }
        }
        if (checkVarargs && method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            PsiParameter lastParameter;
            if (args2.length < parameters.length) {
                return 2;
            }
            PsiParameter psiParameter = lastParameter = parameters.length == 0 ? null : parameters[parameters.length - 1];
            if (lastParameter == null || !lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            if ((lastParmType = ((PsiArrayType)lastParmType).getComponentType()) instanceof PsiCapturedWildcardType && !JavaVersionService.getInstance().isAtLeast(((PsiCapturedWildcardType)lastParmType).getContext(), JavaSdkVersion.JDK_1_8)) {
                lastParmType = ((PsiCapturedWildcardType)lastParmType).getWildcard();
            }
            if (lastParmType instanceof PsiClassType) {
                lastParmType = ((PsiClassType)lastParmType).setLanguageLevel(languageLevel);
            }
            for (int i = parameters.length - 1; i < args2.length; ++i) {
                PsiType argType = args2[i];
                if (argType != null && function.isApplicable(lastParmType, argType, allowUncheckedConversion, i)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(PsiType @NotNull [] args2, PsiParameter @NotNull [] parameters, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutorForMethod, boolean isRaw, boolean allowUncheckedConversion, ApplicabilityChecker function) {
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(63);
        }
        if (substitutorForMethod == null) {
            PsiUtil.$$$reportNull$$$0(64);
        }
        if (args2 == null) {
            PsiUtil.$$$reportNull$$$0(65);
        }
        if (parameters == null) {
            PsiUtil.$$$reportNull$$$0(66);
        }
        for (int i = 0; i < parameters.length - 1; ++i) {
            PsiType substErasure;
            PsiType type = args2[i];
            if (type == null) {
                return false;
            }
            PsiParameter parameter = parameters[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (!(isRaw ? (substErasure = TypeConversionUtil.erasure(substitutedParmType)) != null && !function.isApplicable(substErasure, type, allowUncheckedConversion, i) : !function.isApplicable(substitutedParmType, type, allowUncheckedConversion, i))) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(@NotNull PsiParameter parameter, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutor) {
        PsiType parmType;
        if (parameter == null) {
            PsiUtil.$$$reportNull$$$0(67);
        }
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(68);
        }
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(69);
        }
        if ((parmType = parameter.getType()) instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor.substitute(parmType);
    }

    public static boolean equalOnEquivalentClasses(@NotNull PsiClassType thisClassType, @NotNull PsiClass aClass, @NotNull PsiClassType otherClassType, @NotNull PsiClass bClass) {
        if (thisClassType == null) {
            PsiUtil.$$$reportNull$$$0(70);
        }
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(71);
        }
        if (otherClassType == null) {
            PsiUtil.$$$reportNull$$$0(72);
        }
        if (bClass == null) {
            PsiUtil.$$$reportNull$$$0(73);
        }
        PsiClassType capture1 = !PsiCapturedWildcardType.isCapture() ? thisClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(thisClassType, aClass);
        PsiClassType capture2 = !PsiCapturedWildcardType.isCapture() ? otherClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(otherClassType, bClass);
        PsiClassType.ClassResolveResult result1 = capture1.resolveGenerics();
        PsiClassType.ClassResolveResult result2 = capture2.resolveGenerics();
        return PsiUtil.equalOnEquivalentClasses(result1.getSubstitutor(), aClass, result2.getSubstitutor(), bClass);
    }

    private static boolean equalOnEquivalentClasses(@NotNull PsiSubstitutor s1, @NotNull PsiClass aClass, @NotNull PsiSubstitutor s2, @NotNull PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (s1 == null) {
            PsiUtil.$$$reportNull$$$0(74);
        }
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(75);
        }
        if (s2 == null) {
            PsiUtil.$$$reportNull$$$0(76);
        }
        if (bClass == null) {
            PsiUtil.$$$reportNull$$$0(77);
        }
        if (s1 == s2 && aClass == bClass) {
            return true;
        }
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiType substituted2 = s2.substitute(typeParameters2[i]);
            PsiType substituted1 = s1.substitute(typeParameters1[i]);
            if (Comparing.equal(substituted1, substituted2)) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        if (containingClass1 == null && containingClass2 == null) {
            if (aClass == bClass && PsiUtil.isLocalClass(aClass)) {
                PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
                return containingClass != null && PsiUtil.equalOnEquivalentClasses(s1, containingClass, s2, containingClass);
            }
            return true;
        }
        return false;
    }

    public static boolean isCompileTimeConstant(@NotNull PsiVariable field) {
        if (field == null) {
            PsiUtil.$$$reportNull$$$0(78);
        }
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        PsiType type = field.getType();
        return (TypeConversionUtil.isPrimitiveAndNotNull(type) || type.equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(PsiMethod @NotNull [] methods) {
        if (methods == null) {
            PsiUtil.$$$reportNull$$$0(79);
        }
        if (methods.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(value="null -> null")
    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(80);
        }
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList, String modifier) {
        PsiElement[] children2;
        if (modifierList == null) {
            PsiUtil.$$$reportNull$$$0(81);
        }
        for (PsiElement child : children2 = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element) {
        PsiClass topClass;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(82);
        }
        return (topClass = JBIterable.generate(element, PsiElement::getParent).takeWhile(e -> !(e instanceof PsiFile)).filter(PsiClass.class).last()) instanceof PsiTypeParameter ? null : topClass;
    }

    @NlsSafe
    @Nullable
    public static String getPackageName(@NotNull PsiClass aClass) {
        String fqName;
        PsiClass topClass;
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(83);
        }
        if ((topClass = PsiUtil.getTopLevelClass(aClass)) != null && (fqName = topClass.getQualifiedName()) != null) {
            return StringUtil.getPackageName(fqName);
        }
        PsiFile file2 = aClass.getContainingFile();
        if (file2 instanceof PsiClassOwner) {
            return ((PsiClassOwner)file2).getPackageName();
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(@NotNull PsiElement place, @Nullable PsiClass aClass) {
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(84);
        }
        LOG.assertTrue(aClass == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass, place, false));
        for (PsiElement parent = place; parent != aClass; parent = parent.getContext()) {
            if (parent == null) {
                return null;
            }
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(85);
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    @NotNull
    public static PsiType captureToplevelWildcards(@NotNull PsiType type, @NotNull PsiElement context2) {
        PsiClassType.ClassResolveResult result2;
        PsiClass aClass;
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(86);
        }
        if (context2 == null) {
            PsiUtil.$$$reportNull$$$0(87);
        }
        if (type instanceof PsiClassType && (aClass = (result2 = ((PsiClassType)type).resolveGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor;
            PsiSubstitutor captureSubstitutor = substitutor = result2.getSubstitutor();
            for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substituted = substitutor.substitute(psiTypeParameter);
                if (!(substituted instanceof PsiWildcardType)) continue;
                captureSubstitutor = captureSubstitutor.put(psiTypeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context2, psiTypeParameter));
            }
            if (captureSubstitutor != substitutor) {
                HashMap<PsiTypeParameter, PsiType> substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiCapturedWildcardType capturedWildcard;
                    PsiType substituted = substitutor.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap<PsiTypeParameter, PsiType>(substitutor.getSubstitutionMap());
                    }
                    LOG.assertTrue((capturedWildcard = (PsiCapturedWildcardType)captureSubstitutor.substitute(typeParameter)) != null);
                    PsiType upperBound = PsiCapturedWildcardType.captureUpperBound(typeParameter, (PsiWildcardType)substituted, captureSubstitutor);
                    if (upperBound != null) {
                        capturedWildcard.setUpperBound(upperBound);
                    }
                    substitutionMap.put(typeParameter, capturedWildcard);
                }
                if (substitutionMap != null) {
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory(aClass.getProject());
                    PsiSubstitutor newSubstitutor = psiElementFactory.createSubstitutor(substitutionMap);
                    PsiClassType psiClassType = psiElementFactory.createType(aClass, newSubstitutor);
                    if (psiClassType == null) {
                        PsiUtil.$$$reportNull$$$0(88);
                    }
                    return psiClassType;
                }
            }
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiUtil.$$$reportNull$$$0(89);
        }
        return psiType;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true, PsiMember.class) != null;
    }

    @NotNull
    public static @Unmodifiable List<PsiTypeElement> getParameterTypeElements(@NotNull PsiParameter parameter) {
        PsiTypeElement typeElement;
        if (parameter == null) {
            PsiUtil.$$$reportNull$$$0(90);
        }
        List<PsiTypeElement> list = (typeElement = parameter.getTypeElement()) != null && typeElement.getType() instanceof PsiDisjunctionType ? PsiTreeUtil.getChildrenOfTypeAsList(typeElement, PsiTypeElement.class) : Collections.singletonList(typeElement);
        if (list == null) {
            PsiUtil.$$$reportNull$$$0(91);
        }
        return list;
    }

    public static void checkIsIdentifier(@NotNull PsiManager manager, String text2) throws IncorrectOperationException {
        if (manager == null) {
            PsiUtil.$$$reportNull$$$0(92);
        }
        if (!PsiNameHelper.getInstance(manager.getProject()).isIdentifier(text2)) {
            throw new IncorrectOperationException(JavaPsiBundle.message("0.is.not.an.identifier", text2));
        }
    }

    @Nullable
    public static VirtualFile getJarFile(@NotNull PsiElement candidate) {
        VirtualFile file2;
        if (candidate == null) {
            PsiUtil.$$$reportNull$$$0(93);
        }
        if ((file2 = candidate.getContainingFile().getVirtualFile()) != null && file2.getFileSystem().getProtocol().equals("jar")) {
            return VfsUtilCore.getVirtualFileForJar(file2);
        }
        return file2;
    }

    public static boolean isAnnotationMethod(PsiElement element) {
        if (!(element instanceof PsiAnnotationMethod)) {
            return false;
        }
        PsiClass psiClass = ((PsiAnnotationMethod)element).getContainingClass();
        return psiClass != null && psiClass.isAnnotationType();
    }

    @PsiModifier.ModifierConstant
    public static String getSuitableModifierForMember(@Nullable PsiClass aClass, boolean constructor) {
        String modifier = "public";
        if (!(aClass == null || aClass.isRecord() && !constructor || aClass.isInterface())) {
            if (aClass.hasModifierProperty("packageLocal") || constructor && aClass.isEnum()) {
                modifier = "packageLocal";
            } else if (aClass.hasModifierProperty("private")) {
                modifier = "private";
            } else if (aClass.hasModifierProperty("protected") || constructor && aClass.hasModifierProperty("abstract") && aClass.hasModifierProperty("public")) {
                modifier = "protected";
            }
        }
        return modifier;
    }

    @NotNull
    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(94);
        }
        Iterator<PsiTypeParameter> iterator2 = PsiUtil.typeParametersIterable(owner).iterator();
        if (iterator2 == null) {
            PsiUtil.$$$reportNull$$$0(95);
        }
        return iterator2;
    }

    @NotNull
    public static Iterable<PsiTypeParameter> typeParametersIterable(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(96);
        }
        Iterable result2 = null;
        PsiTypeParameterListOwner currentOwner = owner;
        while (currentOwner != null) {
            final PsiTypeParameter[] typeParameters = currentOwner.getTypeParameters();
            if (typeParameters.length > 0) {
                Iterable iterable = () -> new Iterator<PsiTypeParameter>(){
                    int idx;
                    {
                        this.idx = typeParameters.length - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx >= 0;
                    }

                    @Override
                    public PsiTypeParameter next() {
                        if (this.idx < 0) {
                            throw new NoSuchElementException();
                        }
                        return typeParameters[this.idx--];
                    }
                };
                result2 = result2 == null ? iterable : ContainerUtil.concat(result2, iterable);
            }
            if (currentOwner.hasModifierProperty("static")) break;
            if (currentOwner instanceof PsiClass && PsiUtil.isLocalClass((PsiClass)currentOwner)) {
                currentOwner = PsiTreeUtil.getParentOfType((PsiElement)currentOwner, PsiTypeParameterListOwner.class);
                continue;
            }
            currentOwner = currentOwner.getContainingClass();
        }
        if (result2 == null) {
            List<PsiTypeParameter> list = Collections.emptyList();
            if (list == null) {
                PsiUtil.$$$reportNull$$$0(97);
            }
            return list;
        }
        Iterable iterable = result2;
        if (iterable == null) {
            PsiUtil.$$$reportNull$$$0(98);
        }
        return iterable;
    }

    public static boolean canBeOverridden(@NotNull PsiMethod method) {
        PsiClass parentClass;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(99);
        }
        return (parentClass = method.getContainingClass()) != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    public static PsiElement @NotNull [] mapElements(ResolveResult @NotNull [] candidates) {
        if (candidates == null) {
            PsiUtil.$$$reportNull$$$0(100);
        }
        PsiElement[] result2 = new PsiElement[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            result2[i] = candidates[i].getElement();
        }
        if (result2 == null) {
            PsiUtil.$$$reportNull$$$0(101);
        }
        return result2;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiEnumConstantInitializer.class, PsiMethod.class, PsiField.class);
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            return null;
        }
        return parent;
    }

    public static boolean checkName(@NotNull PsiElement element, @NotNull String name, @NotNull PsiElement context2) {
        PsiMetaData data;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(102);
        }
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(103);
        }
        if (context2 == null) {
            PsiUtil.$$$reportNull$$$0(104);
        }
        if (element instanceof PsiVariable && ((PsiVariable)element).isUnnamed()) {
            return false;
        }
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            return name.equals(data.getName(context2));
        }
        return element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, @NotNull PsiSubstitutor substitutor) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(105);
        }
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(106);
        }
        if (substitutor == PsiSubstitutor.EMPTY) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(107);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_5);
    }

    public static boolean isLanguageLevel6OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(108);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_6);
    }

    public static boolean isLanguageLevel7OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(109);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_7);
    }

    public static boolean isLanguageLevel8OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(110);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static boolean isLanguageLevel9OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(111);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_9);
    }

    public static boolean isLanguageLevel10OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(112);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_10);
    }

    public static boolean isLanguageLevel11OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(113);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_11);
    }

    public static boolean isLanguageLevel14OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(114);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_14);
    }

    public static boolean isLanguageLevel16OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(115);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_16);
    }

    public static boolean isLanguageLevel17OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(116);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_17);
    }

    public static boolean isLanguageLevel18OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(117);
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_18);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        PsiElement context2;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(118);
        }
        if (element instanceof PsiDirectory) {
            LanguageLevel languageLevel = JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element);
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(119);
            }
            return languageLevel;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof PsiJavaFile) {
            LanguageLevel languageLevel = ((PsiJavaFile)file2).getLanguageLevel();
            if (languageLevel == null) {
                PsiUtil.$$$reportNull$$$0(120);
            }
            return languageLevel;
        }
        if (file2 != null && (context2 = file2.getContext()) != null) {
            if (!context2.isValid()) {
                throw new PsiInvalidElementAccessException(context2, "Invalid context in " + file2 + " of " + file2.getClass());
            }
            return PsiUtil.getLanguageLevel(context2);
        }
        PsiResolveHelper instance = PsiResolveHelper.getInstance(element.getProject());
        LanguageLevel languageLevel = instance != null ? instance.getEffectiveLanguageLevel(PsiUtil.getVirtualFile(file2)) : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(121);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        LanguageLevelProjectExtension instance;
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(122);
        }
        LanguageLevel languageLevel = (instance = LanguageLevelProjectExtension.getInstance(project)) != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            PsiUtil.$$$reportNull$$$0(123);
        }
        return languageLevel;
    }

    public static boolean isInstantiatable(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(124);
        }
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(125);
        }
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(126);
        }
        return PsiUtil.hasDefaultConstructor(clazz, allowProtected, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected, boolean allowPrivateAndPackagePrivate) {
        PsiMethod[] constructors;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(127);
        }
        if ((constructors = clazz.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod cls : constructors) {
            if (!cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) && (!allowPrivateAndPackagePrivate || cls.hasModifierProperty("protected")) || !cls.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiType extractIterableTypeParameter(@Nullable PsiType psiType, boolean eraseTypeParameter) {
        PsiType type = PsiUtil.substituteTypeParameter(psiType, "java.lang.Iterable", 0, eraseTypeParameter);
        return type != null ? type : PsiUtil.substituteTypeParameter(psiType, "java.util.Collection", 0, eraseTypeParameter);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, @NotNull String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        if (superClass == null) {
            PsiUtil.$$$reportNull$$$0(128);
        }
        if ((psiClass = (classResolveResult = PsiUtil.resolveClass(psiType)).getElement()) == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        return PsiUtil.substituteType(typeParamIndex, eraseTypeParameter, classResolveResult, psiClass, baseClass);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, @NotNull PsiClass superClass, int typeParamIndex, boolean eraseTypeParameter) {
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass psiClass;
        if (superClass == null) {
            PsiUtil.$$$reportNull$$$0(129);
        }
        if ((psiClass = (classResolveResult = PsiUtil.resolveClass(psiType)).getElement()) == null) {
            return null;
        }
        return PsiUtil.substituteType(typeParamIndex, eraseTypeParameter, classResolveResult, psiClass, superClass);
    }

    private static PsiClassType.ClassResolveResult resolveClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolveGenerics() : PsiClassType.ClassResolveResult.EMPTY;
    }

    @Nullable
    private static PsiType substituteType(int typeParamIndex, boolean eraseTypeParameter, PsiClassType.ClassResolveResult classResolveResult, PsiClass psiClass, PsiClass baseClass) {
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters = baseClass.getTypeParameters();
        if (parameters.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type = substitutor.substitute(parameters[typeParamIndex]);
        if (type == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters[typeParamIndex]);
        }
        return type;
    }

    public static void setModifierProperty(@NotNull PsiModifierListOwner owner, @NotNull @PsiModifier.ModifierConstant String property, boolean value) {
        if (owner == null) {
            PsiUtil.$$$reportNull$$$0(130);
        }
        if (property == null) {
            PsiUtil.$$$reportNull$$$0(131);
        }
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null) : owner;
        modifierList.setModifierProperty(property, value);
    }

    public static boolean isElseBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getElseBranch();
    }

    public static boolean isJavaToken(@Nullable PsiElement element, IElementType type) {
        return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == type;
    }

    public static boolean isJavaToken(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            PsiUtil.$$$reportNull$$$0(132);
        }
        return element instanceof PsiJavaToken && types.contains(((PsiJavaToken)element).getTokenType());
    }

    public static boolean isCatchParameter(@Nullable PsiElement element) {
        return element instanceof PsiParameter && element.getParent() instanceof PsiCatchSection;
    }

    public static boolean isIgnoredName(@Nullable String name) {
        return name != null && IGNORED_NAMES.matcher(name).matches();
    }

    public static PsiMethod @Nullable [] getResourceCloserMethodsForType(@NotNull PsiClassType resourceType) {
        PsiClass resourceClass;
        if (resourceType == null) {
            PsiUtil.$$$reportNull$$$0(133);
        }
        if ((resourceClass = resourceType.resolve()) == null) {
            return null;
        }
        Project project = resourceClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable == null) {
            return null;
        }
        if (JavaClassSupers.getInstance().getSuperClassSubstitutor(autoCloseable, resourceClass, resourceType.getResolveScope(), PsiSubstitutor.EMPTY) == null) {
            return null;
        }
        PsiMethod[] closes = autoCloseable.findMethodsByName("close", false);
        if (closes.length == 1) {
            return resourceClass.findMethodsBySignature(closes[0], true);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression skipParenthesizedExprDown(@Nullable PsiExpression expression) {
        while (expression instanceof PsiParenthesizedExpression) {
            expression = ((PsiParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    public static PsiElement skipParenthesizedExprUp(@Nullable PsiElement parent) {
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static void ensureValidType(@NotNull PsiType type) {
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(134);
        }
        PsiUtil.ensureValidType(type, (String)null);
    }

    public static void ensureValidType(@NotNull PsiType type, @Nullable PsiElement sourceOfType) {
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(135);
        }
        try {
            PsiUtil.ensureValidType(type);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (sourceOfType == null) {
                throw e;
            }
            PsiUtilCore.ensureValid(sourceOfType);
            throw new RuntimeException("Via " + sourceOfType.getClass() + " #" + sourceOfType.getLanguage(), e);
        }
    }

    public static void ensureValidType(@NotNull PsiType type, @Nullable String customMessage) {
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(136);
        }
        if (!type.isValid()) {
            TimeoutUtil.sleep(1L);
            if (type.isValid()) {
                LOG.error("PsiType resurrected: " + type + " of " + type.getClass() + " " + customMessage);
                return;
            }
            if (type instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (customMessage == null) {
                        throw e;
                    }
                    throw new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type + " of class " + type.getClass() + " " + customMessage));
        }
    }

    @Nullable
    public static String getMemberQualifiedName(@NotNull PsiMember member) {
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(137);
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        return className + "." + member.getName();
    }

    public static boolean isFromDefaultPackage(PsiClass aClass) {
        return PsiUtil.isFromDefaultPackage((PsiElement)aClass);
    }

    public static boolean isFromDefaultPackage(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            return StringUtil.isEmpty(((PsiClassOwner)containingFile).getPackageName());
        }
        if (containingFile instanceof JavaCodeFragment) {
            PsiElement context2 = containingFile.getContext();
            if (context2 instanceof PsiPackage) {
                return StringUtil.isEmpty(((PsiPackage)context2).getName());
            }
            if (context2 != null && context2 != containingFile) {
                return PsiUtil.isFromDefaultPackage(context2);
            }
        }
        return false;
    }

    static boolean checkSameExpression(PsiElement templateExpr, PsiExpression expression) {
        return templateExpr.equals(PsiUtil.skipParenthesizedExprDown(expression));
    }

    public static boolean isCondition(PsiElement expr, PsiElement parent) {
        if (parent instanceof PsiIfStatement) {
            return PsiUtil.checkSameExpression(expr, ((PsiIfStatement)parent).getCondition());
        }
        if (parent instanceof PsiConditionalLoopStatement) {
            return PsiUtil.checkSameExpression(expr, ((PsiConditionalLoopStatement)parent).getCondition());
        }
        if (parent instanceof PsiConditionalExpression) {
            return PsiUtil.checkSameExpression(expr, ((PsiConditionalExpression)parent).getCondition());
        }
        return false;
    }

    public static PsiReturnStatement @NotNull [] findReturnStatements(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(138);
        }
        return PsiUtil.findReturnStatements(method.getBody());
    }

    public static PsiReturnStatement @NotNull [] findReturnStatements(@Nullable PsiCodeBlock body) {
        ArrayList vector = new ArrayList();
        if (body != null) {
            PsiUtil.addStatements(vector, body, PsiReturnStatement.class, statement -> false);
        }
        PsiReturnStatement[] psiReturnStatementArray = vector.toArray(PsiReturnStatement.EMPTY_ARRAY);
        if (psiReturnStatementArray == null) {
            PsiUtil.$$$reportNull$$$0(139);
        }
        return psiReturnStatementArray;
    }

    private static <T extends PsiElement> void addStatements(@NotNull List<? super T> vector, @NotNull PsiElement element, @NotNull Class<? extends T> clazz, @NotNull Predicate<? super PsiElement> stopAt) {
        if (vector == null) {
            PsiUtil.$$$reportNull$$$0(140);
        }
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(141);
        }
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(142);
        }
        if (stopAt == null) {
            PsiUtil.$$$reportNull$$$0(143);
        }
        if (PsiTreeUtil.instanceOf(element, clazz)) {
            vector.add(element);
        } else if (!(element instanceof PsiClass || element instanceof PsiLambdaExpression || stopAt.test(element))) {
            PsiElement[] children2;
            for (PsiElement child : children2 = element.getChildren()) {
                PsiUtil.addStatements(vector, child, clazz, stopAt);
            }
        }
    }

    public static boolean isModuleFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiUtil.$$$reportNull$$$0(144);
        }
        return file2 instanceof PsiJavaFile && ((PsiJavaFile)file2).getModuleDeclaration() != null;
    }

    public static boolean isPackageEmpty(PsiDirectory @NotNull [] directories, @NotNull String packageName) {
        if (packageName == null) {
            PsiUtil.$$$reportNull$$$0(145);
        }
        if (directories == null) {
            PsiUtil.$$$reportNull$$$0(146);
        }
        for (PsiDirectory directory : directories) {
            for (PsiFile file2 : directory.getFiles()) {
                if (!(file2 instanceof PsiClassOwner) || !packageName.equals(((PsiClassOwner)file2).getPackageName()) || ((PsiClassOwner)file2).getClasses().length <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static PsiModifierListOwner preferCompiledElement(@NotNull PsiModifierListOwner element) {
        PsiElement original;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(147);
        }
        PsiModifierListOwner psiModifierListOwner = (original = element.getOriginalElement()) instanceof PsiModifierListOwner ? (PsiModifierListOwner)original : element;
        if (psiModifierListOwner == null) {
            PsiUtil.$$$reportNull$$$0(148);
        }
        return psiModifierListOwner;
    }

    public static PsiElement addModuleStatement(@NotNull PsiJavaModule module, @NotNull String text2) {
        if (module == null) {
            PsiUtil.$$$reportNull$$$0(149);
        }
        if (text2 == null) {
            PsiUtil.$$$reportNull$$$0(150);
        }
        PsiJavaParserFacade facade = JavaPsiFacade.getInstance(module.getProject()).getParserFacade();
        PsiStatement statement = facade.createModuleStatementFromText(text2, null);
        return PsiUtil.addModuleStatement(module, statement);
    }

    public static PsiElement addModuleStatement(@NotNull PsiJavaModule module, @NotNull PsiStatement moduleStatement) {
        PsiElement anchor;
        if (module == null) {
            PsiUtil.$$$reportNull$$$0(151);
        }
        if (moduleStatement == null) {
            PsiUtil.$$$reportNull$$$0(152);
        }
        if ((anchor = (PsiElement)SyntaxTraverser.psiTraverser().children(module).filter(moduleStatement.getClass()).last()) == null) {
            anchor = SyntaxTraverser.psiTraverser().children(module).filter(e -> PsiUtil.isJavaToken(e, JavaTokenType.LBRACE)).first();
        }
        if (anchor == null) {
            throw new IllegalStateException("No anchor in " + Arrays.toString(module.getChildren()));
        }
        return module.addAfter(moduleStatement, anchor);
    }

    public static boolean isArrayClass(@Nullable PsiElement psiClass) {
        return psiClass instanceof PsiClass && JavaPsiFacade.getElementFactory(psiClass.getProject()).isArrayClass((PsiClass)psiClass);
    }

    @Contract(value="null -> false")
    public static boolean isJvmLocalVariable(PsiElement variable) {
        return variable instanceof PsiLocalVariable || variable instanceof PsiParameter;
    }

    public static boolean isFollowedByImport(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(153);
        }
        if ((parent = element.getParent()) instanceof PsiImportList) {
            PsiImportList importList = (PsiImportList)parent;
            PsiImportStatementBase @NotNull [] imports = importList.getAllImportStatements();
            if (imports.length == 0) {
                return false;
            }
            return imports[imports.length - 1].getStartOffsetInParent() > element.getStartOffsetInParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 88: 
            case 89: 
            case 91: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 139: 
            case 148: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 88: 
            case 89: 
            case 91: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 139: 
            case 148: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 37: 
            case 82: 
            case 85: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 141: 
            case 147: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 17: 
            case 25: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 88: 
            case 89: 
            case 91: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 139: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiUtil";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 58: 
            case 99: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionFQName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 24: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 28: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 35: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 43: 
            case 86: 
            case 134: 
            case 135: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutorForMethod";
                break;
            }
            case 47: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 56: 
            case 60: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 57: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 67: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 69: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisClassType";
                break;
            }
            case 71: 
            case 75: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherClassType";
                break;
            }
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bClass";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 87: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 94: 
            case 96: 
            case 105: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 128: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vector";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 149: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessObjectClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchResultExpressions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenericsClassInType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAnonymousToBaseType";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "captureToplevelWildcards";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeElements";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "typeParametersIterator";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "typeParametersIterable";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "mapElements";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "findReturnStatements";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "preferCompiledElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isOnAssignmentLeftHand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromPackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForReading";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isMemberAccessibleAt";
                break;
            }
            case 12: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAccessObjectClass";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 88: 
            case 89: 
            case 91: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 139: 
            case 148: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeException";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isVariableNameUnique";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLocalOrAnonymousClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isLocalClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVariableCodeBlock";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchResultExpressions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectSwitchResultExpressions";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getAccessLevel";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isStatement";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getElementInclusiveRange";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "convertAnonymousToBaseType";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getApplicabilityLevel";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "areFirstArgumentsApplicable";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "equalOnEquivalentClasses";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isCompileTimeConstant";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "allMethodsHaveSameSignature";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isInnerClass";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findModifierInList";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClass";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingStaticElement";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByPsiElement";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "captureToplevelWildcards";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeElements";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "checkIsIdentifier";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getJarFile";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersIterator";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersIterable";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "canBeOverridden";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "mapElements";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isRawSubstitutor";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel5OrHigher";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel6OrHigher";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel7OrHigher";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel8OrHigher";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel9OrHigher";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel10OrHigher";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel11OrHigher";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel14OrHigher";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel16OrHigher";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel17OrHigher";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevel18OrHigher";
                break;
            }
            case 118: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiatable";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypeParameter";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "isJavaToken";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getResourceCloserMethodsForType";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidType";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getMemberQualifiedName";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "findReturnStatements";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "addStatements";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "isPackageEmpty";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "preferCompiledElement";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "addModuleStatement";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "isFollowedByImport";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 88: 
            case 89: 
            case 91: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 139: 
            case 148: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ApplicabilityChecker {
        public static final ApplicabilityChecker ASSIGNABILITY_CHECKER = (left, right, allowUncheckedConversion, argId) -> TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);

        public boolean isApplicable(PsiType var1, PsiType var2, boolean var3, int var4);
    }

    public static @interface AccessLevel {
    }
}

