/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiConcatenationUtil {
    public static String buildUnescapedFormatString(PsiExpression concatenation, boolean printfFormat, List<? super PsiExpression> formatParameters) {
        StringBuilder result2 = new StringBuilder();
        PsiConcatenationUtil.buildFormatString(concatenation, result2, formatParameters, printfFormat, false);
        return result2.toString();
    }

    private static void buildFormatString(PsiExpression expression, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat, boolean escape) {
        if (expression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
            String value = String.valueOf(literalExpression.getValue());
            String text2 = escape ? StringUtil.escapeStringCharacters(value) : value;
            String formatText = PsiConcatenationUtil.formatString(text2, printfFormat);
            formatString.append(formatText);
        } else if (expression instanceof PsiPolyadicExpression) {
            PsiType type = expression.getType();
            if (type != null && type.equalsToText("java.lang.String")) {
                boolean stringStarted;
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = binaryExpression.getOperands();
                PsiType first2 = operands[0].getType();
                PsiType second2 = operands[1].getType();
                boolean bl = stringStarted = first2 != null && first2.equalsToText("java.lang.String") || second2 != null && second2.equalsToText("java.lang.String");
                if (stringStarted) {
                    PsiConcatenationUtil.buildFormatString(operands[0], formatString, formatParameters, printfFormat, escape);
                }
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression op = operands[i];
                    PsiType optype = op.getType();
                    PsiType r = TypeConversionUtil.calcTypeForBinaryExpression(first2, optype, binaryExpression.getOperationTokenType(), true);
                    if (r != null && r.equalsToText("java.lang.String") && !stringStarted) {
                        stringStarted = true;
                        PsiElement element = binaryExpression.getTokenBeforeOperand(op);
                        assert (element != null);
                        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                            element = element.getPrevSibling();
                        }
                        String text3 = binaryExpression.getText().substring(0, element.getStartOffsetInParent());
                        PsiExpression subExpression = JavaPsiFacade.getElementFactory(binaryExpression.getProject()).createExpressionFromText(text3, binaryExpression);
                        PsiConcatenationUtil.addFormatParameter(subExpression, formatString, formatParameters, printfFormat);
                    }
                    if (stringStarted) {
                        if (optype != null && (optype.equalsToText("java.lang.String") || PsiTypes.charType().equals(optype))) {
                            PsiConcatenationUtil.buildFormatString(op, formatString, formatParameters, printfFormat, escape);
                        } else {
                            PsiConcatenationUtil.addFormatParameter(op, formatString, formatParameters, printfFormat);
                        }
                    }
                    first2 = r;
                }
            } else {
                PsiConcatenationUtil.addFormatParameter(expression, formatString, formatParameters, printfFormat);
            }
        } else {
            PsiConcatenationUtil.addFormatParameter(expression, formatString, formatParameters, printfFormat);
        }
    }

    @NotNull
    public static String formatString(String text2, boolean printfFormat) {
        if (printfFormat) {
            String string2 = text2.replace("%", "%%").replace("\\'", "'");
            if (string2 == null) {
                PsiConcatenationUtil.$$$reportNull$$$0(0);
            }
            return string2;
        }
        String string3 = text2.replace("'", "''").replaceAll("([{}]+)", "'$1'");
        if (string3 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(1);
        }
        return string3;
    }

    private static void addFormatParameter(@NotNull PsiExpression expression, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat) {
        if (expression == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(2);
        }
        PsiType type = expression.getType();
        if (!printfFormat) {
            formatString.append("{").append(formatParameters.size()).append("}");
        } else if (type != null && (type.equalsToText("long") || type.equalsToText("int") || type.equalsToText("java.lang.Long") || type.equalsToText("java.lang.Integer"))) {
            formatString.append("%d");
        } else {
            formatString.append("%s");
        }
        formatParameters.add(PsiConcatenationUtil.getBoxedArgument(expression));
    }

    private static PsiExpression getBoxedArgument(@NotNull PsiExpression arg2) {
        if (arg2 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isLanguageLevel5OrHigher(arg2 = ObjectUtils.coalesce(PsiConcatenationUtil.unwrapExpression(arg2), arg2))) {
            return arg2;
        }
        PsiType type = arg2.getType();
        if (!(type instanceof PsiPrimitiveType) || type.equals(PsiTypes.nullType())) {
            return arg2;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)type;
        String boxedQName = primitiveType.getBoxedTypeName();
        if (boxedQName == null) {
            return arg2;
        }
        GlobalSearchScope resolveScope = arg2.getResolveScope();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(arg2.getProject());
        PsiJavaCodeReferenceElement ref = factory.createReferenceElementByFQClassName(boxedQName, resolveScope);
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText("new A(b)", null);
        PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
        assert (classRef != null);
        classRef.replace(ref);
        PsiExpressionList argumentList = newExpr.getArgumentList();
        assert (argumentList != null);
        argumentList.getExpressions()[0].replace(arg2);
        return newExpr;
    }

    @Nullable
    private static PsiExpression unwrapExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(4);
        }
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiType castType = typeCastExpression.getType();
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                return expression;
            }
            if (TypeConversionUtil.isNumericType(castType)) {
                int operandRank;
                PsiType operandType = operand.getType();
                if (operandType == null) {
                    return expression;
                }
                int castRank = TypeConversionUtil.getTypeRank(castType);
                if (castRank < (operandRank = TypeConversionUtil.getTypeRank(operandType)) || castRank == 3 && operandRank != castRank) {
                    return expression;
                }
            }
            expression = operand;
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiConcatenationUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiConcatenationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFormatParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedArgument";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unwrapExpression";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

