/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtilBase {
    @NonNls
    protected static final String GET_PREFIX = PropertyKind.GETTER.prefix;
    @NonNls
    protected static final String IS_PREFIX = PropertyKind.BOOLEAN_GETTER.prefix;
    @NotNull
    protected static final String SET_PREFIX = PropertyKind.SETTER.prefix;
    @NonNls
    @PsiModifier.ModifierConstant
    private static final @NonNls String @NotNull [] ONLY_PUBLIC = new String[]{"public"};

    @Nullable
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(0);
        }
        return StringUtil.getPropertyName(methodName);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(1);
        }
        return PropertyUtilBase.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(2);
        }
        return PropertyUtilBase.getAllProperties(acceptSetters, acceptGetters, includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods());
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, PsiMethod[] methods) {
        return PropertyUtilBase.getAllProperties(acceptSetters, acceptGetters, false, ONLY_PUBLIC, methods);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, boolean acceptStatic, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels, PsiMethod[] methods) {
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(3);
        }
        return PropertyUtilBase.getAllProperties(acceptSetters, acceptGetters, acceptStatic, false, visibilityLevels, methods);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, boolean acceptStatic, boolean acceptBoxedBooleanIsPrefix, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels, PsiMethod[] methods) {
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(4);
        }
        HashMap<String, PsiMethod> map2 = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods) {
            if (PropertyUtilBase.filterMethods(method, acceptStatic, visibilityLevels) || (!acceptSetters || !PropertyUtilBase.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtilBase.isSimplePropertyGetter(method, acceptBoxedBooleanIsPrefix))) continue;
            map2.put(PropertyUtilBase.getPropertyName(method), method);
        }
        HashMap<String, PsiMethod> hashMap = map2;
        if (hashMap == null) {
            PropertyUtilBase.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    public static Pair<Map<String, PsiMethod>, Map<String, PsiMethod>> getAllAccessors(boolean acceptSetters, boolean acceptGetters, boolean acceptStatic, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels, PsiMethod @NotNull [] methods) {
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(6);
        }
        if (methods == null) {
            PropertyUtilBase.$$$reportNull$$$0(7);
        }
        HashMap<String, PsiMethod> getters = new HashMap<String, PsiMethod>();
        HashMap<String, PsiMethod> setters = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods) {
            if (PropertyUtilBase.filterMethods(method, acceptStatic, visibilityLevels)) continue;
            if (acceptGetters && PropertyUtilBase.isSimplePropertyGetter(method)) {
                getters.put(PropertyUtilBase.getPropertyNameByGetter(method), method);
            }
            if (!acceptSetters || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            setters.put(PropertyUtilBase.getPropertyNameBySetter(method), method);
        }
        Pair<Map<String, PsiMethod>, Map<String, PsiMethod>> pair = Pair.create(getters, setters);
        if (pair == null) {
            PropertyUtilBase.$$$reportNull$$$0(8);
        }
        return pair;
    }

    private static boolean filterMethods(PsiMethod method, boolean acceptStatic, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels) {
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(9);
        }
        if (!acceptStatic && method.hasModifierProperty("static") || !ContainerUtil.exists(visibilityLevels, it -> method.hasModifierProperty((String)it))) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className = psiClass.getQualifiedName();
        return "java.lang.Object".equals(className);
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(10);
        }
        return PropertyUtilBase.getSetters(psiClass, propertyName, false, ONLY_PUBLIC);
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName, boolean acceptStatic, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(11);
        }
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(12);
        }
        String setterName = PropertyUtilBase.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtilBase.filterMethods(method, acceptStatic, visibilityLevels) || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            list.add(method);
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            PropertyUtilBase.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(14);
        }
        return PropertyUtilBase.getGetters(psiClass, propertyName, false, ONLY_PUBLIC);
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName, boolean acceptStatic, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(15);
        }
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(16);
        }
        String[] names = PropertyUtilBase.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (String name : names) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtilBase.filterMethods(method, acceptStatic, visibilityLevels) || !PropertyUtilBase.isSimplePropertyGetter(method)) continue;
                list.add(method);
            }
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            PropertyUtilBase.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getAccessors(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(18);
        }
        return PropertyUtilBase.getAccessors(psiClass, propertyName, false, ONLY_PUBLIC);
    }

    @NotNull
    public static List<PsiMethod> getAccessors(@NotNull PsiClass psiClass, String propertyName, boolean acceptStatic, @NonNls @PsiModifier.ModifierConstant String @NotNull [] visibilityLevels) {
        if (psiClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(19);
        }
        if (visibilityLevels == null) {
            PropertyUtilBase.$$$reportNull$$$0(20);
        }
        List<PsiMethod> list = ContainerUtil.concat(PropertyUtilBase.getGetters(psiClass, propertyName, acceptStatic, visibilityLevels), PropertyUtilBase.getSetters(psiClass, propertyName, acceptStatic, visibilityLevels));
        if (list == null) {
            PropertyUtilBase.$$$reportNull$$$0(21);
        }
        return list;
    }

    public static String @NotNull [] getReadableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(22);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiMethod method : methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtilBase.isSimplePropertyGetter(method)) continue;
            result2.add(PropertyUtilBase.getPropertyName(method));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            PropertyUtilBase.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    public static String @NotNull [] getWritableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(24);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (PsiMethod method : methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            result2.add(PropertyUtilBase.getPropertyName(method));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            PropertyUtilBase.$$$reportNull$$$0(25);
        }
        return stringArray;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtilBase.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtilBase.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        PsiMethod[] methods;
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(26);
        }
        if (aClass == null) {
            return null;
        }
        String setterName = PropertyUtilBase.suggestSetterName(propertyName);
        for (PsiMethod method : methods = aClass.findMethodsByName(setterName, checkSuperClasses)) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertySetter(method) || !PropertyUtilBase.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtilBase.suggestPropertyName(field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(27);
        }
        return PropertyUtilBase.findPropertyGetter(aClass, propertyName, isStatic, checkSuperClasses, false);
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses, boolean acceptBoxedBooleanIsPrefix) {
        String[] getterCandidateNames;
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(28);
        }
        if (aClass == null) {
            return null;
        }
        for (String getterCandidateName : getterCandidateNames = PropertyUtilBase.suggestGetterNames(propertyName)) {
            PsiMethod[] getterCandidates;
            for (PsiMethod method : getterCandidates = aClass.findMethodsByName(getterCandidateName, checkSuperClasses)) {
                if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertyGetter(method, acceptBoxedBooleanIsPrefix) || !PropertyUtilBase.getPropertyNameByGetter(method).equals(propertyName)) continue;
                return method;
            }
        }
        return null;
    }

    public static PsiMethod findPropertyGetterWithType(@NotNull String propertyName, boolean isStatic, PsiType type, @NotNull Collection<? extends PsiMethod> methods) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(29);
        }
        if (methods == null) {
            PropertyUtilBase.$$$reportNull$$$0(30);
        }
        return (PsiMethod)((Object)ContainerUtil.find(methods, method -> method.hasModifierProperty("static") == isStatic && PropertyUtilBase.isSimplePropertyGetter(method) && PropertyUtilBase.getPropertyNameByGetter(method).equals(propertyName) && type.equals(method.getReturnType())));
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtilBase.isSimplePropertyAccessor(method, false);
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method, boolean acceptBoxedBooleanIsPrefix) {
        return PropertyUtilBase.isSimplePropertyGetter(method, acceptBoxedBooleanIsPrefix) || PropertyUtilBase.isSimplePropertySetter(method);
    }

    public static PsiMethod findPropertySetterWithType(@NotNull String propertyName, boolean isStatic, PsiType type, @NotNull Collection<? extends PsiMethod> methods) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(31);
        }
        if (methods == null) {
            PropertyUtilBase.$$$reportNull$$$0(32);
        }
        return (PsiMethod)((Object)ContainerUtil.find(methods, method -> method.hasModifierProperty("static") == isStatic && PropertyUtilBase.isSimplePropertySetter(method) && PropertyUtilBase.getPropertyNameBySetter(method).equals(propertyName) && type.equals(method.getParameterList().getParameters()[0].getType())));
    }

    @NotNull
    public static GetterFlavour getMethodNameGetterFlavour(@NotNull String methodName) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(33);
        }
        if (PropertyUtilBase.checkPrefix(methodName, GET_PREFIX)) {
            GetterFlavour getterFlavour = GetterFlavour.GENERIC;
            if (getterFlavour == null) {
                PropertyUtilBase.$$$reportNull$$$0(34);
            }
            return getterFlavour;
        }
        if (PropertyUtilBase.checkPrefix(methodName, IS_PREFIX)) {
            GetterFlavour getterFlavour = GetterFlavour.BOOLEAN;
            if (getterFlavour == null) {
                PropertyUtilBase.$$$reportNull$$$0(35);
            }
            return getterFlavour;
        }
        GetterFlavour getterFlavour = GetterFlavour.NOT_A_GETTER;
        if (getterFlavour == null) {
            PropertyUtilBase.$$$reportNull$$$0(36);
        }
        return getterFlavour;
    }

    public static boolean hasAccessorName(PsiMethod method) {
        String methodName = method.getName();
        return PropertyUtilBase.isSetterName(methodName) || PropertyUtilBase.getMethodNameGetterFlavour(methodName) != GetterFlavour.NOT_A_GETTER;
    }

    @Contract(value="null -> false")
    public static boolean isSimplePropertyGetter(@Nullable PsiMethod method) {
        return PropertyUtilBase.isSimplePropertyGetter(method, false);
    }

    @Contract(value="null, _ -> false")
    public static boolean isSimplePropertyGetter(@Nullable PsiMethod method, boolean acceptBoxedBooleanIsPrefix) {
        return PropertyUtilBase.hasGetterName(method, acceptBoxedBooleanIsPrefix) && method.getParameterList().isEmpty();
    }

    public static boolean hasGetterName(PsiMethod method) {
        return PropertyUtilBase.hasGetterName(method, false);
    }

    private static boolean hasGetterName(PsiMethod method, boolean acceptBoxedBooleanIsPrefix) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        GetterFlavour flavour = PropertyUtilBase.getMethodNameGetterFlavour(methodName);
        switch (flavour) {
            case GENERIC: {
                PsiType returnType = method.getReturnType();
                return !PsiTypes.voidType().equals(returnType);
            }
            case BOOLEAN: {
                PsiType propertyType = method.getReturnType();
                return PropertyUtilBase.isBoolean(propertyType) || acceptBoxedBooleanIsPrefix && propertyType != null && "java.lang.Boolean".equals(propertyType.getCanonicalText());
            }
        }
        return false;
    }

    private static boolean isBoolean(@Nullable PsiType propertyType) {
        return PsiTypes.booleanType().equals(propertyType);
    }

    public static String suggestPropertyName(@NotNull PsiField field) {
        if (field == null) {
            PropertyUtilBase.$$$reportNull$$$0(37);
        }
        return PropertyUtilBase.suggestPropertyName(field, field.getName());
    }

    @NotNull
    public static String suggestPropertyName(@NotNull PsiField field, @NotNull String fieldName) {
        if (field == null) {
            PropertyUtilBase.$$$reportNull$$$0(38);
        }
        if (fieldName == null) {
            PropertyUtilBase.$$$reportNull$$$0(39);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(field.getProject());
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String name = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (!field.hasModifierProperty("static") && PropertyUtilBase.isBoolean(field.getType()) && name.startsWith(IS_PREFIX) && name.length() > IS_PREFIX.length() && Character.isUpperCase(name.charAt(IS_PREFIX.length()))) {
            name = Introspector.decapitalize(name.substring(IS_PREFIX.length()));
        }
        String string2 = name;
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(40);
        }
        return string2;
    }

    public static String suggestGetterName(PsiField field) {
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        return PropertyUtilBase.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(PsiField field) {
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        return PropertyUtilBase.suggestSetterName(propertyName);
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtilBase.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    public static boolean isSimplePropertySetter(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!PropertyUtilBase.isSetterName(methodName)) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null || PsiTypes.voidType().equals(returnType)) {
            return true;
        }
        return Comparing.equal(PsiUtil.resolveClassInType(TypeConversionUtil.erasure(returnType)), method.getContainingClass());
    }

    public static boolean isSetterName(@NotNull String methodName) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(41);
        }
        return PropertyUtilBase.checkPrefix(methodName, SET_PREFIX);
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(42);
        }
        return PropertyUtilBase.getPropertyName(method, false);
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method, boolean acceptBoxedBooleanIsPrefix) {
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(43);
        }
        if (PropertyUtilBase.isSimplePropertyGetter(method, acceptBoxedBooleanIsPrefix)) {
            return PropertyUtilBase.getPropertyNameByGetter(method);
        }
        if (PropertyUtilBase.isSimplePropertySetter(method)) {
            return PropertyUtilBase.getPropertyNameBySetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        @NonNls String methodName = getterMethod.getName();
        if (methodName.startsWith(GET_PREFIX)) {
            String string2 = StringUtil.decapitalize(methodName.substring(3));
            if (string2 == null) {
                PropertyUtilBase.$$$reportNull$$$0(44);
            }
            return string2;
        }
        if (methodName.startsWith(IS_PREFIX)) {
            String string3 = StringUtil.decapitalize(methodName.substring(2));
            if (string3 == null) {
                PropertyUtilBase.$$$reportNull$$$0(45);
            }
            return string3;
        }
        String string4 = methodName;
        if (string4 == null) {
            PropertyUtilBase.$$$reportNull$$$0(46);
        }
        return string4;
    }

    @NotNull
    public static String getPropertyNameBySetter(@NotNull PsiMethod setterMethod) {
        if (setterMethod == null) {
            PropertyUtilBase.$$$reportNull$$$0(47);
        }
        String methodName = setterMethod.getName();
        String string2 = Introspector.decapitalize(methodName.substring(3));
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(48);
        }
        return string2;
    }

    private static boolean checkPrefix(@NotNull String methodName, @NotNull String prefix) {
        if (methodName == null) {
            PropertyUtilBase.$$$reportNull$$$0(49);
        }
        if (prefix == null) {
            PropertyUtilBase.$$$reportNull$$$0(50);
        }
        boolean hasPrefix = methodName.startsWith(prefix) && methodName.length() > prefix.length();
        return hasPrefix && (!Character.isLowerCase(methodName.charAt(prefix.length())) || methodName.length() != prefix.length() + 1 && !Character.isLowerCase(methodName.charAt(prefix.length() + 1)));
    }

    public static @NonNls String @NotNull [] suggestGetterNames(@NotNull String propertyName) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(51);
        }
        String str = StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName));
        String[] stringArray = new String[]{IS_PREFIX + str, GET_PREFIX + str};
        if (stringArray == null) {
            PropertyUtilBase.$$$reportNull$$$0(52);
        }
        return stringArray;
    }

    @NotNull
    public static String suggestGetterName(@NonNls @NotNull String propertyName, @Nullable PsiType propertyType) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(53);
        }
        return PropertyUtilBase.suggestGetterName(propertyName, propertyType, null);
    }

    @NotNull
    public static String suggestGetterName(@NotNull String propertyName, @Nullable PsiType propertyType, @NonNls String existingGetterName) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(54);
        }
        @NonNls StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName)));
        if (PropertyUtilBase.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith(GET_PREFIX)) {
                name.insert(0, IS_PREFIX);
            } else {
                name.insert(0, GET_PREFIX);
            }
        } else {
            name.insert(0, GET_PREFIX);
        }
        String string2 = name.toString();
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(55);
        }
        return string2;
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(56);
        }
        return PropertyUtilBase.suggestSetterName(propertyName, SET_PREFIX);
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName, String setterPrefix) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(57);
        }
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier(propertyName);
        if (StringUtil.isEmpty(setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        @NonNls StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    @NotNull
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            PropertyUtilBase.$$$reportNull$$$0(58);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(field.getProject());
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtilBase.suggestGetterName(field);
        PsiMethod getMethod = factory.createMethod(getName, AnnotationTargetUtil.keepStrictlyTypeUseAnnotations(field.getModifierList(), field.getType()));
        PsiUtil.setModifierProperty(getMethod, "public", true);
        if (field.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty(getMethod, "static", true);
        }
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, getMethod);
        PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
        Objects.requireNonNull(getMethod.getBody()).replace(body);
        PsiMethod psiMethod = getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
        if (psiMethod == null) {
            PropertyUtilBase.$$$reportNull$$$0(59);
        }
        return psiMethod;
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            PropertyUtilBase.$$$reportNull$$$0(60);
        }
        return PropertyUtilBase.generateSetterPrototype(field, field.getContainingClass());
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass) {
        if (field == null) {
            PropertyUtilBase.$$$reportNull$$$0(61);
        }
        if (containingClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(62);
        }
        return PropertyUtilBase.generateSetterPrototype(field, containingClass, false);
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass, boolean returnSelf) {
        if (field == null) {
            PropertyUtilBase.$$$reportNull$$$0(63);
        }
        if (containingClass == null) {
            PropertyUtilBase.$$$reportNull$$$0(64);
        }
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(field.getProject());
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtilBase.suggestSetterName(field);
        PsiMethod setMethod = factory.createMethodFromText(factory.createMethod(setName, returnSelf ? factory.createType(containingClass) : PsiTypes.voidType()).getText(), field);
        String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
        PsiParameter param = factory.createParameter(parameterName, AnnotationTargetUtil.keepStrictlyTypeUseAnnotations(field.getModifierList(), field.getType()));
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, param);
        setMethod.getParameterList().add(param);
        PsiUtil.setModifierProperty(setMethod, "public", true);
        PsiUtil.setModifierProperty(setMethod, "static", isStatic);
        @NonNls StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (name.equals(parameterName)) {
            if (!isStatic) {
                buffer.append("this.");
            } else {
                String className = containingClass.getName();
                if (className != null) {
                    buffer.append(className);
                    buffer.append(".");
                }
            }
        }
        buffer.append(name);
        buffer.append("=");
        buffer.append(parameterName);
        buffer.append(";\n");
        if (returnSelf) {
            buffer.append("return this;\n");
        }
        buffer.append("}");
        PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
        Objects.requireNonNull(setMethod.getBody()).replace(body);
        PsiMethod psiMethod = setMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(setMethod);
        if (psiMethod == null) {
            PropertyUtilBase.$$$reportNull$$$0(65);
        }
        return psiMethod;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtilBase.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtilBase.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null) {
                return null;
            }
            PsiCodeBlock body = psiMethod.getBody();
            PsiStatement[] statements = body == null ? null : body.getStatements();
            PsiStatement psiStatement = statement = statements == null || statements.length != 1 ? null : statements[0];
            if (PsiTypes.voidType().equals(returnType)) {
                PsiExpression expression = statement instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : null;
                target = expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : null;
            } else {
                target = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiClass memberClass = psiMember.getContainingClass();
                PsiClass fieldClass = field.getContainingClass();
                if (memberClass != null && fieldClass != null && (memberClass == fieldClass || memberClass.isInheritor(fieldClass, true))) {
                    return field;
                }
            }
        }
        return null;
    }

    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtilBase.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtilBase.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiExpression getGetterReturnExpression(@Nullable PsiMethod method) {
        return method != null && PropertyUtilBase.hasGetterSignature(method) ? PropertyUtilBase.getSingleReturnValue(method) : null;
    }

    private static boolean hasGetterSignature(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(66);
        }
        return PropertyUtilBase.isSimplePropertyGetter(method);
    }

    @Nullable
    public static PsiExpression getSingleReturnValue(@NotNull PsiMethod method) {
        PsiCodeBlock body;
        if (method == null) {
            PropertyUtilBase.$$$reportNull$$$0(67);
        }
        if ((body = method.getBody()) == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements.length != 1 ? null : statements[0];
        return statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
    }

    @Contract(pure=true)
    @Nullable
    public static PropertyKind getPropertyKind(@NotNull String accessorName) {
        if (accessorName == null) {
            PropertyUtilBase.$$$reportNull$$$0(68);
        }
        for (PropertyKind kind : PropertyKind.values()) {
            String prefix = kind.prefix;
            int prefixLength = prefix.length();
            if (!accessorName.startsWith(prefix) || accessorName.length() <= prefixLength) continue;
            return kind;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static Pair<String, PropertyKind> getPropertyNameAndKind(@NotNull String accessorName) {
        PropertyKind kind;
        if (accessorName == null) {
            PropertyUtilBase.$$$reportNull$$$0(69);
        }
        if ((kind = PropertyUtilBase.getPropertyKind(accessorName)) == null) {
            return null;
        }
        String baseName = accessorName.substring(kind.prefix.length());
        String propertyName = Introspector.decapitalize(baseName);
        return Pair.create(propertyName, kind);
    }

    @Contract(pure=true)
    @NotNull
    public static String getAccessorName(@NotNull String propertyName, @NotNull PropertyKind kind) {
        if (propertyName == null) {
            PropertyUtilBase.$$$reportNull$$$0(70);
        }
        if (kind == null) {
            PropertyUtilBase.$$$reportNull$$$0(71);
        }
        String string2 = kind.prefix + StringUtil.capitalizeWithJavaBeanConvention(propertyName);
        if (string2 == null) {
            PropertyUtilBase.$$$reportNull$$$0(72);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 65: 
            case 72: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 65: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityLevels";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 65: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PropertyUtilBase";
                break;
            }
            case 7: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 37: 
            case 38: 
            case 58: 
            case 60: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 42: 
            case 43: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setterMethod";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorName";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PropertyUtilBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAccessors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetters";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableProperties";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableProperties";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNameGetterFlavour";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPropertyName";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameByGetter";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameBySetter";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestGetterNames";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestGetterName";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "generateGetterPrototype";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSetterPrototype";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllProperties";
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 65: 
            case 72: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllAccessors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterMethods";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSetters";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGetters";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReadableProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getWritableProperties";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySetter";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGetter";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGetterWithType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySetterWithType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameGetterFlavour";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "suggestPropertyName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isSetterName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameBySetter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterNames";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterName";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "suggestSetterName";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "generateGetterPrototype";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "generateSetterPrototype";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "hasGetterSignature";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getSingleReturnValue";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyKind";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameAndKind";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 65: 
            case 72: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum GetterFlavour {
        BOOLEAN,
        GENERIC,
        NOT_A_GETTER;

    }
}

