/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContentImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StubTextInconsistencyException
extends RuntimeException
implements ExceptionWithAttachments {
    private final String myStubsFromText;
    private final String myStubsFromPsi;
    private final String myFileName;
    private final String myFileText;

    private StubTextInconsistencyException(String message, PsiFile file2, List<PsiFileStub> fromText, List<PsiFileStub> fromPsi) {
        super(message);
        this.myStubsFromText = StringUtil.join(fromText, DebugUtil::stubTreeToString, "\n");
        this.myStubsFromPsi = StringUtil.join(fromPsi, DebugUtil::stubTreeToString, "\n");
        this.myFileName = file2.getName();
        this.myFileText = file2.getText();
    }

    @NotNull
    public String getStubsFromText() {
        String string2 = this.myStubsFromText;
        if (string2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    public String getStubsFromPsi() {
        String string2 = this.myStubsFromPsi;
        if (string2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public Attachment @NotNull [] getAttachments() {
        Attachment[] attachmentArray = new Attachment[]{new Attachment(this.myFileName, this.myFileText), new Attachment("stubsRestoredFromText.txt", this.myStubsFromText), new Attachment("stubsFromExistingPsi.txt", this.myStubsFromPsi)};
        if (attachmentArray == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(2);
        }
        return attachmentArray;
    }

    public static void checkStubTextConsistency(@NotNull PsiFile file2) throws StubTextInconsistencyException {
        if (file2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid(file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider || viewProvider.getVirtualFile() instanceof LightVirtualFile) {
            return;
        }
        PsiFile bindingRoot = viewProvider.getStubBindingRoot();
        if (!(bindingRoot instanceof PsiFileImpl)) {
            return;
        }
        IStubFileElementType<?> fileElementType = ((PsiFileImpl)bindingRoot).getElementTypeForStubBuilder();
        if (fileElementType == null || !fileElementType.shouldBuildStubFor(viewProvider.getVirtualFile())) {
            return;
        }
        List<PsiFileStub> fromText = StubTextInconsistencyException.restoreStubsFromText(viewProvider);
        List<PsiFileStub> fromPsi = ContainerUtil.map(StubTreeBuilder.getStubbedRoots(viewProvider), p -> ((PsiFileImpl)p.getSecond()).calcStubTree().getRoot());
        if (fromPsi.size() != fromText.size()) {
            throw new StubTextInconsistencyException("Inconsistent stub roots: PSI says it's " + ContainerUtil.map(fromPsi, s2 -> s2.getType()) + " but re-parsing the text gives " + ContainerUtil.map(fromText, s2 -> s2.getType()), file2, fromText, fromPsi);
        }
        for (int i = 0; i < fromPsi.size(); ++i) {
            PsiFileStub psiStub = fromPsi.get(i);
            if (DebugUtil.stubTreeToString(psiStub).equals(DebugUtil.stubTreeToString(fromText.get(i)))) continue;
            throw new StubTextInconsistencyException("Stub is inconsistent with text in " + file2.getLanguage(), file2, fromText, fromPsi);
        }
    }

    @NotNull
    private static List<PsiFileStub> restoreStubsFromText(FileViewProvider viewProvider) {
        Project project = viewProvider.getManager().getProject();
        FileContentImpl fc = (FileContentImpl)FileContentImpl.createByText(viewProvider.getVirtualFile(), viewProvider.getContents(), project);
        fc.setProject(project);
        PsiFileStubImpl copyTree = (PsiFileStubImpl)StubTreeBuilder.buildStubTree(fc);
        List<PsiFileStub> list = copyTree == null ? Collections.emptyList() : Arrays.asList(copyTree.getStubRoots());
        if (list == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreStubsFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkStubTextConsistency";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

