/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance(ParameterListElement.class);
    private static final TokenSet PARAMETER_SET = TokenSet.create(JavaElementType.PARAMETER, JavaElementType.RECEIVER_PARAMETER);

    public ParameterListElement() {
        super(PARAMETER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor, Boolean before) {
        this.ensureParenthesisAroundParameterList();
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first2, last2, anchor, before);
        if (first2 == last2 && PARAMETER_SET.contains(first2.getElementType())) {
            JavaSourceUtil.addSeparatingComma(this, first2, PARAMETER_SET);
        }
        return firstAdded;
    }

    private void ensureParenthesisAroundParameterList() {
        if (this.findChildByRole(24) == null) {
            this.addLeaf(JavaTokenType.LPARENTH, "(", this.getFirstChildNode());
            this.addLeaf(JavaTokenType.RPARENTH, ")", null);
        }
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement newFirstNodeInsideParens;
        if (child == null) {
            ParameterListElement.$$$reportNull$$$0(0);
        }
        TreeElement oldLastNodeInsideParens = this.getLastNodeInsideParens();
        TreeElement oldFirstNodeInsideParens = this.getFirstNodeInsideParens();
        if (PARAMETER_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
            this.ensureParenthesisAroundParameterList();
        }
        super.deleteChildInternal(child);
        TreeElement newLastNodeInsideParens = this.getLastNodeInsideParens();
        if (newLastNodeInsideParens != null && oldLastNodeInsideParens != null && newLastNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldLastNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal(newLastNodeInsideParens);
            } else {
                this.replaceChild(newLastNodeInsideParens, (ASTNode)oldLastNodeInsideParens.clone());
            }
        }
        if ((newFirstNodeInsideParens = this.getFirstNodeInsideParens()) != null && newFirstNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldFirstNodeInsideParens == null || oldFirstNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal(newFirstNodeInsideParens);
            } else {
                this.replaceChild(newFirstNodeInsideParens, (ASTNode)oldFirstNodeInsideParens.clone());
            }
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                TreeElement firstNode = this.getFirstChildNode();
                return firstNode.getElementType() == LPARENTH ? firstNode : null;
            }
            case 25: 
        }
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode : null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            ParameterListElement.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (PARAMETER_SET.contains(i)) {
            return 15;
        }
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return this.getChildRole(child, 24);
        }
        if (i == RPARENTH) {
            return this.getChildRole(child, 25);
        }
        return 0;
    }

    @Nullable
    private TreeElement getLastNodeInsideParens() {
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode.getTreePrev() : null;
    }

    @Nullable
    private TreeElement getFirstNodeInsideParens() {
        TreeElement firstNode = this.getFirstChildNode();
        return firstNode.getElementType() == LPARENTH ? firstNode.getTreeNext() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "child";
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/ParameterListElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

