/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiSuperMethodImplUtil {
    private static final Logger LOG = Logger.getInstance(PsiSuperMethodImplUtil.class);
    private static final PsiCacheKey<Map<MethodSignature, HierarchicalMethodSignature>, PsiClass> SIGNATURES_FOR_CLASS_KEY = PsiCacheKey.create("SIGNATURES_FOR_CLASS_KEY", dom -> PsiSuperMethodImplUtil.buildMethodHierarchy(dom, null, PsiSubstitutor.EMPTY, true, new HashSet(), false, dom.getResolveScope()));
    private static final PsiCacheKey<Map<Pair<String, GlobalSearchScope>, Map<MethodSignature, HierarchicalMethodSignature>>, PsiClass> SIGNATURES_BY_NAME_KEY = PsiCacheKey.create("SIGNATURES_BY_NAME_KEY", psiClass -> ConcurrentFactoryMap.createMap(pair -> PsiSuperMethodImplUtil.buildMethodHierarchy(psiClass, (String)pair.first, PsiSubstitutor.EMPTY, true, new HashSet(), false, (GlobalSearchScope)pair.second)));

    private PsiSuperMethodImplUtil() {
    }

    public static PsiMethod @NotNull [] findSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(0);
        }
        return PsiSuperMethodImplUtil.findSuperMethods(method, null);
    }

    public static PsiMethod @NotNull [] findSuperMethods(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(1);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(2);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        return PsiSuperMethodImplUtil.findSuperMethodsInternal(method, null);
    }

    public static PsiMethod @NotNull [] findSuperMethods(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(3);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(4);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        return PsiSuperMethodImplUtil.findSuperMethodsInternal(method, parentClass);
    }

    private static PsiMethod @NotNull [] findSuperMethodsInternal(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(5);
        }
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(6);
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(7);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, true)) {
            List<MethodSignatureBackedByPsiMethod> list = Collections.emptyList();
            if (list == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        return PsiSuperMethodImplUtil.findSuperMethodSignatures(method, null, true);
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(@NotNull PsiMethod method, PsiClass parentClass, boolean allowStaticMethod) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(9);
        }
        return new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search(new SuperMethodsSearch.SearchParameters(method, parentClass, true, allowStaticMethod, true)).findAll());
    }

    private static boolean canHaveSuperMethod(@NotNull PsiMethod method, boolean checkAccess, boolean allowStaticMethod) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(10);
        }
        if (method.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(11);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return null;
        }
        return DeepestSuperMethodsSearch.search(method).findFirst();
    }

    public static PsiMethod @NotNull [] findDeepestSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(12);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(13);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection<PsiMethod> collection = DeepestSuperMethodsSearch.search(method).findAll();
        PsiMethod[] psiMethodArray = collection.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(14);
        }
        return psiMethodArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(@NotNull PsiClass aClass, @Nullable String nameHint, @NotNull PsiSubstitutor substitutor, boolean includePrivates, @NotNull Set<? super PsiClass> visited, boolean isInRawContext, GlobalSearchScope resolveScope) {
        void var13_15;
        PsiMethod[] methods;
        if (aClass == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(15);
        }
        if (substitutor == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(16);
        }
        if (visited == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> result2 = new LinkedHashMap<MethodSignature, HierarchicalMethodSignature>(new EqualityPolicy<MethodSignature>(){

            @Override
            public int getHashCode(MethodSignature object) {
                return object.hashCode();
            }

            @Override
            public boolean isEqual(MethodSignature o1, MethodSignature o2) {
                if (o1.equals(o2)) {
                    PsiMethod method1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                    PsiType returnType1 = method1.getReturnType();
                    PsiMethod method2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                    PsiType returnType2 = method2.getReturnType();
                    if (method1.hasModifierProperty("static") || method2.hasModifierProperty("static")) {
                        return true;
                    }
                    if (MethodSignatureUtil.isReturnTypeSubstitutable(o1, o2, returnType1, returnType2)) {
                        return true;
                    }
                    PsiClass containingClass1 = method1.getContainingClass();
                    PsiClass containingClass2 = method2.getContainingClass();
                    if (containingClass1 != null && containingClass2 != null) {
                        return containingClass1.isAnnotationType() || containingClass2.isAnnotationType();
                    }
                }
                return false;
            }
        });
        final Map sameParameterErasureMethods = MethodSignatureUtil.createErasedMethodSignatureMap();
        LinkedHashMap<MethodSignature, HierarchicalMethodSignatureImpl> map2 = new LinkedHashMap<MethodSignature, HierarchicalMethodSignatureImpl>(new EqualityPolicy<MethodSignature>(){

            @Override
            public int getHashCode(MethodSignature signature) {
                return signature.hashCode();
            }

            @Override
            public boolean isEqual(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.areSignaturesErasureEqual(o1, o2)) {
                    return false;
                }
                List list = (List)sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list != null && list.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure(o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure(o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        PsiMethod[] psiMethodArray = methods = nameHint == null ? aClass.getMethods() : aClass.findMethodsByName(nameHint, false);
        int n = psiMethodArray.length;
        boolean bl = false;
        while (var13_15 < n) {
            PsiMethod method = psiMethodArray[var13_15];
            PsiUtilCore.ensureValid(method);
            if (includePrivates || !method.hasModifierProperty("private")) {
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY, isInRawContext);
                HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(MethodSignatureBackedByPsiMethod.create(method, substitutor, isInRawContext));
                SmartList<PsiMethod> list = (SmartList<PsiMethod>)sameParameterErasureMethods.get(signature);
                if (list == null) {
                    list = new SmartList<PsiMethod>();
                    sameParameterErasureMethods.put(signature, list);
                }
                list.add(method);
                LOG.assertTrue(newH.getMethod().isValid(), newH.getMethod().getClass());
                result2.put(signature, newH);
                map2.put(signature, newH);
            }
            ++var13_15;
        }
        List<PsiClassType.ClassResolveResult> superTypes = PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass, resolveScope);
        for (PsiClassType.ClassResolveResult classResolveResult : superTypes) {
            PsiClass superClass = classResolveResult.getElement();
            if (superClass == null || !visited.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = classResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor(superClass, superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, nameHint, finalSubstitutor, false, visited, isInRawContextSuper, resolveScope);
            visited.remove(superClass);
            ArrayList<Pair<MethodSignatureBackedByPsiMethod, HierarchicalMethodSignature>> flattened = new ArrayList<Pair<MethodSignatureBackedByPsiMethod, HierarchicalMethodSignature>>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(hms.getMethod(), hms.getSubstitutor(), hms.isRaw());
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList<HierarchicalMethodSignature> supers = new ArrayList<HierarchicalMethodSignature>(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(Pair.create(signature, aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass, result2, map2, hms, signature);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass, result2, map2, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map2.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)entry.getValue();
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result2.get(methodSignature) != null) continue;
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(methodSignature, hierarchicalMethodSignature);
        }
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> linkedHashMap = result2;
        if (linkedHashMap == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(18);
        }
        return linkedHashMap;
    }

    private static void putInMap(@NotNull PsiClass aClass, @NotNull Map<MethodSignature, HierarchicalMethodSignature> result2, @NotNull Map<MethodSignature, HierarchicalMethodSignatureImpl> map2, @NotNull HierarchicalMethodSignature hierarchicalMethodSignature, @NotNull MethodSignature signature) {
        if (aClass == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(20);
        }
        if (map2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(21);
        }
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(22);
        }
        if (signature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(23);
        }
        if (PsiSuperMethodImplUtil.isInheritedInterfaceStaticMethod(hierarchicalMethodSignature, aClass)) {
            return;
        }
        HierarchicalMethodSignatureImpl existing = map2.get(signature);
        if (existing == null) {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            LOG.assertTrue(copy.getMethod().isValid());
            map2.put(signature, copy);
            return;
        }
        MergeSuperType mergeSuperType = PsiSuperMethodImplUtil.solveMergeSuperType(aClass, hierarchicalMethodSignature, existing);
        if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && mergeSuperType == MergeSuperType.MERGE_SUPER || mergeSuperType == MergeSuperType.FORCE_MERGE) {
            HierarchicalMethodSignatureImpl newCurrent = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newCurrent, existing);
            LOG.assertTrue(newCurrent.getMethod().isValid());
            map2.put(signature, newCurrent);
            return;
        }
        mergeSuperType = PsiSuperMethodImplUtil.solveMergeSuperType(aClass, existing, hierarchicalMethodSignature);
        if (mergeSuperType == MergeSuperType.MERGE_SUPER || mergeSuperType == MergeSuperType.FORCE_MERGE) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
            return;
        }
        if (!result2.containsKey(signature)) {
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(signature, hierarchicalMethodSignature);
        }
    }

    private static boolean isInheritedInterfaceStaticMethod(@NotNull HierarchicalMethodSignature signature, @NotNull PsiClass aClass) {
        PsiMethod method;
        PsiClass containingClass;
        if (signature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(24);
        }
        if (aClass == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(25);
        }
        return (containingClass = (method = signature.getMethod()).getContainingClass()) != null && !aClass.getManager().areElementsEquivalent(aClass, containingClass) && containingClass.isInterface() && method.hasModifierProperty("static");
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        PsiSubstitutor unifyingSubstitutor;
        if (thisSig == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(26);
        }
        if (thatSig == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(27);
        }
        PsiType thisRet = thisSig.getSubstitutor().substitute(thisSig.getMethod().getReturnType());
        PsiType thatRet = thatSig.getSubstitutor().substitute(thatSig.getMethod().getReturnType());
        PsiSubstitutor psiSubstitutor = unifyingSubstitutor = MethodSignatureUtil.isSubsignature(thatSig, thisSig) ? MethodSignatureUtil.getSuperMethodSignatureSubstitutor(thisSig, thatSig) : null;
        if (unifyingSubstitutor != null) {
            thisRet = unifyingSubstitutor.substitute(thisRet);
            thatRet = unifyingSubstitutor.substitute(thatRet);
        }
        if (thatRet == null || thisRet == null) {
            return false;
        }
        if (!thatRet.isValid()) {
            PsiUtilCore.ensureValid(thatSig.getMethod());
            PsiUtil.ensureValidType(thatRet);
        }
        if (!thisRet.isValid()) {
            PsiUtilCore.ensureValid(thisSig.getMethod());
            PsiUtil.ensureValidType(thisRet);
        }
        return !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable(thatRet, thisRet, false);
    }

    private static void mergeSupers(@NotNull HierarchicalMethodSignatureImpl existing, @NotNull HierarchicalMethodSignature superSignature) {
        if (existing == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(28);
        }
        if (superSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(29);
        }
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy);
        }
    }

    @NotNull
    private static MergeSuperType solveMergeSuperType(@NotNull PsiClass aClass, @NotNull MethodSignatureBackedByPsiMethod hierarchicalMethodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignatureHierarchical) {
        if (aClass == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(30);
        }
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(31);
        }
        if (superSignatureHierarchical == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(32);
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiMethod method = hierarchicalMethodSignature.getMethod();
        PsiClass containingClass = method.getContainingClass();
        if (!superMethod.isConstructor() && !aClass.equals(superClass) && MethodSignatureUtil.isSubsignature(superSignatureHierarchical, hierarchicalMethodSignature) && superClass != null) {
            if (superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName())) {
                if (superMethod.hasModifierProperty("default") && method.hasModifierProperty("static") && !InheritanceUtil.isInheritorOrSelf(containingClass, superClass, true)) {
                    MergeSuperType mergeSuperType = MergeSuperType.FORCE_MERGE;
                    if (mergeSuperType == null) {
                        PsiSuperMethodImplUtil.$$$reportNull$$$0(33);
                    }
                    return mergeSuperType;
                }
                if (superMethod.hasModifierProperty("default") || method.hasModifierProperty("default")) {
                    boolean isSuper = superMethod.equals(method) || !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true);
                    MergeSuperType mergeSuperType = isSuper ? MergeSuperType.MERGE_SUPER : MergeSuperType.NOT_MERGE_SUPER;
                    if (mergeSuperType == null) {
                        PsiSuperMethodImplUtil.$$$reportNull$$$0(34);
                    }
                    return mergeSuperType;
                }
                MergeSuperType mergeSuperType = MergeSuperType.MERGE_SUPER;
                if (mergeSuperType == null) {
                    PsiSuperMethodImplUtil.$$$reportNull$$$0(35);
                }
                return mergeSuperType;
            }
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    MergeSuperType mergeSuperType = MergeSuperType.NOT_MERGE_SUPER;
                    if (mergeSuperType == null) {
                        PsiSuperMethodImplUtil.$$$reportNull$$$0(36);
                    }
                    return mergeSuperType;
                }
                if (!aClass.isInterface() && !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true)) {
                    MergeSuperType mergeSuperType = MergeSuperType.MERGE_SUPER;
                    if (mergeSuperType == null) {
                        PsiSuperMethodImplUtil.$$$reportNull$$$0(37);
                    }
                    return mergeSuperType;
                }
            }
        }
        MergeSuperType mergeSuperType = MergeSuperType.NOT_MERGE_SUPER;
        if (mergeSuperType == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(38);
        }
        return mergeSuperType;
    }

    @NotNull
    private static HierarchicalMethodSignatureImpl copy(@NotNull HierarchicalMethodSignature hi) {
        if (hi == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(39);
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl(hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignatureImpl = hierarchicalMethodSignature;
        if (hierarchicalMethodSignatureImpl == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(40);
        }
        return hierarchicalMethodSignatureImpl;
    }

    @NotNull
    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(41);
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = PsiSuperMethodImplUtil.getSignaturesMap(aClass);
        Collection<HierarchicalMethodSignature> collection = map2.values();
        if (collection == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(42);
        }
        return collection;
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(43);
        }
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method, method.getResolveScope());
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method, @NotNull GlobalSearchScope resolveScope) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(44);
        }
        if (resolveScope == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(45);
        }
        Map signatures = (Map)CachedValuesManager.getCachedValue(method, () -> {
            ConcurrentMap<GlobalSearchScope, HierarchicalMethodSignature> map2 = ConcurrentFactoryMap.createMap(scope -> {
                PsiClass aClass = method.getContainingClass();
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                HierarchicalMethodSignature result2 = null;
                if (aClass != null) {
                    result2 = SIGNATURES_BY_NAME_KEY.getValue(aClass).get(Pair.create(method.getName(), scope)).get(signature);
                }
                if (result2 == null) {
                    result2 = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)signature);
                }
                return result2;
            });
            return CachedValueProvider.Result.create(map2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        HierarchicalMethodSignature hierarchicalMethodSignature = (HierarchicalMethodSignature)signatures.get(resolveScope);
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(46);
        }
        return hierarchicalMethodSignature;
    }

    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(47);
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = SIGNATURES_FOR_CLASS_KEY.getValue(aClass);
        if (map2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(48);
        }
        return map2;
    }

    public static boolean processDirectSuperMethodsSmart(@NotNull PsiMethod method, @NotNull Processor<? super PsiMethod> superMethodProcessor) {
        PsiClass aClass;
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(49);
        }
        if (superMethodProcessor == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(50);
        }
        if ((aClass = method.getContainingClass()) == null) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_BY_NAME_KEY.getValue(aClass).get(Pair.create(method.getName(), method.getResolveScope()));
        HierarchicalMethodSignature signature = cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        if (signature != null) {
            List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                if (superMethodProcessor.process(superSignature.getMethod())) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiSuperMethodImplUtil";
                break;
            }
            case 15: 
            case 19: 
            case 25: 
            case 30: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalMethodSignature";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisSig";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thatSig";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignatureHierarchical";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hi";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiSuperMethodImplUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodsInternal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuperMethods";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMethodHierarchy";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "solveMergeSuperType";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalMethodSignature";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethods";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodsInternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodSignatures";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSuperMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethods";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildMethodHierarchy";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "putInMap";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInheritedInterfaceStaticMethod";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeIsMoreSpecificThan";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mergeSupers";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "solveMergeSuperType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleSignatures";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchicalMethodSignature";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesMap";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processDirectSuperMethodsSmart";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 18: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MergeSuperType {
        MERGE_SUPER,
        NOT_MERGE_SUPER,
        FORCE_MERGE;

    }
}

