/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.PrivateKeyReader;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SslUtil {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    public static final String SSL_USE_FACTORY = "sslUseFactory";
    private static final String BEGIN_MARK = "-----BEGIN";

    @NotNull
    public static List<X509Certificate> loadCertificates(@NotNull String caCertPath) throws IOException, CertificateException {
        if (caCertPath == null) {
            SslUtil.$$$reportNull$$$0(0);
        }
        String string2 = FileUtilRt.loadFile(new File(caCertPath));
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        List<String> tokens = SslUtil.splitBundle(string2);
        for (String token2 : tokens) {
            if (token2 == null || token2.trim().isEmpty()) continue;
            certs.add(SslUtil.readCertificate(SslUtil.stringStream(token2)));
        }
        ArrayList<X509Certificate> arrayList = certs;
        if (arrayList == null) {
            SslUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static List<String> splitBundle(@NotNull String string2) {
        int idx;
        if (string2 == null) {
            SslUtil.$$$reportNull$$$0(2);
        }
        if ((idx = string2.indexOf(BEGIN_MARK)) == -1) {
            return Collections.singletonList(string2);
        }
        ArrayList<String> res = new ArrayList<String>();
        while (idx != -1) {
            int endIdx = string2.indexOf(BEGIN_MARK, idx + BEGIN_MARK.length());
            res.add(string2.substring(idx, endIdx == -1 ? string2.length() : endIdx));
            idx = endIdx;
        }
        return res;
    }

    @NotNull
    public static InputStream stringStream(@NotNull String str) {
        if (str == null) {
            SslUtil.$$$reportNull$$$0(3);
        }
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(4);
        }
        return SslUtil.readCertificate(new FileInputStream(filePath));
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull InputStream stream) throws CertificateException, IOException {
        if (stream == null) {
            SslUtil.$$$reportNull$$$0(5);
        }
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
        stream.close();
        X509Certificate x509Certificate = certificate;
        if (x509Certificate == null) {
            SslUtil.$$$reportNull$$$0(6);
        }
        return x509Certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(7);
        }
        return SslUtil.readPrivateKey(filePath, null);
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath, @Nullable char[] password) throws IOException {
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(8);
        }
        PrivateKey privateKey = new PrivateKeyReader(filePath, password).getPrivateKey();
        if (privateKey == null) {
            SslUtil.$$$reportNull$$$0(9);
        }
        return privateKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caCertPath";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/ssl/SslUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/ssl/SslUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCertificates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readCertificate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readPrivateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCertificates";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitBundle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringStream";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readCertificate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readPrivateKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class TrustEverybodyManager
    implements X509TrustManager {
        TrustEverybodyManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) {
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

