/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.unpick;

import com.intellij.psi.PsiFile;
import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Reader;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import net.neoforged.jst.unpick.UnpickCollection;
import net.neoforged.jst.unpick.UnpickVisitor;
import picocli.CommandLine;

public class UnpickTransformer
implements SourceTransformer {
    @CommandLine.Option(names={"--unpick-data"}, description={"The paths to read unpick definition files from"})
    public List<Path> paths = new ArrayList<Path>();
    private UnpickCollection collection;

    @Override
    public void beforeRun(TransformContext context2) {
        final HashMap<UnpickCollection.TypedKey, List<GroupDefinition>> groups2 = new HashMap<UnpickCollection.TypedKey, List<GroupDefinition>>();
        final ArrayList<TargetField> fields = new ArrayList<TargetField>();
        final ArrayList<TargetMethod> methods = new ArrayList<TargetMethod>();
        for (Path path : this.paths) {
            try {
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    new UnpickV3Reader(reader).accept(new UnpickV3Visitor(this){

                        @Override
                        public void visitGroupDefinition(GroupDefinition groupDefinition) {
                            groups2.computeIfAbsent(new UnpickCollection.TypedKey(groupDefinition.dataType(), groupDefinition.scopes(), groupDefinition.name()), k -> new ArrayList()).add(groupDefinition);
                        }

                        @Override
                        public void visitTargetField(TargetField targetField) {
                            fields.add(targetField);
                        }

                        @Override
                        public void visitTargetMethod(TargetMethod targetMethod) {
                            methods.add(targetMethod);
                        }
                    });
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException exception) {
                context2.logger().error("Failed to read unpick definition file: %s", exception.getMessage());
                throw new UncheckedIOException(exception);
            }
        }
        this.collection = new UnpickCollection(context2, groups2, fields, methods);
    }

    @Override
    public void visitFile(PsiFile psiFile, Replacements replacements) {
        new UnpickVisitor(psiFile, this.collection, replacements).visitFile(psiFile);
    }
}

