/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.unpick;

import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum NumberType {
    BYTE(DataType.BYTE, (Class)Byte.class, false, new NumberType[0]){

        @Override
        public Number cast(Number in) {
            return in.byteValue();
        }

        @Override
        public Number divide(Number a, Number b) {
            return a.byteValue() / b.byteValue();
        }

        @Override
        public Number multiply(Number a, Number b) {
            return a.byteValue() * b.byteValue();
        }

        @Override
        public Number add(Number a, Number b) {
            return a.byteValue() + b.byteValue();
        }

        @Override
        public Number subtract(Number a, Number b) {
            return a.byteValue() - b.byteValue();
        }

        @Override
        public Number modulo(Number a, Number b) {
            return a.byteValue() % b.byteValue();
        }

        @Override
        public Number or(Number a, Number b) {
            return a.byteValue() | b.byteValue();
        }

        @Override
        public Number xor(Number a, Number b) {
            return a.byteValue() ^ b.byteValue();
        }

        @Override
        public Number and(Number a, Number b) {
            return a.byteValue() & b.byteValue();
        }

        @Override
        public Number lshift(Number a, Number b) {
            return a.byteValue() << b.byteValue();
        }

        @Override
        public Number rshift(Number a, Number b) {
            return a.byteValue() >> b.byteValue();
        }

        @Override
        public Number rshiftUnsigned(Number a, Number b) {
            return a.byteValue() >>> b.byteValue();
        }
    }
    ,
    SHORT(DataType.SHORT, (Class)Short.class, false, new NumberType[]{BYTE}){

        @Override
        public Number cast(Number in) {
            return in.shortValue();
        }

        @Override
        public Number divide(Number a, Number b) {
            return a.shortValue() / b.shortValue();
        }

        @Override
        public Number multiply(Number a, Number b) {
            return a.shortValue() * b.shortValue();
        }

        @Override
        public Number add(Number a, Number b) {
            return a.shortValue() + b.shortValue();
        }

        @Override
        public Number subtract(Number a, Number b) {
            return a.shortValue() - b.shortValue();
        }

        @Override
        public Number modulo(Number a, Number b) {
            return a.shortValue() % b.shortValue();
        }

        @Override
        public Number or(Number a, Number b) {
            return a.shortValue() | b.shortValue();
        }

        @Override
        public Number xor(Number a, Number b) {
            return a.shortValue() ^ b.shortValue();
        }

        @Override
        public Number and(Number a, Number b) {
            return a.shortValue() & b.shortValue();
        }

        @Override
        public Number lshift(Number a, Number b) {
            return a.shortValue() << b.shortValue();
        }

        @Override
        public Number rshift(Number a, Number b) {
            return a.shortValue() >> b.shortValue();
        }

        @Override
        public Number rshiftUnsigned(Number a, Number b) {
            return a.shortValue() >>> b.shortValue();
        }
    }
    ,
    INT(DataType.INT, (Class)Integer.class, true, new NumberType[]{SHORT}){

        @Override
        public long toUnsignedLong(Number number) {
            return Integer.toUnsignedLong(number.intValue());
        }

        @Override
        public Number cast(Number in) {
            return in.intValue();
        }
    }
    ,
    LONG(DataType.LONG, (Class)Long.class, true, new NumberType[]{INT}){

        @Override
        public Number negate(Number number) {
            return number.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public Number cast(Number in) {
            return in.longValue();
        }

        @Override
        public Number divide(Number a, Number b) {
            return a.longValue() / b.longValue();
        }

        @Override
        public Number multiply(Number a, Number b) {
            return a.longValue() * b.longValue();
        }

        @Override
        public Number add(Number a, Number b) {
            return a.longValue() + b.longValue();
        }

        @Override
        public Number subtract(Number a, Number b) {
            return a.longValue() - b.longValue();
        }

        @Override
        public Number modulo(Number a, Number b) {
            return a.longValue() % b.longValue();
        }

        @Override
        public Number or(Number a, Number b) {
            return a.longValue() | b.longValue();
        }

        @Override
        public Number xor(Number a, Number b) {
            return a.longValue() ^ b.longValue();
        }

        @Override
        public Number and(Number a, Number b) {
            return a.longValue() & b.longValue();
        }

        @Override
        public Number lshift(Number a, Number b) {
            return a.longValue() << (int)b.longValue();
        }

        @Override
        public Number rshift(Number a, Number b) {
            return a.longValue() >> (int)b.longValue();
        }

        @Override
        public Number rshiftUnsigned(Number a, Number b) {
            return a.longValue() >>> (int)b.longValue();
        }
    }
    ,
    FLOAT(DataType.FLOAT, (Class)Float.class, false, new NumberType[]{INT}){

        @Override
        public Number cast(Number in) {
            return Float.valueOf(in.floatValue());
        }

        @Override
        public Number divide(Number a, Number b) {
            return Float.valueOf(a.floatValue() / b.floatValue());
        }

        @Override
        public Number multiply(Number a, Number b) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }

        @Override
        public Number add(Number a, Number b) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }

        @Override
        public Number subtract(Number a, Number b) {
            return Float.valueOf(a.floatValue() - b.floatValue());
        }

        @Override
        public Number modulo(Number a, Number b) {
            return Float.valueOf(a.floatValue() % b.floatValue());
        }
    }
    ,
    DOUBLE(DataType.DOUBLE, (Class)Double.class, false, new NumberType[]{FLOAT}){

        @Override
        public Number cast(Number in) {
            return in.doubleValue();
        }

        @Override
        public Number divide(Number a, Number b) {
            return a.doubleValue() / b.doubleValue();
        }

        @Override
        public Number multiply(Number a, Number b) {
            return a.doubleValue() * b.doubleValue();
        }

        @Override
        public Number add(Number a, Number b) {
            return a.doubleValue() + b.doubleValue();
        }

        @Override
        public Number subtract(Number a, Number b) {
            return a.doubleValue() - b.doubleValue();
        }

        @Override
        public Number modulo(Number a, Number b) {
            return a.doubleValue() % b.doubleValue();
        }
    };

    public static final Map<Class<?>, NumberType> TYPES;
    public final DataType dataType;
    public final Class<?> classType;
    public final boolean supportsFlag;
    public final NumberType[] widenFrom;

    private NumberType(DataType dataType, Class<?> classType, boolean supportsFlag, NumberType ... widenFrom) {
        this.dataType = dataType;
        this.classType = classType;
        this.supportsFlag = supportsFlag;
        this.widenFrom = widenFrom;
    }

    public abstract Number cast(Number var1);

    public long toUnsignedLong(Number number) {
        return number.longValue();
    }

    public Number negate(Number number) {
        return ~number.intValue();
    }

    public Number divide(Number a, Number b) {
        return a.intValue() / b.intValue();
    }

    public Number multiply(Number a, Number b) {
        return a.intValue() * b.intValue();
    }

    public Number add(Number a, Number b) {
        return a.intValue() + b.intValue();
    }

    public Number subtract(Number a, Number b) {
        return a.intValue() - b.intValue();
    }

    public Number modulo(Number a, Number b) {
        return a.intValue() % b.intValue();
    }

    public Number or(Number a, Number b) {
        return a.intValue() | b.intValue();
    }

    public Number xor(Number a, Number b) {
        return a.intValue() ^ b.intValue();
    }

    public Number and(Number a, Number b) {
        return a.intValue() & b.intValue();
    }

    public Number lshift(Number a, Number b) {
        return a.intValue() << b.intValue();
    }

    public Number rshift(Number a, Number b) {
        return a.intValue() >> b.intValue();
    }

    public Number rshiftUnsigned(Number a, Number b) {
        return a.intValue() >>> b.intValue();
    }

    public boolean canWidenFrom(NumberType other) {
        if (other == this) {
            return true;
        }
        for (NumberType from : this.widenFrom) {
            if (other != from && !from.canWidenFrom(other)) continue;
            return true;
        }
        return false;
    }

    public static NumberType widest(NumberType a, NumberType b) {
        return a.canWidenFrom(b) ? a : b;
    }

    static {
        HashMap types = new HashMap();
        for (NumberType value : NumberType.values()) {
            types.put(value.classType, value);
        }
        TYPES = Collections.unmodifiableMap(types);
    }
}

