/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.StringUnionOperations;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class BasicAutomata {
    private BasicAutomata() {
    }

    public static Automaton makeEmpty() {
        Automaton a = new Automaton();
        a.initial = new State();
        a.deterministic = true;
        return a;
    }

    public static Automaton makeEmptyString() {
        Automaton a = new Automaton();
        a.singleton = "";
        a.deterministic = true;
        return a;
    }

    public static Automaton makeAnyString() {
        State s2;
        Automaton a = new Automaton();
        a.initial = s2 = new State();
        s2.accept = true;
        s2.transitions.add(new Transition('\u0000', '\uffff', s2));
        a.deterministic = true;
        return a;
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeCharRange('\u0000', '\uffff');
    }

    public static Automaton makeChar(char c) {
        Automaton a = new Automaton();
        a.singleton = Character.toString(c);
        a.deterministic = true;
        return a;
    }

    public static Automaton makeCharRange(char min2, char max) {
        if (min2 == max) {
            return BasicAutomata.makeChar(min2);
        }
        Automaton a = new Automaton();
        State s1 = new State();
        State s2 = new State();
        a.initial = s1;
        s2.accept = true;
        if (min2 <= max) {
            s1.transitions.add(new Transition(min2, max, s2));
        }
        a.deterministic = true;
        return a;
    }

    public static Automaton makeCharSet(String set) {
        if (set.length() == 1) {
            return BasicAutomata.makeChar(set.charAt(0));
        }
        Automaton a = new Automaton();
        State s1 = new State();
        State s2 = new State();
        a.initial = s1;
        s2.accept = true;
        for (int i = 0; i < set.length(); ++i) {
            s1.transitions.add(new Transition(set.charAt(i), s2));
        }
        a.deterministic = true;
        a.reduce();
        return a;
    }

    private static State anyOfRightLength(String x, int n) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            s2.addTransition(new Transition('0', '9', BasicAutomata.anyOfRightLength(x, n + 1)));
        }
        return s2;
    }

    private static State atLeast(String x, int n, Collection<State> initials, boolean zeros) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            if (zeros) {
                initials.add(s2);
            }
            char c = x.charAt(n);
            s2.addTransition(new Transition(c, BasicAutomata.atLeast(x, n + 1, initials, zeros && c == '0')));
            if (c < '9') {
                s2.addTransition(new Transition((char)(c + '\u0001'), '9', BasicAutomata.anyOfRightLength(x, n + 1)));
            }
        }
        return s2;
    }

    private static State atMost(String x, int n) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            char c = x.charAt(n);
            s2.addTransition(new Transition(c, BasicAutomata.atMost(x, (char)n + '\u0001')));
            if (c > '0') {
                s2.addTransition(new Transition('0', (char)(c - '\u0001'), BasicAutomata.anyOfRightLength(x, n + 1)));
            }
        }
        return s2;
    }

    private static State between(String x, String y, int n, Collection<State> initials, boolean zeros) {
        State s2 = new State();
        if (x.length() == n) {
            s2.setAccept(true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s2);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                s2.addTransition(new Transition(cx, BasicAutomata.between(x, y, n + 1, initials, zeros && cx == '0')));
            } else {
                s2.addTransition(new Transition(cx, BasicAutomata.atLeast(x, n + 1, initials, zeros && cx == '0')));
                s2.addTransition(new Transition(cy, BasicAutomata.atMost(y, n + 1)));
                if (cx + '\u0001' < cy) {
                    s2.addTransition(new Transition((char)(cx + '\u0001'), (char)(cy - '\u0001'), BasicAutomata.anyOfRightLength(x, n + 1)));
                }
            }
        }
        return s2;
    }

    public static Automaton makeInterval(int min2, int max, int digits) throws IllegalArgumentException {
        Automaton a = new Automaton();
        String x = Integer.toString(min2);
        String y = Integer.toString(max);
        if (min2 > max || digits > 0 && y.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        for (int i = x.length(); i < d; ++i) {
            bx.append('0');
        }
        bx.append(x);
        x = bx.toString();
        StringBuilder by = new StringBuilder();
        for (int i = y.length(); i < d; ++i) {
            by.append('0');
        }
        by.append(y);
        y = by.toString();
        ArrayList<State> initials = new ArrayList<State>();
        a.initial = BasicAutomata.between(x, y, 0, initials, digits <= 0);
        if (digits <= 0) {
            ArrayList<StatePair> pairs = new ArrayList<StatePair>();
            for (State p : initials) {
                if (a.initial == p) continue;
                pairs.add(new StatePair(a.initial, p));
            }
            a.addEpsilons(pairs);
            a.initial.addTransition(new Transition('0', a.initial));
            a.deterministic = false;
        } else {
            a.deterministic = true;
        }
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton makeString(String s2) {
        Automaton a = new Automaton();
        a.singleton = s2;
        a.deterministic = true;
        return a;
    }

    public static Automaton makeStringUnion(CharSequence ... strings2) {
        if (strings2.length == 0) {
            return BasicAutomata.makeEmpty();
        }
        Arrays.sort(strings2, StringUnionOperations.LEXICOGRAPHIC_ORDER);
        Automaton a = new Automaton();
        a.setInitialState(StringUnionOperations.build(strings2));
        a.setDeterministic(true);
        a.reduce();
        a.recomputeHashCode();
        return a;
    }

    public static Automaton makeMaxInteger(String n) {
        int i;
        for (i = 0; i < n.length() && n.charAt(i) == '0'; ++i) {
        }
        StringBuilder b = new StringBuilder();
        b.append("0*(0|");
        if (i < n.length()) {
            b.append("[0-9]{1,").append(n.length() - i - 1).append("}|");
        }
        BasicAutomata.maxInteger(n.substring(i), 0, b);
        b.append(")");
        return Automaton.minimize(new RegExp(b.toString()).toAutomaton());
    }

    private static void maxInteger(String n, int i, StringBuilder b) {
        b.append('(');
        if (i < n.length()) {
            char c = n.charAt(i);
            if (c != '0') {
                b.append("[0-").append((char)(c - '\u0001')).append("][0-9]{").append(n.length() - i - 1).append("}|");
            }
            b.append(c);
            BasicAutomata.maxInteger(n, i + 1, b);
        }
        b.append(')');
    }

    public static Automaton makeMinInteger(String n) {
        int i = 0;
        while (i + 1 < n.length() && n.charAt(i) == '0') {
            ++i;
        }
        StringBuilder b = new StringBuilder();
        b.append("0*");
        BasicAutomata.minInteger(n.substring(i), 0, b);
        b.append("[0-9]*");
        return Automaton.minimize(new RegExp(b.toString()).toAutomaton());
    }

    private static void minInteger(String n, int i, StringBuilder b) {
        b.append('(');
        if (i < n.length()) {
            char c = n.charAt(i);
            if (c != '9') {
                b.append("[").append((char)(c + '\u0001')).append("-9][0-9]{").append(n.length() - i - 1).append("}|");
            }
            b.append(c);
            BasicAutomata.minInteger(n, i + 1, b);
        }
        b.append(')');
    }

    public static Automaton makeTotalDigits(int i) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?0*([0-9]{0," + i + "}|((([0-9]\\.*){0," + i + "})&@\\.@)0*)[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeFractionDigits(int i) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?[0-9]+(\\.[0-9]{0," + i + "}0*)?[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeIntegerValue(String value) {
        int i;
        boolean minus2 = false;
        for (i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '-') {
                minus2 = true;
            }
            if (c >= '1' && c <= '9') break;
        }
        StringBuilder b = new StringBuilder();
        b.append(value.substring(i));
        if (b.length() == 0) {
            b.append("0");
        }
        Automaton s2 = minus2 ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton ws = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(ws.concatenate(s2.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(b.toString()))).concatenate(ws));
    }

    public static Automaton makeDecimalValue(String value) {
        int i;
        boolean minus2 = false;
        for (i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '-') {
                minus2 = true;
            }
            if (c >= '1' && c <= '9' || c == '.') break;
        }
        StringBuilder b1 = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        int p = value.indexOf(46, i);
        if (p == -1) {
            b1.append(value.substring(i));
        } else {
            char c;
            b1.append(value.substring(i, p));
            for (i = value.length() - 1; i > p && ((c = value.charAt(i)) < '1' || c > '9'); --i) {
            }
            b2.append(value.substring(p + 1, i + 1));
        }
        if (b1.length() == 0) {
            b1.append("0");
        }
        Automaton s2 = minus2 ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton d = b2.length() == 0 ? Automaton.makeChar('.').concatenate(Automaton.makeChar('0').repeat(1)).optional() : Automaton.makeChar('.').concatenate(Automaton.makeString(b2.toString())).concatenate(Automaton.makeChar('0').repeat());
        Automaton ws = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(ws.concatenate(s2.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(b1.toString())).concatenate(d)).concatenate(ws));
    }

    public static Automaton makeStringMatcher(String s2) {
        Automaton a = new Automaton();
        State[] states = new State[s2.length() + 1];
        states[0] = a.initial;
        for (int i = 0; i < s2.length(); ++i) {
            states[i + 1] = new State();
        }
        State f = states[s2.length()];
        f.accept = true;
        f.transitions.add(new Transition('\u0000', '\uffff', f));
        for (int i = 0; i < s2.length(); ++i) {
            HashSet<Character> done = new HashSet<Character>();
            char c = s2.charAt(i);
            states[i].transitions.add(new Transition(c, states[i + 1]));
            done.add(Character.valueOf(c));
            for (int j = i; j >= 1; --j) {
                char d = s2.charAt(j - 1);
                if (done.contains(Character.valueOf(d)) || !s2.substring(0, j - 1).equals(s2.substring(i - j + 1, i))) continue;
                states[i].transitions.add(new Transition(d, states[j]));
                done.add(Character.valueOf(d));
            }
            char[] da = new char[done.size()];
            int h2 = 0;
            Iterator iterator2 = done.iterator();
            while (iterator2.hasNext()) {
                char w = ((Character)iterator2.next()).charValue();
                da[h2++] = w;
            }
            Arrays.sort(da);
            int from = 0;
            int k = 0;
            while (from <= 65535) {
                while (k < da.length && da[k] == from) {
                    ++k;
                    ++from;
                }
                if (from > 65535) continue;
                int to = 65535;
                if (k < da.length) {
                    to = da[k] - '\u0001';
                    ++k;
                }
                states[i].transitions.add(new Transition((char)from, (char)to, states[0]));
                from = to + 2;
            }
        }
        a.deterministic = true;
        return a;
    }
}

