/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

final class AppDelayQueue
extends DelayQueue<SchedulingWrapper.MyScheduledFutureTask<?>> {
    private static final Logger LOG = Logger.getInstance(AppDelayQueue.class);
    private final TransferThread transferThread = new TransferThread();
    private final AtomicReference<Throwable> shutdownTrace = new AtomicReference();
    private volatile SchedulingWrapper.MyScheduledFutureTask<Void> myPoisonPill;

    AppDelayQueue() {
        this.transferThread.setDaemon(true);
        this.transferThread.start();
    }

    void shutdown(@NotNull SchedulingWrapper.MyScheduledFutureTask<Void> poisonPill) {
        Throwable throwable;
        if (poisonPill == null) {
            AppDelayQueue.$$$reportNull$$$0(0);
        }
        if ((throwable = this.shutdownTrace.getAndSet(new Throwable())) != null) {
            throw new IllegalStateException("Already shutdown", throwable);
        }
        this.myPoisonPill = poisonPill;
        super.offer(poisonPill);
    }

    /*
     * WARNING - void declaration
     */
    boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            AppDelayQueue.$$$reportNull$$$0(1);
        }
        if (this.shutdownTrace.get() == null) {
            throw new IllegalStateException("must call shutdown before");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            this.myPoisonPill.get(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
        this.transferThread.join(TimeUnit.NANOSECONDS.toMillis(Math.max(1L, deadline - System.nanoTime())));
        return !this.transferThread.isAlive();
    }

    @Override
    public boolean offer(@NotNull SchedulingWrapper.MyScheduledFutureTask<?> task) {
        Throwable throwable;
        if (task == null) {
            AppDelayQueue.$$$reportNull$$$0(2);
        }
        if ((throwable = this.shutdownTrace.get()) != null) {
            throw new IllegalStateException("Already shutdown", throwable);
        }
        return super.offer(task);
    }

    @NotNull
    Thread getThread() {
        TransferThread transferThread = this.transferThread;
        if (transferThread == null) {
            AppDelayQueue.$$$reportNull$$$0(3);
        }
        return transferThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "poisonPill";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppDelayQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppDelayQueue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shutdown";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "offer";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TransferThread
    extends Thread {
        private TransferThread() {
            super("Periodic tasks thread");
        }

        @Override
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        SchedulingWrapper.MyScheduledFutureTask task = (SchedulingWrapper.MyScheduledFutureTask)AppDelayQueue.this.take();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Took " + BoundedTaskExecutor.info(task));
                        }
                        try {
                            if (task.executeMeInBackendExecutor()) continue block6;
                            break block6;
                        }
                        catch (Throwable e) {
                            try {
                                LOG.error("Error executing " + task, e);
                                continue block6;
                            }
                            catch (Throwable throwable) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    if (AppDelayQueue.this.shutdownTrace.get() != null) continue;
                    LOG.error(e);
                    continue;
                }
                break;
            }
            LOG.debug("AppDelayQueue.TransferrerThread Stopped");
        }
    }
}

