/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EmptyQuery;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import java.util.Collections;

public final class FileSearchUtil {
    public static Query<VirtualFile> findFileRecursively(VirtualFile parentDirectory, String fileName, int levels, long timeout) {
        if (parentDirectory == null) {
            return new EmptyQuery<VirtualFile>();
        }
        QueryExecutor executor = (queryParameters, consumer) -> {
            long endTime = timeout < 0L ? -1L : System.currentTimeMillis() + timeout;
            return FileSearchUtil.processFileRecursively(parentDirectory, 1, levels, file2 -> {
                if (endTime > 0L && System.currentTimeMillis() > endTime) {
                    return false;
                }
                return !file2.getName().equals(fileName) || consumer.process(file2);
            });
        };
        return new ExecutorsQuery(fileName, Collections.singletonList(executor));
    }

    private static boolean processFileRecursively(VirtualFile parentDirectory, int curLevel, int maxLevel, Processor<? super VirtualFile> processor) {
        VirtualFile[] files2 = parentDirectory.getChildren();
        if (files2 != null) {
            for (VirtualFile file2 : files2) {
                if (!(file2.isDirectory() ? curLevel < maxLevel && !FileSearchUtil.processFileRecursively(file2, curLevel + 1, maxLevel, processor) : !processor.process(file2))) continue;
                return false;
            }
        }
        return true;
    }
}

