/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppMode {
    public static final String DISABLE_NON_BUNDLED_PLUGINS = "disableNonBundledPlugins";
    public static final String DONT_REOPEN_PROJECTS = "dontReopenProjects";
    public static final String FORCE_PLUGIN_UPDATES = "idea.force.plugin.updates";
    public static final String CWM_HOST_COMMAND = "cwmHost";
    public static final String SPLIT_MODE_COMMAND = "splitMode";
    public static final String CWM_HOST_NO_LOBBY_COMMAND = "cwmHostNoLobby";
    public static final String REMOTE_DEV_HOST_COMMAND = "remoteDevHost";
    static final String PLATFORM_PREFIX_PROPERTY = "idea.platform.prefix";
    static final String HELP_OPTION = "--help";
    static final String VERSION_OPTION = "--version";
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static boolean isHeadless;
    private static boolean isCommandLine;
    private static boolean isLightEdit;
    private static boolean disableNonBundledPlugins;
    private static boolean dontReopenProjects;
    private static boolean isRemoteDevHost;

    public static boolean isDisableNonBundledPlugins() {
        return disableNonBundledPlugins;
    }

    public static boolean isDontReopenProjects() {
        return dontReopenProjects;
    }

    public static boolean isLightEdit() {
        return isLightEdit;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isRemoteDevHost() {
        return isRemoteDevHost;
    }

    public static boolean isDevServer() {
        return Boolean.getBoolean("idea.use.dev.build.server");
    }

    public static void setFlags(@NotNull List<String> args2) {
        if (args2 == null) {
            AppMode.$$$reportNull$$$0(0);
        }
        isCommandLine = (isHeadless = AppMode.isHeadless(args2)) || !args2.isEmpty() && AppMode.isGuiCommand(args2.get(0));
        boolean bl = isLightEdit = "LightEdit".equals(System.getProperty(PLATFORM_PREFIX_PROPERTY)) || !isCommandLine && AppMode.isFileAfterOptions(args2);
        if (isHeadless) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        }
        if (args2.isEmpty()) {
            return;
        }
        isRemoteDevHost = CWM_HOST_COMMAND.equals(args2.get(0)) || CWM_HOST_NO_LOBBY_COMMAND.equals(args2.get(0)) || REMOTE_DEV_HOST_COMMAND.equals(args2.get(0)) || SPLIT_MODE_COMMAND.equals(args2.get(0));
        for (String arg2 : args2) {
            if (DISABLE_NON_BUNDLED_PLUGINS.equalsIgnoreCase(arg2)) {
                disableNonBundledPlugins = true;
                continue;
            }
            if (!DONT_REOPEN_PROJECTS.equalsIgnoreCase(arg2)) continue;
            dontReopenProjects = true;
        }
    }

    private static boolean isGuiCommand(String arg2) {
        return "diff".equals(arg2) || "merge".equals(arg2);
    }

    private static boolean isFileAfterOptions(@NotNull List<String> args2) {
        if (args2 == null) {
            AppMode.$$$reportNull$$$0(1);
        }
        for (String arg2 : args2) {
            if (!arg2.startsWith("-")) {
                try {
                    Path path = Paths.get(arg2, new String[0]);
                    return Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0]);
                }
                catch (Throwable t2) {
                    return false;
                }
            }
            if (!arg2.equals("-l") && !arg2.equals("--line") && !arg2.equals("-c") && !arg2.equals("--column")) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public static void setHeadlessInTestMode(boolean headless) {
        isHeadless = headless;
        isCommandLine = true;
        isLightEdit = false;
    }

    private static boolean isHeadless(List<String> args2) {
        if (Boolean.getBoolean(AWT_HEADLESS)) {
            return true;
        }
        if (args2.isEmpty()) {
            return false;
        }
        String firstArg = args2.get(0);
        List<String> headlessCommands = Arrays.asList("ant", "duplocate", "dataSources", "dump-launch-parameters", "dump-shared-index", "traverseUI", "buildAppcodeCache", "format", "keymap", "update", "inspections", "intentions", "rdserver-headless", "thinClient-headless", "installPlugins", "dumpActions", "cwmHostStatus", "remoteDevStatus", "invalidateCaches", "warmup", "buildEventsScheme", "inspectopedia-generator", "remoteDevShowHelp", "installGatewayProtocolHandler", "uninstallGatewayProtocolHandler", "appcodeClangModulesDiff", "appcodeClangModulesPrinter", "exit", "qodanaExcludedPlugins");
        return headlessCommands.contains(firstArg) || firstArg.length() < 20 && firstArg.endsWith("inspect");
    }

    @Nullable
    public static String getDevIdeaProjectDir() {
        return System.getProperty("idea.dev.project.root");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "args";
        objectArray2[1] = "com/intellij/idea/AppMode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFlags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileAfterOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

