/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparisonUtil {
    public static boolean isEquals(@Nullable CharSequence text1, @Nullable CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (policy == null) {
            ComparisonUtil.$$$reportNull$$$0(0);
        }
        if (text1 == text2) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        switch (policy) {
            case DEFAULT: {
                return StringUtilRt.equal(text1, text2, true);
            }
            case TRIM_WHITESPACES: {
                return Strings.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return Strings.equalsIgnoreWhitespaces(text1, text2);
            }
        }
        throw new IllegalArgumentException(policy.toString());
    }

    public static int hashCode(@NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text2 == null) {
            ComparisonUtil.$$$reportNull$$$0(1);
        }
        if (policy == null) {
            ComparisonUtil.$$$reportNull$$$0(2);
        }
        switch (policy) {
            case DEFAULT: {
                return Strings.stringHashCode(text2);
            }
            case TRIM_WHITESPACES: {
                int offset1 = TrimUtil.trimStart(text2, 0, text2.length());
                int offset2 = TrimUtil.trimEnd(text2, offset1, text2.length());
                return Strings.stringHashCode(text2, offset1, offset2);
            }
            case IGNORE_WHITESPACES: {
                return Strings.stringHashCodeIgnoreWhitespaces(text2);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    public static boolean isEqualTexts(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            ComparisonUtil.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            ComparisonUtil.$$$reportNull$$$0(4);
        }
        if (policy == null) {
            ComparisonUtil.$$$reportNull$$$0(5);
        }
        switch (policy) {
            case DEFAULT: {
                return StringUtilRt.equal(text1, text2, true);
            }
            case TRIM_WHITESPACES: {
                return ComparisonUtil.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return Strings.equalsIgnoreWhitespaces(text1, text2);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        boolean lastLine1;
        if (s1 == null) {
            ComparisonUtil.$$$reportNull$$$0(6);
        }
        if (s2 == null) {
            ComparisonUtil.$$$reportNull$$$0(7);
        }
        int index1 = 0;
        int index2 = 0;
        do {
            CharSequence line2;
            lastLine1 = false;
            boolean lastLine2 = false;
            int end1 = Strings.indexOf(s1, '\n', index1) + 1;
            int end2 = Strings.indexOf(s2, '\n', index2) + 1;
            if (end1 == 0) {
                end1 = s1.length();
                lastLine1 = true;
            }
            if (end2 == 0) {
                end2 = s2.length();
                lastLine2 = true;
            }
            if (lastLine1 ^ lastLine2) {
                return false;
            }
            CharSequence line1 = s1.subSequence(index1, end1);
            if (!Strings.equalsTrimWhitespaces(line1, line2 = s2.subSequence(index2, end2))) {
                return false;
            }
            index1 = end1;
            index2 = end2;
        } while (!lastLine1);
        return true;
    }

    public static int getUnimportantLineCharCount() {
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/comparison/ComparisonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquals";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hashCode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTexts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "equalsTrimWhitespaces";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

