/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.BouncingTargetMetadata;
import org.parchmentmc.feather.metadata.BouncingTargetMetadataBuilder;
import org.parchmentmc.feather.metadata.ImmutableMethodMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.metadata.ReferenceBuilder;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;
import org.parchmentmc.feather.util.AccessFlag;
import org.parchmentmc.feather.util.CollectorUtils;
import org.parchmentmc.feather.util.HasImmutable;

public final class MethodMetadataBuilder
implements MethodMetadata {
    private Named owner = Named.empty();
    private boolean lambda = false;
    private BouncingTargetMetadata bouncingTarget = null;
    private LinkedHashSet<Reference> overrides = Sets.newLinkedHashSet();
    private Named name = Named.empty();
    private int securitySpecification = 0;
    private Named descriptor = Named.empty();
    private Named signature = Named.empty();
    private int startLine = 0;
    private int endLine = 0;
    private Reference parent = null;

    private MethodMetadataBuilder() {
    }

    public static MethodMetadataBuilder create(MethodMetadata target) {
        if (target == null) {
            return MethodMetadataBuilder.create();
        }
        return MethodMetadataBuilder.create().withOwner(target.getOwner()).withLambda(target.isLambda()).withBouncingTarget(target.getBouncingTarget().orElse(null)).withParent(target.getParent().orElse(null)).withOverrides(target.getOverrides()).withName(target.getName()).withSecuritySpecification(target.getSecuritySpecification()).withDescriptor(target.getDescriptor()).withSignature(target.getSignature()).withStartLine(target.getStartLine().orElse(0)).withEndLine(target.getEndLine().orElse(0));
    }

    public static MethodMetadataBuilder create() {
        return new MethodMetadataBuilder();
    }

    public MethodMetadataBuilder withEndLine(int endLine) {
        this.endLine = endLine;
        return this;
    }

    public MethodMetadataBuilder withStartLine(int startLine) {
        this.startLine = startLine;
        return this;
    }

    public MethodMetadataBuilder withSignature(Named signature) {
        this.signature = signature;
        return this;
    }

    public MethodMetadataBuilder withDescriptor(Named descriptor2) {
        this.descriptor = descriptor2;
        return this;
    }

    public MethodMetadataBuilder withSecuritySpecification(int securitySpecification) {
        this.securitySpecification = securitySpecification;
        return this;
    }

    public MethodMetadataBuilder withName(Named name) {
        this.name = name;
        return this;
    }

    public MethodMetadataBuilder withOverrides(LinkedHashSet<Reference> overrides) {
        this.overrides = overrides;
        return this;
    }

    public MethodMetadataBuilder withParent(Reference parent) {
        this.parent = parent;
        return this;
    }

    public MethodMetadataBuilder withBouncingTarget(BouncingTargetMetadata bouncingTarget) {
        this.bouncingTarget = bouncingTarget;
        return this;
    }

    public MethodMetadataBuilder withLambda(boolean lambda) {
        this.lambda = lambda;
        return this;
    }

    public MethodMetadataBuilder withOwner(Named owner) {
        this.owner = owner;
        return this;
    }

    public MethodMetadataBuilder merge(MethodMetadata source, String schema) {
        if (source == null) {
            return this;
        }
        this.owner = NamedBuilder.create(this.owner).merge(source.getOwner()).build();
        this.lambda = this.lambda || source.isLambda();
        this.bouncingTarget = BouncingTargetMetadataBuilder.create(this.bouncingTarget).merge(source.getBouncingTarget().orElse(null)).build();
        Map schemadLocalOverrides = this.overrides.stream().collect(CollectorUtils.toLinkedMap(mr -> ReferenceBuilder.create().withName(NamedBuilder.create().with(schema, mr.getName().getName(schema).orElse(""))).withOwner(NamedBuilder.create().with(schema, mr.getOwner().getName(schema).orElse(""))).withDescriptor(NamedBuilder.create().with(schema, mr.getDescriptor().getName(schema).orElse(""))).withSignature(NamedBuilder.create().with(schema, mr.getSignature().getName(schema).orElse(""))).build(), Function.identity(), (t2, i) -> t2));
        Map schemadSoureOverrides = source.getOverrides().stream().collect(CollectorUtils.toLinkedMap(mr -> ReferenceBuilder.create().withName(NamedBuilder.create().with(schema, mr.getName().getName(schema).orElse(""))).withOwner(NamedBuilder.create().with(schema, mr.getOwner().getName(schema).orElse(""))).withDescriptor(NamedBuilder.create().with(schema, mr.getDescriptor().getName(schema).orElse(""))).withSignature(NamedBuilder.create().with(schema, mr.getSignature().getName(schema).orElse(""))).build(), Function.identity(), (t2, i) -> t2));
        this.overrides = new LinkedHashSet();
        for (Reference keyReference : schemadLocalOverrides.keySet()) {
            if (!schemadSoureOverrides.containsKey(keyReference)) {
                this.overrides.add((Reference)schemadLocalOverrides.get(keyReference));
                continue;
            }
            this.overrides.add(ReferenceBuilder.create((Reference)schemadLocalOverrides.get(keyReference)).merge((Reference)schemadSoureOverrides.get(keyReference)).build());
        }
        schemadSoureOverrides.keySet().stream().filter(mr -> !schemadLocalOverrides.containsKey(mr)).forEach(mr -> this.overrides.add((Reference)schemadSoureOverrides.get(mr)));
        this.name = NamedBuilder.create(this.name).merge(source.getName()).build();
        EnumSet<AccessFlag> thisAccessFlags = AccessFlag.getAccessFlags(this.securitySpecification);
        EnumSet<AccessFlag> sourceAccessFlags = AccessFlag.getAccessFlags(source.getSecuritySpecification());
        EnumSet<AccessFlag> mergedFlags = EnumSet.noneOf(AccessFlag.class);
        mergedFlags.addAll(thisAccessFlags);
        mergedFlags.addAll(sourceAccessFlags);
        this.securitySpecification = AccessFlag.toSecuritySpecification(mergedFlags);
        this.descriptor = NamedBuilder.create(this.descriptor).merge(source.getDescriptor()).build();
        this.signature = NamedBuilder.create(this.signature).merge(source.getSignature()).build();
        this.startLine = source.getStartLine().orElse(this.startLine);
        this.endLine = source.getEndLine().orElse(this.endLine);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.getOwner(), this.isLambda(), this.getBouncingTarget(), this.getOverrides(), this.getName(), this.getSecuritySpecification(), this.getDescriptor(), this.getSignature(), this.getStartLine(), this.getEndLine());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodMetadataBuilder)) {
            return false;
        }
        MethodMetadataBuilder builder = (MethodMetadataBuilder)o;
        return this.isLambda() == builder.isLambda() && this.getSecuritySpecification() == builder.getSecuritySpecification() && this.getStartLine() == builder.getStartLine() && this.getEndLine() == builder.getEndLine() && this.getOwner().equals(builder.getOwner()) && this.getBouncingTarget().equals(builder.getBouncingTarget()) && this.getOverrides().equals(builder.getOverrides()) && this.getName().equals(builder.getName()) && this.getDescriptor().equals(builder.getDescriptor()) && this.getSignature().equals(builder.getSignature());
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public boolean isLambda() {
        return this.lambda;
    }

    @Override
    public Optional<BouncingTargetMetadata> getBouncingTarget() {
        return Optional.ofNullable(this.bouncingTarget);
    }

    @Override
    public Optional<Reference> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public @NonNull LinkedHashSet<Reference> getOverrides() {
        return this.overrides;
    }

    @Override
    public @NonNull Optional<Integer> getStartLine() {
        if (this.startLine <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.startLine);
    }

    @Override
    public @NonNull Optional<Integer> getEndLine() {
        if (this.endLine <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.endLine);
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }

    @Override
    public int getSecuritySpecification() {
        return this.securitySpecification;
    }

    @Override
    public @NonNull Named getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    @Override
    public @NonNull MethodMetadata toImmutable() {
        return this.build();
    }

    public MethodMetadata build() {
        return new ImmutableMethodMetadata((Named)this.owner.toImmutable(), this.lambda, this.bouncingTarget == null ? null : (BouncingTargetMetadata)this.bouncingTarget.toImmutable(), this.parent, this.overrides.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()), (Named)this.name.toImmutable(), this.securitySpecification, (Named)this.descriptor.toImmutable(), (Named)this.signature.toImmutable(), this.startLine, this.endLine);
    }
}

