/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import org.parchmentmc.feather.metadata.BouncingTargetMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.metadata.MethodMetadataBuilder;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.named.Named;

class MethodMetadataAdapter
extends TypeAdapter<MethodMetadata> {
    private static final TypeToken<LinkedHashSet<Reference>> METHOD_REFERENCE_Set_TOKEN = new TypeToken<LinkedHashSet<Reference>>(){};
    private final Gson gson;

    public MethodMetadataAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, MethodMetadata value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.gson.toJson((Object)value.getName(), (Type)((Object)Named.class), out);
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), (Type)((Object)Named.class), out);
        out.name("security").value(value.getSecuritySpecification());
        out.name("descriptor");
        this.gson.toJson((Object)value.getDescriptor(), (Type)((Object)Named.class), out);
        out.name("signature");
        this.gson.toJson((Object)value.getSignature(), (Type)((Object)Named.class), out);
        out.name("lambda").value(value.isLambda());
        if (value.getBouncingTarget().isPresent()) {
            out.name("bouncingTarget");
            this.gson.toJson((Object)value.getBouncingTarget().get(), (Type)((Object)BouncingTargetMetadata.class), out);
        }
        if (value.getParent().isPresent()) {
            out.name("parent");
            this.gson.toJson((Object)value.getParent().get(), (Type)((Object)Reference.class), out);
        }
        if (!value.getOverrides().isEmpty()) {
            out.name("overrides");
            this.gson.toJson(value.getOverrides(), METHOD_REFERENCE_Set_TOKEN.getType(), out);
        }
        if (value.getStartLine().isPresent()) {
            out.name("startLine");
            out.value(value.getStartLine().orElse(0));
        }
        if (value.getEndLine().isPresent()) {
            out.name("endLine");
            out.value(value.getEndLine().orElse(0));
        }
        out.endObject();
    }

    @Override
    public MethodMetadata read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named name = Named.empty();
        Named owner = Named.empty();
        int security = -1;
        Named descriptor2 = Named.empty();
        Named signature = Named.empty();
        boolean lambda = false;
        BouncingTargetMetadata bouncingTarget = null;
        LinkedHashSet<Reference> overrides = null;
        int startLine = 0;
        int endLine = 0;
        Reference parent = null;
        in.beginObject();
        block26: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "name": {
                    name = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "security": {
                    security = in.nextInt();
                    continue block26;
                }
                case "descriptor": {
                    descriptor2 = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "signature": {
                    signature = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block26;
                }
                case "lambda": {
                    lambda = in.nextBoolean();
                    continue block26;
                }
                case "bouncingTarget": {
                    bouncingTarget = (BouncingTargetMetadata)this.gson.fromJson(in, (Type)((Object)BouncingTargetMetadata.class));
                    continue block26;
                }
                case "parent": {
                    parent = (Reference)this.gson.fromJson(in, (Type)((Object)Reference.class));
                    continue block26;
                }
                case "overrides": {
                    overrides = (LinkedHashSet<Reference>)this.gson.fromJson(in, METHOD_REFERENCE_Set_TOKEN.getType());
                    continue block26;
                }
                case "startLine": {
                    startLine = in.nextInt();
                    continue block26;
                }
                case "endLine": {
                    endLine = in.nextInt();
                    continue block26;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (name.isEmpty()) {
            throw new JsonParseException("Method metadata name is not present or empty");
        }
        if (owner.isEmpty()) {
            throw new JsonParseException("Method metadata owner is not present or empty");
        }
        if (descriptor2.isEmpty()) {
            throw new JsonParseException("Method metadata descriptor is not present or empty");
        }
        if (security == -1) {
            throw new JsonParseException("Method metadata security specification is not present");
        }
        if (overrides == null) {
            overrides = new LinkedHashSet<Reference>();
        }
        if (startLine < 0) {
            throw new JsonParseException("Method metadata contains negative start line");
        }
        if (endLine < 0) {
            throw new JsonParseException("Method metadata contains negative end line");
        }
        if (endLine < startLine) {
            throw new JsonParseException("Method metadata contains end before start");
        }
        return MethodMetadataBuilder.create().withBouncingTarget(bouncingTarget).withName(name).withOwner(owner).withDescriptor(descriptor2).withSignature(signature).withSecuritySpecification(security).withParent(parent).withOverrides(overrides).withStartLine(startLine).withEndLine(endLine).withLambda(lambda).build();
    }
}

