/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.problems;

import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class ProblemLocation {
    private final Path file;
    @Nullable
    private final Integer line;
    @Nullable
    private final Integer column;
    @Nullable
    private final Integer offset;
    @Nullable
    private final Integer length;

    private ProblemLocation(Path file2, @Nullable Integer line, @Nullable Integer column, @Nullable Integer offset, @Nullable Integer length) {
        this.file = Objects.requireNonNull(file2, "file");
        if (line != null && line <= 0) {
            throw new IllegalArgumentException("Line for problem location must be 1 or higher: " + line);
        }
        if (column != null && column <= 0) {
            throw new IllegalArgumentException("Column for problem location must be 1 or higher: " + column);
        }
        if (offset != null) {
            if (length == null) {
                throw new IllegalArgumentException("When an offset is given, a length must also be given.");
            }
            if (offset < 0) {
                throw new IllegalArgumentException("Byte-Offset for problem location must not be negative: " + offset);
            }
        }
        if (length != null && length < 0) {
            throw new IllegalArgumentException("Length for problem location must not be negative: " + length);
        }
        this.line = line;
        this.column = column;
        this.offset = offset;
        this.length = length;
    }

    public static ProblemLocation ofFile(Path file2) {
        return new ProblemLocation(file2, null, null, null, null);
    }

    public static ProblemLocation ofLocationInFile(Path file2, int line) {
        return new ProblemLocation(file2, line, null, null, null);
    }

    public static ProblemLocation ofLocationInFile(Path file2, int line, int column) {
        return new ProblemLocation(file2, line, column, null, null);
    }

    public static ProblemLocation ofLocationInFile(Path file2, int line, int column, int length) {
        return new ProblemLocation(file2, line, column, null, length);
    }

    public static ProblemLocation ofOffsetInFile(Path file2, int offset, int length) {
        return new ProblemLocation(file2, null, null, offset, length);
    }

    public ProblemLocation withFile(Path file2) {
        return new ProblemLocation(file2, this.line, this.column, this.offset, this.length);
    }

    public Path file() {
        return this.file;
    }

    @Nullable
    public Integer line() {
        return this.line;
    }

    @Nullable
    public Integer column() {
        return this.column;
    }

    @Nullable
    public Integer offset() {
        return this.offset;
    }

    @Nullable
    public Integer length() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ProblemLocation that = (ProblemLocation)obj;
        return Objects.equals(this.file, that.file) && Objects.equals(this.line, that.line) && Objects.equals(this.column, that.column) && Objects.equals(this.offset, that.offset) && Objects.equals(this.length, that.length);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.line, this.column, this.offset, this.length);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.file);
        if (this.line != null) {
            result2.append(':').append(this.line);
            if (this.column != null) {
                result2.append(':').append(this.column);
                if (this.length != null) {
                    result2.append('-').append(this.column + this.length);
                }
            }
        } else if (this.offset != null) {
            result2.append(':').append(this.offset).append('b');
            if (this.length != null) {
                result2.append('-').append(this.offset + this.length).append('b');
            }
        }
        return result2.toString();
    }
}

