/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.unpick;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupFormat;
import daomephsta.unpick.constantmappers.datadriven.tree.Literal;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.BinaryExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.CastExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionVisitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.LiteralExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ParenExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.UnaryExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Predicate;
import net.neoforged.jst.api.ImportHelper;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.unpick.NumberType;
import net.neoforged.jst.unpick.UnpickCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnpickVisitor
extends PsiRecursiveElementVisitor {
    private static final Key<Boolean> UNPICK_WAS_REPLACED = Key.create("unpick.was_replaced");
    private final PsiFile file;
    private final UnpickCollection collection;
    private final Replacements replacements;
    @Nullable
    private PsiMethod methodContext;
    @Nullable
    private PsiField fieldContext;
    @Nullable
    private TargetMethod calledMethodContext;
    private int currentParameterIndex;
    private final Stack<Collection<UnpickCollection.Group>> contextStack = new Stack();

    public UnpickVisitor(PsiFile file2, UnpickCollection collection, Replacements replacements) {
        this.file = file2;
        this.collection = collection;
        this.replacements = replacements;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        Collection<Object> additionalContext = List.of();
        PsiElement psiElement = element;
        Objects.requireNonNull(psiElement);
        PsiElement psiElement2 = psiElement;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiJavaFile.class, PsiClass.class, PsiMethod.class, PsiField.class, PsiJavaToken.class, PsiMethodCallExpression.class, PsiReturnStatement.class, PsiLocalVariable.class, PsiAssignmentExpression.class}, (Object)psiElement2, n)) {
                case 0: {
                    PsiJavaFile javaFile = (PsiJavaFile)psiElement2;
                    additionalContext = this.collection.getPackageContext(javaFile);
                    break block11;
                }
                case 1: {
                    PsiClass cls = (PsiClass)psiElement2;
                    additionalContext = this.collection.getClassContext(cls);
                    break block11;
                }
                case 2: {
                    PsiMethod met = (PsiMethod)psiElement2;
                    if (met.getBody() == null) {
                        n = 3;
                        continue block11;
                    }
                    PsiMethod oldCtx = this.methodContext;
                    this.contextStack.push(this.collection.getMethodContext(met));
                    this.methodContext = met;
                    met.getBody().acceptChildren(this);
                    this.methodContext = oldCtx;
                    this.contextStack.pop();
                    return;
                }
                case 3: {
                    PsiField fld = (PsiField)psiElement2;
                    PsiField oldCtx = this.fieldContext;
                    this.fieldContext = fld;
                    fld.acceptChildren(this);
                    this.fieldContext = oldCtx;
                    return;
                }
                case 4: {
                    PsiJavaToken tok = (PsiJavaToken)psiElement2;
                    this.visitToken(tok);
                    return;
                }
                case 5: {
                    PsiMethodCallExpression call2 = (PsiMethodCallExpression)psiElement2;
                    PsiElement ref = PsiHelper.resolve(call2.getMethodExpression());
                    if (!(ref instanceof PsiMethod)) break block11;
                    PsiMethod met = (PsiMethod)ref;
                    TargetMethod oldCtx = this.calledMethodContext;
                    int oldIdx = this.currentParameterIndex;
                    this.calledMethodContext = this.collection.getDefinitionsFor(met);
                    for (int i = 0; i < call2.getArgumentList().getExpressions().length; ++i) {
                        this.currentParameterIndex = i;
                        this.acceptPossibleLocalVarReference(call2.getArgumentList().getExpressions()[i]);
                    }
                    this.calledMethodContext = oldCtx;
                    this.currentParameterIndex = oldIdx;
                    return;
                }
                case 6: {
                    Collection<UnpickCollection.Group> groups2;
                    PsiReturnStatement returnStatement = (PsiReturnStatement)psiElement2;
                    if (this.methodContext == null) {
                        n = 7;
                        continue block11;
                    }
                    TargetMethod contextDefinitions = this.collection.getDefinitionsFor(this.methodContext);
                    if (contextDefinitions == null || contextDefinitions.returnGroup() == null || (groups2 = this.collection.getGroups(contextDefinitions.returnGroup())).isEmpty()) break block11;
                    this.contextStack.push(groups2);
                    this.acceptPossibleLocalVarReference(returnStatement.getReturnValue());
                    this.contextStack.pop();
                    return;
                }
                case 7: {
                    PsiExpression oldIdx;
                    PsiLocalVariable localVar = (PsiLocalVariable)psiElement2;
                    if (localVar.getInitializer() == null || !((oldIdx = localVar.getInitializer()) instanceof PsiMethodCallExpression)) {
                        n = 8;
                        continue block11;
                    }
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)oldIdx;
                    this.acceptReturnFlow(localVar, methodCall);
                    return;
                }
                case 8: {
                    PsiExpression psiExpression;
                    PsiReferenceExpression ref;
                    PsiElement referencedVariable;
                    PsiExpression psiExpression2;
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)psiElement2;
                    if (assignment.getOperationSign().getTokenType() != JavaTokenType.EQ || !((psiExpression2 = assignment.getLExpression()) instanceof PsiReferenceExpression) || !((referencedVariable = PsiHelper.resolve(ref = (PsiReferenceExpression)psiExpression2)) instanceof PsiLocalVariable) && !(referencedVariable instanceof PsiParameter) || !((psiExpression = assignment.getLExpression()) instanceof PsiMethodCallExpression)) break block11;
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)psiExpression;
                    this.acceptReturnFlow((PsiVariable)referencedVariable, methodCall);
                    return;
                }
            }
            break;
        }
        if (additionalContext.isEmpty()) {
            element.acceptChildren(this);
        } else {
            this.contextStack.push(additionalContext);
            element.acceptChildren(this);
            this.contextStack.pop();
        }
    }

    private void acceptReturnFlow(PsiVariable variable, PsiMethodCallExpression expression) {
        Collection<UnpickCollection.Group> groups2;
        TargetMethod target;
        PsiMethod flowingFrom = expression.resolveMethod();
        if (flowingFrom != null && (target = this.collection.getDefinitionsFor(flowingFrom)) != null && target.returnGroup() != null && !(groups2 = this.collection.getGroups(target.returnGroup())).isEmpty()) {
            this.contextStack.push(groups2);
            this.visitVariableAssignments(variable);
            this.contextStack.pop();
            return;
        }
        expression.acceptChildren(this);
    }

    private void acceptPossibleLocalVarReference(PsiExpression expression) {
        PsiReferenceExpression refEx;
        PsiElement resolved;
        if (expression instanceof PsiReferenceExpression && ((resolved = PsiHelper.resolve(refEx = (PsiReferenceExpression)expression)) instanceof PsiLocalVariable || resolved instanceof PsiParameter)) {
            this.visitVariableAssignments((PsiVariable)resolved);
            return;
        }
        if (expression != null) {
            this.visitElement(expression);
        }
    }

    private void visitVariableAssignments(final PsiVariable var) {
        PsiCodeBlock body;
        if (var.getInitializer() != null) {
            var.getInitializer().accept(this.limitedDirectVisitor());
        }
        PsiCodeBlock psiCodeBlock = body = this.methodContext == null ? null : this.methodContext.getBody();
        if (body != null) {
            new PsiRecursiveElementVisitor(){

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element instanceof PsiAssignmentExpression) {
                        PsiReferenceExpression ref;
                        PsiExpression psiExpression;
                        PsiAssignmentExpression as = (PsiAssignmentExpression)element;
                        if (as.getOperationSign().getTokenType() == JavaTokenType.EQ && (psiExpression = as.getLExpression()) instanceof PsiReferenceExpression && PsiHelper.resolve(ref = (PsiReferenceExpression)psiExpression) == var && as.getRExpression() != null) {
                            as.getRExpression().accept(UnpickVisitor.this.limitedDirectVisitor());
                        }
                        return;
                    }
                    super.visitElement(element);
                }
            }.visitElement(body);
        }
    }

    private PsiRecursiveElementVisitor limitedDirectVisitor() {
        return new PsiRecursiveElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof PsiCallExpression) {
                    return;
                }
                if (element instanceof PsiJavaToken) {
                    PsiJavaToken tok = (PsiJavaToken)element;
                    UnpickVisitor.this.visitToken(tok);
                    return;
                }
                super.visitElement(element);
            }
        };
    }

    private void visitToken(PsiJavaToken tok) {
        if (Boolean.TRUE.equals(tok.getUserData(UNPICK_WAS_REPLACED))) {
            return;
        }
        if (tok.getTokenType() == JavaTokenType.STRING_LITERAL) {
            String val = tok.getText().substring(1);
            String finalVal = val.substring(0, val.length() - 1);
            this.forInScope(group -> {
                Expression ct = group.constants().get(finalVal);
                if (ct != null && this.checkNotRecursive(ct)) {
                    this.replacements.replace(tok, this.write(ct));
                    tok.putUserData(UNPICK_WAS_REPLACED, true);
                    return true;
                }
                return false;
            });
        } else if (tok.getTokenType() == JavaTokenType.INTEGER_LITERAL) {
            String text2 = tok.getText().toLowerCase(Locale.ROOT);
            int val = text2.startsWith("0x") ? Integer.parseUnsignedInt(text2.substring(2), 16) : (text2.startsWith("0b") ? Integer.parseUnsignedInt(text2.substring(2), 2) : Integer.parseUnsignedInt(text2));
            if (this.isUnaryMinus(tok)) {
                val = -val;
            }
            this.replaceLiteral(tok, val, NumberType.INT);
        } else if (tok.getTokenType() == JavaTokenType.LONG_LITERAL) {
            String text3 = UnpickVisitor.removeSuffix(tok.getText(), 'l').toLowerCase(Locale.ROOT);
            long val = text3.startsWith("0x") ? Long.parseUnsignedLong(text3.substring(2), 16) : (text3.startsWith("0b") ? Long.parseUnsignedLong(text3.substring(2), 2) : Long.parseUnsignedLong(text3));
            if (this.isUnaryMinus(tok)) {
                val = -val;
            }
            this.replaceLiteral(tok, val, NumberType.LONG);
        } else if (tok.getTokenType() == JavaTokenType.DOUBLE_LITERAL) {
            double val = Double.parseDouble(UnpickVisitor.removeSuffix(tok.getText(), 'd'));
            if (this.isUnaryMinus(tok)) {
                val = -val;
            }
            this.replaceLiteral(tok, val, NumberType.DOUBLE);
        } else if (tok.getTokenType() == JavaTokenType.FLOAT_LITERAL) {
            float val = Float.parseFloat(UnpickVisitor.removeSuffix(tok.getText(), 'f'));
            if (this.isUnaryMinus(tok)) {
                val = -val;
            }
            this.replaceLiteral(tok, Float.valueOf(val), NumberType.FLOAT);
        }
    }

    private void replaceLiteral(PsiJavaToken element, Number number, NumberType type) {
        this.replaceLiteral(element, number, type, false);
    }

    private boolean replaceLiteral(PsiJavaToken element, Number number, NumberType type, boolean denyStrict) {
        return this.forInScope(group -> {
            String flag2;
            if (group.strict() && denyStrict) {
                return false;
            }
            Expression ct = group.constants().get(number);
            if (ct != null && this.checkNotRecursive(ct)) {
                this.replacements.replace(element, this.write(ct));
                element.putUserData(UNPICK_WAS_REPLACED, true);
                this.replaceMinus(element);
                return true;
            }
            if (group.flag() && type.supportsFlag && (flag2 = this.generateFlag((UnpickCollection.Group)group, number.longValue(), type)) != null) {
                this.replacements.replace(element, flag2);
                element.putUserData(UNPICK_WAS_REPLACED, true);
                this.replaceMinus(element);
                return true;
            }
            if (group.format() != null) {
                this.replacements.replace(element, this.formatAs(number, group.format()));
                this.replaceMinus(element);
                element.putUserData(UNPICK_WAS_REPLACED, true);
                return true;
            }
            for (NumberType from : type.widenFrom) {
                Number lower = from.cast(number);
                if (lower.doubleValue() != number.doubleValue() || !this.replaceLiteral(element, lower, from, true)) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isUnaryMinus(PsiJavaToken tok) {
        PsiPrefixExpression ex;
        PsiLiteralExpression lit;
        PsiElement psiElement = tok.getParent();
        return psiElement instanceof PsiLiteralExpression && (psiElement = (lit = (PsiLiteralExpression)psiElement).getParent()) instanceof PsiPrefixExpression && (ex = (PsiPrefixExpression)psiElement).getOperationTokenType() == JavaTokenType.MINUS;
    }

    private void replaceMinus(PsiJavaToken tok) {
        PsiPrefixExpression ex;
        PsiLiteralExpression lit;
        PsiElement psiElement = tok.getParent();
        if (psiElement instanceof PsiLiteralExpression && (psiElement = (lit = (PsiLiteralExpression)psiElement).getParent()) instanceof PsiPrefixExpression && (ex = (PsiPrefixExpression)psiElement).getOperationTokenType() == JavaTokenType.MINUS) {
            this.replacements.remove(ex.getOperationSign());
        }
    }

    private boolean checkNotRecursive(Expression expression) {
        if (this.fieldContext != null && this.fieldContext.getContainingClass() != null && expression instanceof FieldExpression) {
            FieldExpression fld = (FieldExpression)expression;
            return !fld.className.equals(this.fieldContext.getContainingClass().getQualifiedName()) || !Objects.equals(fld.fieldName, this.fieldContext.getName());
        }
        return true;
    }

    private boolean forInScope(Predicate<UnpickCollection.Group> apply2) {
        Object paramGroups;
        String paramGroupId;
        if (this.calledMethodContext != null && (paramGroupId = this.calledMethodContext.paramGroups().get(this.currentParameterIndex)) != null && !(paramGroups = this.collection.getGroups(paramGroupId)).isEmpty()) {
            Iterator iterator2 = paramGroups.iterator();
            while (iterator2.hasNext()) {
                UnpickCollection.Group group = (UnpickCollection.Group)iterator2.next();
                if (!apply2.test(group)) continue;
                return true;
            }
        }
        if (!this.contextStack.isEmpty()) {
            for (int i = this.contextStack.size() - 1; i >= 0; --i) {
                for (UnpickCollection.Group group : (Collection)this.contextStack.get(i)) {
                    if (!apply2.test(group)) continue;
                    return true;
                }
            }
        }
        for (UnpickCollection.Group group : this.collection.getGlobalContext()) {
            if (!apply2.test(group)) continue;
            return true;
        }
        return false;
    }

    private String write(Expression expression) {
        final StringBuilder s2 = new StringBuilder();
        expression.accept(new ExpressionVisitor(){

            @Override
            public void visitFieldExpression(FieldExpression fieldExpression) {
                String cls = UnpickVisitor.this.imports().importClass(fieldExpression.className);
                s2.append(cls).append('.').append(fieldExpression.fieldName);
            }

            @Override
            public void visitParenExpression(ParenExpression parenExpression) {
                s2.append('(').append(UnpickVisitor.this.write(parenExpression.expression)).append(')');
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void visitLiteralExpression(LiteralExpression literalExpression) {
                Literal literal = literalExpression.literal;
                if (literal instanceof Literal.String) {
                    Literal.String string3 = (Literal.String)literal;
                    try {
                        String string2;
                        String value = string2 = string3.value();
                        s2.append('\"').append(value.replace("\"", "\\\"")).append('\"');
                        return;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                literal = literalExpression.literal;
                if (literal instanceof Literal.Integer) {
                    Literal.Integer i = (Literal.Integer)literal;
                    s2.append(i.value());
                    return;
                }
                literal = literalExpression.literal;
                if (literal instanceof Literal.Long) {
                    Literal.Long l = (Literal.Long)literal;
                    s2.append(l.value()).append('l');
                    return;
                }
                literal = literalExpression.literal;
                if (literal instanceof Literal.Double) {
                    Literal.Double d = (Literal.Double)literal;
                    s2.append(d).append('d');
                    return;
                }
                literal = literalExpression.literal;
                if (!(literal instanceof Literal.Float)) return;
                Literal.Float f = (Literal.Float)literal;
                s2.append(f).append('f');
            }

            @Override
            public void visitCastExpression(CastExpression castExpression) {
                s2.append('(');
                s2.append(switch (castExpression.castType) {
                    default -> throw new MatchException(null, null);
                    case DataType.INT -> "int";
                    case DataType.CHAR -> "char";
                    case DataType.DOUBLE -> "double";
                    case DataType.BYTE -> "byte";
                    case DataType.LONG -> "long";
                    case DataType.FLOAT -> "float";
                    case DataType.SHORT -> "short";
                    case DataType.STRING -> "String";
                    case DataType.CLASS -> "Class";
                });
                s2.append(')');
                s2.append(UnpickVisitor.this.write(castExpression.operand));
            }

            @Override
            public void visitBinaryExpression(BinaryExpression binaryExpression) {
                s2.append(UnpickVisitor.this.write(binaryExpression.lhs));
                switch (binaryExpression.operator) {
                    case ADD: {
                        s2.append(" + ");
                        break;
                    }
                    case DIVIDE: {
                        s2.append(" / ");
                        break;
                    }
                    case MODULO: {
                        s2.append(" % ");
                        break;
                    }
                    case MULTIPLY: {
                        s2.append(" * ");
                        break;
                    }
                    case SUBTRACT: {
                        s2.append(" - ");
                        break;
                    }
                    case BIT_AND: {
                        s2.append(" & ");
                        break;
                    }
                    case BIT_OR: {
                        s2.append(" | ");
                        break;
                    }
                    case BIT_XOR: {
                        s2.append(" ^ ");
                        break;
                    }
                    case BIT_SHIFT_LEFT: {
                        s2.append(" << ");
                        break;
                    }
                    case BIT_SHIFT_RIGHT: {
                        s2.append(" >> ");
                        break;
                    }
                    case BIT_SHIFT_RIGHT_UNSIGNED: {
                        s2.append(" >>> ");
                    }
                }
                s2.append(UnpickVisitor.this.write(binaryExpression.rhs));
            }

            @Override
            public void visitUnaryExpression(UnaryExpression unaryExpression) {
                switch (unaryExpression.operator) {
                    case NEGATE: {
                        s2.append("!");
                        break;
                    }
                    case BIT_NOT: {
                        s2.append("~");
                    }
                }
                s2.append(UnpickVisitor.this.write(unaryExpression.operand));
            }
        });
        return s2.toString();
    }

    private String formatAs(Number value, GroupFormat format) {
        return switch (format) {
            case GroupFormat.HEX -> {
                if (value instanceof Integer) {
                    yield "0x" + Integer.toHexString(value.intValue()).toUpperCase(Locale.ROOT);
                }
                if (value instanceof Long) {
                    yield "0x" + Long.toHexString(value.longValue()).toUpperCase(Locale.ROOT) + "l";
                }
                if (value instanceof Double) {
                    yield Double.toHexString(value.doubleValue()) + "d";
                }
                if (value instanceof Float) {
                    yield Float.toHexString(value.floatValue()) + "f";
                }
                yield value.toString();
            }
            case GroupFormat.OCTAL -> {
                if (value instanceof Integer) {
                    yield "0" + Integer.toOctalString(value.intValue());
                }
                if (value instanceof Long) {
                    yield "0" + Long.toOctalString(value.longValue()) + "l";
                }
                yield value.toString();
            }
            case GroupFormat.BINARY -> {
                if (value instanceof Integer) {
                    yield "0b" + Integer.toBinaryString(value.intValue());
                }
                if (value instanceof Long) {
                    yield "0b" + Long.toBinaryString(value.longValue()) + "l";
                }
                yield value.toString();
            }
            case GroupFormat.CHAR -> "'" + (char)value.intValue() + "'";
            default -> value.toString();
        };
    }

    private ImportHelper imports() {
        return ImportHelper.get(this.file);
    }

    @Nullable
    private String generateFlag(UnpickCollection.Group group, long val, NumberType type) {
        ArrayList<Expression> constants;
        ArrayList<Expression> negatedConstants;
        ArrayList<Expression> orConstants = new ArrayList<Expression>();
        long orResidual = UnpickVisitor.getConstantsEncompassing(val, type, group, orConstants);
        long negatedLiteral = type.toUnsignedLong(type.negate(val));
        long negatedResidual = UnpickVisitor.getConstantsEncompassing(negatedLiteral, type, group, negatedConstants = new ArrayList<Expression>());
        boolean negated = negatedResidual == 0L && (orResidual != 0L || negatedConstants.size() < orConstants.size());
        ArrayList<Expression> arrayList = constants = negated ? negatedConstants : orConstants;
        if (constants.isEmpty()) {
            return null;
        }
        long residual = negated ? negatedResidual : orResidual;
        StringBuilder replacement = new StringBuilder(this.write((Expression)constants.getFirst()));
        for (int i = 1; i < constants.size(); ++i) {
            replacement.append(" | ");
            replacement.append(this.write((Expression)constants.get(i)));
        }
        if (residual != 0L) {
            replacement.append(" | ").append(residual);
        }
        if (negated) {
            return "~" + String.valueOf(replacement);
        }
        return replacement.toString();
    }

    private static long getConstantsEncompassing(long literal, NumberType unsign, UnpickCollection.Group group, List<Expression> constantsOut) {
        long residual = literal;
        for (Map.Entry<Object, Expression> constant : group.constants().entrySet()) {
            long val = unsign.toUnsignedLong((Number)constant.getKey());
            if ((val & residual) == 0L || (val & literal) != val) continue;
            constantsOut.add(constant.getValue());
            if ((residual &= val ^ 0xFFFFFFFFFFFFFFFFL) != 0L) continue;
            break;
        }
        return residual;
    }

    private static String removeSuffix(String in, char suffix) {
        char lastChar = in.charAt(in.length() - 1);
        if (lastChar == suffix || lastChar == Character.toUpperCase(suffix)) {
            return in.substring(0, in.length() - 1);
        }
        return in;
    }
}

