/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.unpick;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupFormat;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupScope;
import daomephsta.unpick.constantmappers.datadriven.tree.Literal;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.BinaryExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.CastExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.LiteralExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ParenExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.UnaryExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.api.TransformContext;
import net.neoforged.jst.unpick.NumberType;
import org.jetbrains.annotations.Nullable;

public class UnpickCollection {
    private static final Key<Optional<TargetMethod>> UNPICK_DEFINITION = Key.create("unpick.method_definition");
    private static final Key<TargetField> UNPICK_FIELD_TARGET = Key.create("unpick.field_target");
    private final Set<String> possibleTargetNames = new HashSet<String>();
    private final MultiMap<String, Group> groups;
    private final List<Group> global;
    private final MultiMap<String, Group> byPackage;
    private final MultiMap<String, Group> byClass;
    private final MultiMap<PsiMethod, Group> methodScopes;
    private final List<PsiElement> baseElements;

    public UnpickCollection(TransformContext context2, Map<TypedKey, List<GroupDefinition>> groups2, List<TargetField> fields, List<TargetMethod> methods) {
        PsiClass cls;
        this.groups = new MultiMap(new HashMap(groups2.size()));
        JavaPsiFacade facade = context2.environment().getPsiFacade();
        Project project = context2.environment().getPsiManager().getProject();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope(project);
        this.global = new ArrayList<Group>();
        this.byPackage = new MultiMap();
        this.byClass = new MultiMap();
        this.methodScopes = new MultiMap(new IdentityHashMap());
        this.baseElements = new ArrayList<PsiElement>();
        groups2.forEach((key, defs) -> {
            for (GroupDefinition def : defs) {
                Group gr = Group.create(def, facade, projectScope);
                if (key.isGlobal()) {
                    this.global.add(gr);
                    continue;
                }
                this.groups.putValue(key.name(), gr);
                block12: for (GroupScope scope : def.scopes()) {
                    PsiClass cls;
                    String desc;
                    String patt8$temp;
                    String patt7$temp;
                    GroupScope selector3$temp;
                    Objects.requireNonNull(scope);
                    int index$4 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupScope.Package.class, GroupScope.Class.class, GroupScope.Method.class}, (Object)selector3$temp, index$4)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            String patt5$temp;
                            GroupScope.Package $b$0 = (GroupScope.Package)selector3$temp;
                            String packageName = patt5$temp = $b$0.packageName();
                            this.byPackage.putValue(packageName, gr);
                            continue block12;
                        }
                        case 1: {
                            String patt6$temp;
                            GroupScope.Class $b$1 = (GroupScope.Class)selector3$temp;
                            String cls2 = patt6$temp = $b$1.className();
                            this.byClass.putValue(cls2, gr);
                            continue block12;
                        }
                        case 2: 
                    }
                    GroupScope.Method $b$2 = (GroupScope.Method)selector3$temp;
                    String className = patt7$temp = $b$2.className();
                    String method = patt8$temp = $b$2.methodName();
                    try {
                        String patt9$temp;
                        desc = patt9$temp = $b$2.methodDesc();
                        cls = facade.findClass(className, projectScope);
                        if (cls == null) {
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    for (PsiMethod clsMethod : cls.getMethods()) {
                        if (!clsMethod.getName().equals(method) || !PsiHelper.getBinaryMethodSignature(clsMethod).equals(desc)) continue;
                        this.methodScopes.putValue(clsMethod, gr);
                    }
                }
            }
        });
        for (TargetField field : fields) {
            PsiField fld;
            cls = facade.findClass(field.className(), projectScope);
            if (cls == null || (fld = cls.findFieldByName(field.fieldName(), true)) == null) continue;
            fld.putUserData(UNPICK_FIELD_TARGET, field);
            this.baseElements.add(fld);
        }
        for (TargetMethod method : methods) {
            cls = facade.findClass(method.className(), projectScope);
            if (cls == null) continue;
            this.possibleTargetNames.add(method.methodName());
            for (PsiMethod clsMethod : cls.getMethods()) {
                if (!clsMethod.getName().equals(method.methodName()) || !PsiHelper.getBinaryMethodSignature(clsMethod).equals(method.methodDesc())) continue;
                clsMethod.putUserData(UNPICK_DEFINITION, Optional.of(method));
                this.baseElements.add(clsMethod);
            }
        }
    }

    public Collection<Group> getClassContext(PsiClass cls) {
        String clsName = cls.getQualifiedName();
        if (clsName != null) {
            return this.byClass.get(clsName);
        }
        return List.of();
    }

    public Collection<Group> getPackageContext(PsiJavaFile file2) {
        return this.byPackage.get(file2.getPackageName());
    }

    public Collection<Group> getMethodContext(PsiMethod method) {
        return this.methodScopes.get(method);
    }

    public Collection<Group> getGlobalContext() {
        return this.global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TargetMethod getDefinitionsFor(PsiMethod method) {
        if (!this.possibleTargetNames.contains(method.getName())) {
            return null;
        }
        Optional<TargetMethod> data = method.getUserData(UNPICK_DEFINITION);
        if (data == null) {
            UnpickCollection unpickCollection = this;
            synchronized (unpickCollection) {
                PsiClass[] psiClassArray = method.getParent();
                if (psiClassArray instanceof PsiClass) {
                    TargetMethod parent;
                    PsiMethod met;
                    PsiClass cls = (PsiClass)psiClassArray;
                    for (PsiClass iface : cls.getInterfaces()) {
                        TargetMethod parent2;
                        PsiMethod met2 = iface.findMethodBySignature(method, true);
                        if (met2 == null || (parent2 = this.getDefinitionsFor(met2)) == null) continue;
                        data = Optional.of(parent2);
                        break;
                    }
                    if (data == null && cls.getSuperClass() != null && (met = cls.getSuperClass().findMethodBySignature(method, true)) != null && (parent = this.getDefinitionsFor(met)) != null) {
                        data = Optional.of(parent);
                    }
                }
                if (data == null) {
                    data = Optional.empty();
                }
                method.putUserData(UNPICK_DEFINITION, data);
            }
        }
        return data.orElse(null);
    }

    public Collection<Group> getGroups(String id) {
        return this.groups.get(id);
    }

    public record Group(DataType data, boolean strict, boolean flag, @Nullable GroupFormat format, Map<Object, Expression> constants) {
        public static Group create(GroupDefinition def, JavaPsiFacade facade, GlobalSearchScope scope) {
            HashMap<Object, Expression> constants = HashMap.newHashMap(def.constants().size());
            for (Expression constant : def.constants()) {
                Object value = Group.resolveConstant(constant, facade, scope);
                constants.put(Group.cast(value, def.dataType()), constant);
            }
            return new Group(def.dataType(), def.strict(), def.flags(), def.format(), constants);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Object resolveConstant(Expression expression, JavaPsiFacade facade, GlobalSearchScope scope) {
            if (expression instanceof FieldExpression) {
                FieldExpression fieldEx = (FieldExpression)expression;
                PsiClass clazz = facade.findClass(fieldEx.className, scope);
                if (clazz == null) throw new IllegalArgumentException("Cannot find field named " + fieldEx.className + " of type " + String.valueOf((Object)fieldEx.fieldType) + " in class " + fieldEx.className);
                PsiField[] psiFieldArray = clazz.getAllFields();
                int n = psiFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PsiField field = psiFieldArray[n2];
                    if (fieldEx.isStatic == field.hasModifier(JvmModifier.STATIC) && (fieldEx.fieldType == null || Group.sameType(fieldEx.fieldType, field.getType())) && fieldEx.fieldName.equals(field.getName())) {
                        return field.computeConstantValue();
                    }
                    ++n2;
                }
                throw new IllegalArgumentException("Cannot find field named " + fieldEx.className + " of type " + String.valueOf((Object)fieldEx.fieldType) + " in class " + fieldEx.className);
            }
            if (expression instanceof LiteralExpression) {
                Object object;
                LiteralExpression literalExpression = (LiteralExpression)expression;
                Literal literal = literalExpression.literal;
                Objects.requireNonNull(literal);
                Literal clazz = literal;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.Character.class, Literal.Integer.class, Literal.Long.class, Literal.Float.class, Literal.Double.class, Literal.String.class}, (Object)clazz, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        char ch;
                        Literal.Character character = (Literal.Character)clazz;
                        try {
                            char field;
                            ch = field = character.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        object = Character.valueOf(ch);
                        return object;
                    }
                    case 1: {
                        Literal.Integer i = (Literal.Integer)clazz;
                        object = i.value();
                        return object;
                    }
                    case 2: {
                        Literal.Long l = (Literal.Long)clazz;
                        object = l.value();
                        return object;
                    }
                    case 3: {
                        float f2;
                        Literal.Float float_ = (Literal.Float)clazz;
                        {
                            float f;
                            f2 = f = float_.value();
                        }
                        object = Float.valueOf(f2);
                        return object;
                    }
                    case 4: {
                        double d2;
                        Literal.Double double_ = (Literal.Double)clazz;
                        {
                            double d;
                            d2 = d = double_.value();
                        }
                        object = d2;
                        return object;
                    }
                    case 5: 
                }
                Literal.String string3 = (Literal.String)clazz;
                {
                    String string2;
                    String s2 = string2 = string3.value();
                    object = s2;
                }
                return object;
            }
            if (expression instanceof ParenExpression) {
                ParenExpression parenExpression = (ParenExpression)expression;
                return Group.resolveConstant(parenExpression.expression, facade, scope);
            }
            if (expression instanceof CastExpression) {
                CastExpression castExpression = (CastExpression)expression;
                return Group.cast(Group.resolveConstant(castExpression.operand, facade, scope), castExpression.castType);
            }
            if (expression instanceof UnaryExpression) {
                Number number;
                UnaryExpression unaryExpression = (UnaryExpression)expression;
                Number value = (Number)Group.resolveConstant(unaryExpression.operand, facade, scope);
                switch (unaryExpression.operator) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NEGATE: {
                        number = NumberType.TYPES.get(value.getClass()).negate(value);
                        return number;
                    }
                    case BIT_NOT: 
                }
                number = value instanceof Long ? value.longValue() ^ 0xFFFFFFFFFFFFFFFFL : (long)(~value.intValue());
                return number;
            }
            if (!(expression instanceof BinaryExpression)) throw new IllegalArgumentException("Unknown Expression of type " + String.valueOf(expression.getClass()) + ": " + String.valueOf(expression));
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Object lhs = Group.resolveConstant(binaryExpression.lhs, facade, scope);
            Object rhs = Group.resolveConstant(binaryExpression.rhs, facade, scope);
            if (lhs instanceof Number) {
                Number l = (Number)lhs;
                if (rhs instanceof Number) {
                    Number number;
                    Number r = (Number)rhs;
                    NumberType type = NumberType.TYPES.get(l.getClass());
                    switch (binaryExpression.operator) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case ADD: {
                            number = type.add(l, r);
                            return number;
                        }
                        case DIVIDE: {
                            number = type.divide(l, r);
                            return number;
                        }
                        case MODULO: {
                            number = type.modulo(l, r);
                            return number;
                        }
                        case MULTIPLY: {
                            number = type.multiply(l, r);
                            return number;
                        }
                        case SUBTRACT: {
                            number = type.subtract(l, r);
                            return number;
                        }
                        case BIT_AND: {
                            number = type.and(l, r);
                            return number;
                        }
                        case BIT_OR: {
                            number = type.or(l, r);
                            return number;
                        }
                        case BIT_XOR: {
                            number = type.xor(l, r);
                            return number;
                        }
                        case BIT_SHIFT_LEFT: {
                            number = type.lshift(l, r);
                            return number;
                        }
                        case BIT_SHIFT_RIGHT: {
                            number = type.rshift(l, r);
                            return number;
                        }
                        case BIT_SHIFT_RIGHT_UNSIGNED: 
                    }
                    number = type.rshiftUnsigned(l, r);
                    return number;
                }
            }
            if (!(lhs instanceof String)) throw new IllegalArgumentException("Cannot resolve expression: " + String.valueOf(binaryExpression) + ". Operands of type " + String.valueOf(lhs.getClass()) + " and " + String.valueOf(rhs.getClass()) + " do not support operator " + String.valueOf((Object)binaryExpression.operator));
            String lS = (String)lhs;
            if (!(rhs instanceof String)) throw new IllegalArgumentException("Cannot resolve expression: " + String.valueOf(binaryExpression) + ". Operands of type " + String.valueOf(lhs.getClass()) + " and " + String.valueOf(rhs.getClass()) + " do not support operator " + String.valueOf((Object)binaryExpression.operator));
            String rS = (String)rhs;
            if (binaryExpression.operator != BinaryExpression.Operator.ADD) throw new IllegalArgumentException("Cannot resolve expression: " + String.valueOf(binaryExpression) + ". Operands of type " + String.valueOf(lhs.getClass()) + " and " + String.valueOf(rhs.getClass()) + " do not support operator " + String.valueOf((Object)binaryExpression.operator));
            return lS + rS;
        }

        private static Object cast(Object in, DataType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case DataType.BYTE -> ((Number)in).byteValue();
                case DataType.CHAR -> Character.valueOf((char)((Number)in).byteValue());
                case DataType.SHORT -> ((Number)in).shortValue();
                case DataType.INT -> ((Number)in).intValue();
                case DataType.LONG -> ((Number)in).longValue();
                case DataType.FLOAT -> Float.valueOf(((Number)in).floatValue());
                case DataType.DOUBLE -> ((Number)in).doubleValue();
                case DataType.CLASS -> (Class)in;
                case DataType.STRING -> in.toString();
            };
        }

        private static boolean sameType(DataType type, PsiType fieldType) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case DataType.BYTE -> fieldType.equals(PsiTypes.byteType());
                case DataType.CHAR -> fieldType.equals(PsiTypes.charType());
                case DataType.SHORT -> fieldType.equals(PsiTypes.shortType());
                case DataType.INT -> fieldType.equals(PsiTypes.intType());
                case DataType.LONG -> fieldType.equals(PsiTypes.longType());
                case DataType.FLOAT -> fieldType.equals(PsiTypes.floatType());
                case DataType.DOUBLE -> fieldType.equals(PsiTypes.doubleType());
                case DataType.CLASS -> ((PsiClassType)fieldType).resolve().getQualifiedName().equals("java.lang.Class");
                case DataType.STRING -> ((PsiClassType)fieldType).resolve().getQualifiedName().equals("java.lang.String");
            };
        }
    }

    public record TypedKey(DataType type, List<GroupScope> scopes, @Nullable String name) {
        public boolean isGlobal() {
            return this.name == null && this.scopes.isEmpty();
        }
    }
}

