/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.parchment.namesanddocs;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import net.neoforged.jst.parchment.namesanddocs.NameAndDocsFormat;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsDatabase;
import net.neoforged.jst.parchment.namesanddocs.parchment.ParchmentDatabase;
import net.neoforged.jst.parchment.namesanddocs.srgutils.MappingFileDatabase;
import org.jetbrains.annotations.Nullable;

public final class NameAndDocSourceLoader {
    private NameAndDocSourceLoader() {
    }

    public static NamesAndDocsDatabase load(Path path) throws IOException {
        return NameAndDocSourceLoader.load(path, null);
    }

    public static NamesAndDocsDatabase load(Path path, @Nullable NameAndDocsFormat format) throws IOException {
        format = Objects.requireNonNullElseGet(format, () -> NameAndDocSourceLoader.guessFormat(path));
        return switch (format) {
            default -> throw new MatchException(null, null);
            case NameAndDocsFormat.PARCHMENT_ZIP -> ParchmentDatabase.loadZip(path);
            case NameAndDocsFormat.PARCHMENT_JSON -> ParchmentDatabase.loadJson(path);
            case NameAndDocsFormat.TSRG2 -> MappingFileDatabase.load(path);
        };
    }

    private static NameAndDocsFormat guessFormat(Path path) {
        String filename = path.getFileName().toString().toLowerCase(Locale.ROOT);
        if (filename.endsWith(".zip")) {
            return NameAndDocsFormat.PARCHMENT_ZIP;
        }
        if (filename.endsWith(".json")) {
            return NameAndDocsFormat.PARCHMENT_JSON;
        }
        if (filename.endsWith(".tsrg")) {
            return NameAndDocsFormat.TSRG2;
        }
        throw new IllegalArgumentException("Don't know how to load " + String.valueOf(path));
    }
}

