/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.jst.api.FileSink;
import net.neoforged.jst.api.FileSource;
import net.neoforged.jst.cli.PathType;
import net.neoforged.jst.cli.io.ArchiveFileSink;
import net.neoforged.jst.cli.io.ArchiveFileSource;
import net.neoforged.jst.cli.io.FolderFileSink;
import net.neoforged.jst.cli.io.FolderFileSource;
import net.neoforged.jst.cli.io.SingleFileSink;
import net.neoforged.jst.cli.io.SingleFileSource;

public final class FileSinks {
    private FileSinks() {
    }

    public static FileSink create(Path path, PathType format, FileSource source) throws IOException {
        if (format == PathType.AUTO) {
            if (source instanceof SingleFileSource) {
                format = PathType.FILE;
            } else if (source instanceof ArchiveFileSource) {
                format = Files.isDirectory(path, new LinkOption[0]) ? PathType.FOLDER : PathType.ARCHIVE;
            } else if (source instanceof FolderFileSource) {
                format = PathType.FOLDER;
            } else {
                throw new IllegalArgumentException("Cannot auto-detect output format based on source: " + String.valueOf(source.getClass()));
            }
        }
        return switch (format) {
            default -> throw new MatchException(null, null);
            case PathType.AUTO -> throw new IllegalArgumentException("Do not support AUTO for output when input also was AUTO!");
            case PathType.FILE -> new SingleFileSink(path);
            case PathType.ARCHIVE -> new ArchiveFileSink(path);
            case PathType.FOLDER -> new FolderFileSink(path);
        };
    }
}

