/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.State;
import java.io.Serializable;

public class Transition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 40001L;
    char min;
    char max;
    State to;

    public Transition(char c, State to) {
        this.min = this.max = c;
        this.to = to;
    }

    public Transition(char min2, char max, State to) {
        if (max < min2) {
            char t2 = max;
            max = min2;
            min2 = t2;
        }
        this.min = min2;
        this.max = max;
        this.to = to;
    }

    public char getMin() {
        return this.min;
    }

    public char getMax() {
        return this.max;
    }

    public State getDest() {
        return this.to;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition t2 = (Transition)obj;
            return t2.min == this.min && t2.max == this.max && t2.to == this.to;
        }
        return false;
    }

    public int hashCode() {
        return this.min * 2 + this.max * 3;
    }

    public Transition clone() {
        try {
            return (Transition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static void appendCharString(char c, StringBuilder b) {
        if (c >= '!' && c <= '~' && c != '\\' && c != '\"') {
            b.append(c);
        } else {
            b.append("\\u");
            String s2 = Integer.toHexString(c);
            if (c < '\u0010') {
                b.append("000").append(s2);
            } else if (c < '\u0100') {
                b.append("00").append(s2);
            } else if (c < '\u1000') {
                b.append("0").append(s2);
            } else {
                b.append(s2);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Transition.appendCharString(this.min, b);
        if (this.min != this.max) {
            b.append("-");
            Transition.appendCharString(this.max, b);
        }
        b.append(" -> ").append(this.to.number);
        return b.toString();
    }

    void appendDot(StringBuilder b) {
        b.append(" -> ").append(this.to.number).append(" [label=\"");
        Transition.appendCharString(this.min, b);
        if (this.min != this.max) {
            b.append("-");
            Transition.appendCharString(this.max, b);
        }
        b.append("\"]\n");
    }
}

