/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.util;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;

public enum AccessFlag {
    PUBLIC(1),
    PRIVATE(2),
    PROTECTED(4),
    STATIC(8),
    FINAL(16),
    SUPER(32),
    SYNCHRONIZED(32),
    OPEN(32),
    TRANSITIVE(32),
    VOLATILE(64),
    BRIDGE(64),
    STATIC_PHASE(64),
    VARARGS(128),
    TRANSIENT(128),
    NATIVE(256),
    INTERFACE(512),
    ABSTRACT(1024),
    STRICT(2048),
    SYNTHETIC(4096),
    ANNOTATION(8192),
    ENUM(16384),
    MANDATED(32768),
    MODULE(32768);

    private final int bitMask;

    private AccessFlag(int bitMask) {
        this.bitMask = bitMask;
    }

    public boolean isActive(int bitField) {
        return (bitField & this.bitMask) == this.bitMask;
    }

    public static EnumSet<AccessFlag> getAccessFlags(int bitField) {
        return Arrays.stream(AccessFlag.values()).filter(a -> a.isActive(bitField)).collect(Collectors.toCollection(() -> EnumSet.noneOf(AccessFlag.class)));
    }

    public static int toSecuritySpecification(EnumSet<AccessFlag> accessFlags) {
        int bitField = 0;
        for (AccessFlag accessFlag : accessFlags) {
            bitField |= accessFlag.bitMask;
        }
        return bitField;
    }
}

