/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.ClassMetadata;
import org.parchmentmc.feather.metadata.SourceMetadata;
import org.parchmentmc.feather.util.SimpleVersion;

final class ImmutableSourceMetadata
implements SourceMetadata {
    private final SimpleVersion specVersion;
    private final String minecraftVersion;
    private final LinkedHashSet<ClassMetadata> classes;

    public ImmutableSourceMetadata(SimpleVersion specVersion, String minecraftVersion, LinkedHashSet<ClassMetadata> classes) {
        this.specVersion = specVersion;
        this.minecraftVersion = minecraftVersion;
        this.classes = new LinkedHashSet<ClassMetadata>(classes);
    }

    ImmutableSourceMetadata() {
        this(SimpleVersion.of("1.0.0"), "1.0.0", new LinkedHashSet<ClassMetadata>());
    }

    @Override
    public SimpleVersion getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public LinkedHashSet<ClassMetadata> getClasses() {
        return this.classes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceMetadata)) {
            return false;
        }
        SourceMetadata that = (SourceMetadata)o;
        return this.getSpecificationVersion().equals(that.getSpecificationVersion()) && this.getMinecraftVersion().equals(that.getMinecraftVersion()) && this.getClasses().equals(that.getClasses());
    }

    public int hashCode() {
        return Objects.hash(this.getSpecificationVersion(), this.getMinecraftVersion(), this.getClasses());
    }

    public String toString() {
        return "ImmutableSourceMetadata{specVersion=" + this.specVersion + ", minecraftVersion='" + this.minecraftVersion + '\'' + ", classes=" + this.classes + '}';
    }

    @Override
    public @NonNull SourceMetadata toImmutable() {
        return this;
    }
}

