/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class LocalNameFunction
implements Function {
    public Object call(Context context2, List args2) throws FunctionCallException {
        if (args2.size() == 0) {
            return LocalNameFunction.evaluate(context2.getNodeSet(), context2.getNavigator());
        }
        if (args2.size() == 1) {
            return LocalNameFunction.evaluate(args2, context2.getNavigator());
        }
        throw new FunctionCallException("local-name() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator nav) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object first2 = list.get(0);
            if (first2 instanceof List) {
                return LocalNameFunction.evaluate((List)first2, nav);
            }
            if (nav.isElement(first2)) {
                return nav.getElementName(first2);
            }
            if (nav.isAttribute(first2)) {
                return nav.getAttributeName(first2);
            }
            if (nav.isProcessingInstruction(first2)) {
                return nav.getProcessingInstructionTarget(first2);
            }
            if (nav.isNamespace(first2)) {
                return nav.getNamespacePrefix(first2);
            }
            if (nav.isDocument(first2)) {
                return "";
            }
            if (nav.isComment(first2)) {
                return "";
            }
            if (nav.isText(first2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the local-name function must be a node-set");
        }
        return "";
    }
}

