/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBinaryFileImpl
extends PsiElementBase
implements PsiBinaryFile,
PsiFileEx,
Cloneable,
Queryable {
    private final PsiManagerImpl myManager;
    private String myName;
    private byte[] myContents;
    private final AbstractFileViewProvider myViewProvider;
    private volatile boolean myPossiblyInvalidated;

    public PsiBinaryFileImpl(@NotNull PsiManagerImpl manager, @NotNull FileViewProvider viewProvider) {
        if (manager == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(0);
        }
        if (viewProvider == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(1);
        }
        this.myViewProvider = (AbstractFileViewProvider)viewProvider;
        this.myManager = manager;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myViewProvider.getVirtualFile();
        if (virtualFile == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(3);
        }
        return true;
    }

    byte[] getStoredContents() {
        return this.myContents;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = !this.isCopy() ? this.getVirtualFile().getName() : this.myName;
        if (string2 == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(5);
        }
        this.checkSetName(name);
        if (this.isCopy()) {
            this.myName = name;
            return this;
        }
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (this.isCopy()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public PsiDirectory getContainingDirectory() {
        VirtualFile parentFile = this.getVirtualFile().getParent();
        if (parentFile == null) {
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Nullable
    public PsiDirectory getParentDirectory() {
        return this.getContainingDirectory();
    }

    @Override
    public long getModificationStamp() {
        return this.getVirtualFile().getModificationStamp();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(6);
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(7);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return this;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public char @NotNull [] textToCharArray() {
        if (ArrayUtilRt.EMPTY_CHAR_ARRAY == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(8);
        }
        return ArrayUtilRt.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(9);
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(11);
        }
        visitor.visitBinaryFile(this);
    }

    @Override
    public PsiElement copy() {
        PsiBinaryFileImpl clone = (PsiBinaryFileImpl)this.clone();
        clone.myName = this.getName();
        try {
            clone.myContents = !this.isCopy() ? this.getVirtualFile().contentsToByteArray() : this.myContents;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clone;
    }

    private boolean isCopy() {
        return this.myName != null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(12);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(13);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(14);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(15);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (this.isCopy()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.isCopy()) {
            return true;
        }
        if (!this.getVirtualFile().isValid() || this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myPossiblyInvalidated) {
            return true;
        }
        if (((FileManagerImpl)this.myManager.getFileManager()).evaluateValidity(this)) {
            this.myPossiblyInvalidated = false;
            PsiInvalidElementAccessException.setInvalidationTrace(this, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isWritable() {
        return this.isCopy() || this.getVirtualFile().isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !this.isCopy();
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiBinaryFileImpl psiBinaryFileImpl = this;
        if (psiBinaryFileImpl == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(17);
        }
        return psiBinaryFileImpl;
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiBinaryFile:" + this.getName();
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myViewProvider.getFileType();
        if (fileType == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(18);
        }
        return fileType;
    }

    @Override
    public PsiFile @NotNull [] getPsiRoots() {
        PsiFile[] psiFileArray = new PsiFile[]{this};
        if (psiFileArray == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(19);
        }
        return psiFileArray;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        AbstractFileViewProvider abstractFileViewProvider = this.myViewProvider;
        if (abstractFileViewProvider == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(20);
        }
        return abstractFileViewProvider;
    }

    @Override
    public FileASTNode getNode() {
        return null;
    }

    @Override
    public void subtreeChanged() {
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiBinaryFileImpl.$$$reportNull$$$0(21);
        }
        info.put("fileName", this.getName());
        info.put("fileType", this.getFileType().getName());
    }

    @Override
    public boolean isContentsLoaded() {
        return false;
    }

    @Override
    public void onContentReload() {
    }

    @Override
    public void markInvalidated() {
        this.myPossiblyInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiBinaryFileImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiBinaryFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiRoots";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkAdd";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

