/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleRootFileViewProvider
extends AbstractFileViewProvider
implements FileViewProvider {
    private static final Key<Boolean> OUR_NO_SIZE_LIMIT_KEY = Key.create("no.size.limit");
    private static final Logger LOG = Logger.getInstance(SingleRootFileViewProvider.class);
    private volatile PsiFile myPsiFile;
    private static final AtomicReferenceFieldUpdater<SingleRootFileViewProvider, PsiFile> myPsiFileUpdater = AtomicReferenceFieldUpdater.newUpdater(SingleRootFileViewProvider.class, PsiFile.class, "myPsiFile");
    @NotNull
    private final Language myBaseLanguage;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(1);
        }
        this(manager, file2, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(3);
        }
        this(manager, virtualFile, eventSystemEnabled, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject(), virtualFile.getFileType()));
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType fileType) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(6);
        }
        this(manager, virtualFile, eventSystemEnabled, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject(), fileType));
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(8);
        }
        if (language == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(9);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myBaseLanguage = language;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(manager.getProject());
        if (documentManager instanceof PsiDocumentManagerBase) {
            ((PsiDocumentManagerBase)documentManager).assertFileIsFromCorrectProject(virtualFile);
        }
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(10);
        }
        return language;
    }

    private static Language calcBaseLanguage(@NotNull VirtualFile file2, @NotNull Project project, @NotNull FileType fileType) {
        if (file2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(13);
        }
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return PlainTextLanguage.INSTANCE;
        }
        Language language = LanguageUtil.getLanguageForPsi(project, file2, fileType);
        return language != null ? language : PlainTextLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list = ContainerUtil.createMaybeSingletonList(this.getPsi(this.getBaseLanguage()));
        if (list == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @Nullable
    protected PsiFile getPsiInner(@NotNull Language target) {
        if (target == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(16);
        }
        if (target != this.getBaseLanguage()) {
            return null;
        }
        PsiFile file2 = this.myPsiFile;
        if (file2 == null) {
            boolean set;
            file2 = this.createFile();
            if (file2 == null) {
                file2 = PsiUtilCore.NULL_PSI_FILE;
            }
            if (!(set = myPsiFileUpdater.compareAndSet(this, null, file2)) && file2 != PsiUtilCore.NULL_PSI_FILE) {
                PsiFile alreadyCreated = this.myPsiFile;
                if (alreadyCreated == file2) {
                    LOG.error(this + ".createFile() must create new file instance but got the same: " + file2);
                }
                if (file2 instanceof PsiFileEx) {
                    PsiFile finalPsiFile = file2;
                    DebugUtil.performPsiModification("invalidating throw-away copy", () -> ((PsiFileEx)finalPsiFile).markInvalidated());
                }
                file2 = alreadyCreated;
            }
        }
        return ObjectUtils.nullizeIfDefaultValue(file2, PsiUtilCore.NULL_PSI_FILE);
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target) {
        if (target == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(17);
        }
        if (target != this.getBaseLanguage()) {
            return null;
        }
        return ObjectUtils.nullizeIfDefaultValue(this.myPsiFile, PsiUtilCore.NULL_PSI_FILE);
    }

    @Override
    @NotNull
    public final List<PsiFile> getCachedPsiFiles() {
        List<PsiFile> list = ContainerUtil.createMaybeSingletonList(this.getCachedPsi(this.getBaseLanguage()));
        if (list == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<FileASTNode> getKnownTreeRoots() {
        PsiFile psiFile = this.getCachedPsi(this.getBaseLanguage());
        if (!(psiFile instanceof PsiFileImpl)) {
            List<FileASTNode> list = Collections.emptyList();
            if (list == null) {
                SingleRootFileViewProvider.$$$reportNull$$$0(19);
            }
            return list;
        }
        FileASTNode element = ((PsiFileImpl)psiFile).getNodeIfLoaded();
        List<FileASTNode> list = ContainerUtil.createMaybeSingletonList(element);
        if (list == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(20);
        }
        return list;
    }

    private PsiFile createFile() {
        try {
            return this.shouldCreatePsi() ? this.createFile(this.getManager().getProject(), this.getVirtualFile(), this.getFileType()) : null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(21);
        }
        return SingleRootFileViewProvider.isTooLargeForIntelligence(vFile, null);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize) {
        if (file2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(22);
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(file2)) {
            return false;
        }
        if (file2 instanceof LightVirtualFile && ((LightVirtualFile)file2).isTooLargeForIntelligence() == ThreeState.YES) {
            return false;
        }
        int maxSize = PersistentFSConstants.getMaxIntellisenseFileSize();
        return contentSize == null ? SingleRootFileViewProvider.fileSizeIsGreaterThan(file2, maxSize) : contentSize > (long)maxSize;
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(23);
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD);
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(24);
        }
        long maxLength = PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
        return contentSize == null ? SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, maxLength) : contentSize > maxLength;
    }

    private static boolean checkFileSizeLimit(@NotNull VirtualFile vFile) {
        VirtualFile original;
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(25);
        }
        if (Boolean.TRUE.equals(vFile.getCopyableUserData(OUR_NO_SIZE_LIMIT_KEY))) {
            return false;
        }
        if (vFile instanceof LightVirtualFile && (original = ((LightVirtualFile)vFile).getOriginalFile()) != null) {
            return SingleRootFileViewProvider.checkFileSizeLimit(original);
        }
        return true;
    }

    public static void doNotCheckFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(26);
        }
        vFile.putCopyableUserData(OUR_NO_SIZE_LIMIT_KEY, Boolean.TRUE);
    }

    public static boolean fileSizeIsGreaterThan(@NotNull VirtualFile vFile, long maxBytes) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(27);
        }
        if (vFile instanceof LightVirtualFile && !vFile.getFileType().isBinary()) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxBytes;
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(28);
        }
        return new SingleRootFileViewProvider((PsiManager)this.getManager(), copy, false, this.getBaseLanguage());
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset);
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return SingleRootFileViewProvider.findElementAt(this.getPsi(this.getBaseLanguage()), offset);
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(29);
        }
        if (!ReflectionUtil.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    public final void forceCachedPsi(@NotNull PsiFile psiFile) {
        PsiFile prev;
        if (psiFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(30);
        }
        while (!myPsiFileUpdater.compareAndSet(this, prev = this.myPsiFile, psiFile)) {
        }
        if (prev != psiFile && prev instanceof PsiFileEx) {
            DebugUtil.performPsiModification(this.getClass().getName() + " PSI change", () -> ((PsiFileEx)prev).markInvalidated());
        }
        this.getManager().getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/SingleRootFileViewProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/SingleRootFileViewProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPsiFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTreeRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcBaseLanguage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInner";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTooLargeForIntelligence";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTooLargeForContentLoading";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkFileSizeLimit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doNotCheckFileSizeLimit";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fileSizeIsGreaterThan";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "forceCachedPsi";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

