/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.AbstractBundle;
import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.java.parser.BasicDeclarationParser;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFileParser {
    protected final TokenSet IMPORT_LIST_STOPPER_SET;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final TokenSet UNNAMED_CLASS_INDICATORS;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicFileParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicFileParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.IMPORT_LIST_STOPPER_SET = TokenSet.orSet(BasicElementTypes.BASIC_MODIFIER_BIT_SET, TokenSet.create(JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT));
        this.UNNAMED_CLASS_INDICATORS = TokenSet.create(this.myJavaElementTypeContainer.METHOD, this.myJavaElementTypeContainer.FIELD, this.myJavaElementTypeContainer.CLASS_INITIALIZER);
    }

    public void parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            BasicFileParser.$$$reportNull$$$0(1);
        }
        this.parseFile(builder, this::stopImportListParsing, JavaPsiBundle.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder, @NotNull Predicate<? super PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder == null) {
            BasicFileParser.$$$reportNull$$$0(2);
        }
        if (importListStopper == null) {
            BasicFileParser.$$$reportNull$$$0(3);
        }
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(4);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(5);
        }
        this.parsePackageStatement(builder);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        SyntaxTreeBuilder.Marker invalidElements = null;
        boolean isUnnamedClass = false;
        while (!builder.eof()) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.myParser.getModuleParser().parse(builder);
            if (declaration == null) {
                declaration = this.parseInitial(builder);
            }
            if (declaration != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(BasicFileParser.error(bundle, errorMessageKey), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk == null) {
                    firstDeclarationOk = BasicJavaParserUtil.exprType(declaration) != this.myJavaElementTypeContainer.MODIFIER_LIST;
                }
                if (firstDeclaration == null) {
                    firstDeclaration = declaration;
                }
                if (isUnnamedClass || !this.UNNAMED_CLASS_INDICATORS.contains(BasicJavaParserUtil.exprType(declaration))) continue;
                isUnnamedClass = true;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(BasicFileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getPrecedingCommentBinder(), null);
            firstDeclaration.setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getSpecialPrecedingCommentBinder(), null);
        }
        if (isUnnamedClass) {
            PsiBuilder.Marker beforeFirst = firstDeclaration.precede();
            BasicJavaParserUtil.done(beforeFirst, this.myJavaElementTypeContainer.UNNAMED_CLASS, this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private boolean stopImportListParsing(PsiBuilder b) {
        String text2;
        IElementType type = b.getTokenType();
        if (this.IMPORT_LIST_STOPPER_SET.contains(type) || BasicDeclarationParser.isRecordToken(b, type)) {
            return true;
        }
        return type == JavaTokenType.IDENTIFIER && ("open".equals(text2 = b.getTokenText()) || "module".equals(text2));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder) {
        return this.myParser.getDeclarationParser().parse(builder, BasicDeclarationParser.BaseContext.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.PACKAGE_KEYWORD)) {
                statement.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false)) == null) {
            statement.error(JavaPsiBundle.message("expected.class.or.interface", new Object[0]));
            return;
        }
        BasicJavaParserUtil.semicolon(builder);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.PACKAGE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
    }

    @NotNull
    protected Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder, Predicate<? super PsiBuilder> stopper) {
        PsiBuilder.Marker list = builder.mark();
        boolean isEmpty = true;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while (!builder.eof() && !stopper.test(builder)) {
            if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseImportStatement(builder);
            if (statement != null) {
                isEmpty = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), statement);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.rollbackTo();
        }
        if (isEmpty) {
            PsiBuilder.Marker precede = list.precede();
            list.rollbackTo();
            list = precede;
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.IMPORT_LIST, this.myWhiteSpaceAndCommentSetHolder);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(list, isEmpty);
        if (pair == null) {
            BasicFileParser.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nullable
    protected PsiBuilder.Marker parseImportStatement(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean isStatic = PsiBuilderUtil.expect(builder, JavaTokenType.STATIC_KEYWORD);
        IElementType type = isStatic ? this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT : this.myJavaElementTypeContainer.IMPORT_STATEMENT;
        boolean isOk = this.myParser.getReferenceParser().parseImportCodeReference(builder, isStatic);
        if (isOk) {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, type, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    @NlsContexts.ParsingError
    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(7);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(8);
        }
        String string2 = bundle.getMessage(errorMessageKey, new Object[0]);
        if (string2 == null) {
            BasicFileParser.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importListStopper";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

