/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.util;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SimpleVersion
implements Serializable,
Comparable<SimpleVersion> {
    private final int major;
    private final int minor;
    private final int patch;

    public static SimpleVersion of(String version) {
        String[] split = version.split("\\.");
        Preconditions.checkArgument(split.length >= 2, "Expected at least 2 tokens for version %s", (Object)version);
        Preconditions.checkArgument(split.length <= 3, "Expected at most 3 tokens for version %s" + version);
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        int patch = split.length == 3 ? Integer.parseInt(split[2]) : 0;
        return SimpleVersion.of(major, minor, patch);
    }

    public static SimpleVersion copyOf(SimpleVersion other) {
        return SimpleVersion.of(other.major, other.minor, other.patch);
    }

    public static SimpleVersion of(int major, int minor, int patch) {
        return new SimpleVersion(major, minor, patch);
    }

    SimpleVersion(int major, int minor, int patch) {
        Preconditions.checkArgument(major >= 0, "Major version %s must not be negative", major);
        Preconditions.checkArgument(minor >= 0, "Minor version %s must not be negative", minor);
        Preconditions.checkArgument(patch >= 0, "Patch version %s must not be negative", patch);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isCompatibleWith(SimpleVersion o) {
        return this.major == o.major;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(SimpleVersion o) {
        int ret = this.major - o.major;
        if (ret != 0) {
            return ret;
        }
        ret = this.minor - o.minor;
        if (ret != 0) {
            return ret;
        }
        return this.patch - o.patch;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleVersion that = (SimpleVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }
}

