/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.parchment;

import com.intellij.lang.jvm.JvmParameter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.parchment.JavadocHelper;
import net.neoforged.jst.parchment.PsiParchmentHelper;
import net.neoforged.jst.parchment.ReservedVariableNamesCollector;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsDatabase;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForClass;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForField;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForMethod;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GatherReplacementsVisitor
extends PsiRecursiveElementVisitor {
    private final NamesAndDocsDatabase namesAndDocs;
    private final boolean enableJavadoc;
    @Nullable
    private final UnaryOperator<String> conflictResolver;
    private final Replacements replacements;
    private final Map<PsiParameter, String> activeParameters = new IdentityHashMap<PsiParameter, String>();

    public GatherReplacementsVisitor(NamesAndDocsDatabase namesAndDocs, boolean enableJavadoc, @Nullable UnaryOperator<String> conflictResolver, Replacements replacements) {
        this.namesAndDocs = namesAndDocs;
        this.enableJavadoc = enableJavadoc;
        this.conflictResolver = conflictResolver;
        this.replacements = replacements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitElement(@NotNull PsiElement element) {
        block26: {
            PsiReferenceExpression refExpr;
            block27: {
                NamesAndDocsForField fieldData;
                block25: {
                    NamesAndDocsForClass classData;
                    if (!(element instanceof PsiClass)) break block25;
                    PsiClass psiClass = (PsiClass)element;
                    if (psiClass.getQualifiedName() != null) {
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(element.getProject());
                        PsiClass foundClass = psiFacade.findClass(psiClass.getQualifiedName(), GlobalSearchScope.everythingScope(element.getProject()));
                        if (foundClass == null) {
                            throw new IllegalStateException("Failed to find how class " + psiClass.getQualifiedName() + " was loaded while processing it");
                        }
                        if (foundClass != psiClass) {
                            throw new IllegalStateException("Class " + psiClass.getQualifiedName() + " was loaded from two different sources: " + psiClass.getContainingFile().getVirtualFile().getPath() + " and " + foundClass.getContainingFile().getVirtualFile().getPath());
                        }
                    }
                    if ((classData = PsiParchmentHelper.getClassData(this.namesAndDocs, psiClass)) == null) break block26;
                    this.applyJavadoc(psiClass, classData.getJavadoc(), this.replacements);
                    break block26;
                }
                if (!(element instanceof PsiField)) break block27;
                PsiField psiField = (PsiField)element;
                NamesAndDocsForClass classData = PsiParchmentHelper.getClassData(this.namesAndDocs, psiField.getContainingClass());
                NamesAndDocsForField namesAndDocsForField = fieldData = classData != null ? classData.getField(psiField.getName()) : null;
                if (fieldData == null) break block26;
                this.applyJavadoc(psiField, fieldData.getJavadoc(), this.replacements);
                break block26;
            }
            if (element instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)element;
                NamesAndDocsForMethod methodData = PsiParchmentHelper.getMethodData(this.namesAndDocs, psiMethod);
                if (methodData != null) {
                    UnaryOperator namer;
                    HashMap<String, String> parameterJavadoc = new HashMap<String, String>();
                    HashMap<String, String> renamedParameters = new HashMap<String, String>();
                    if (this.conflictResolver == null || psiMethod.getBody() == null) {
                        namer = UnaryOperator.identity();
                    } else {
                        HashSet<String> localRefs = new HashSet<String>();
                        for (JvmParameter parameter : psiMethod.getParameters()) {
                            localRefs.add(parameter.getName());
                        }
                        new ReservedVariableNamesCollector(localRefs).visitElement(psiMethod.getBody());
                        namer = p -> localRefs.contains(p) ? (String)this.conflictResolver.apply((String)p) : p;
                    }
                    ArrayList<String> parameterOrder = new ArrayList<String>();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    int[] parametersLvtIndices = PsiHelper.getParameterLvtIndices(psiMethod);
                    boolean hadReplacements = false;
                    int parameterOffset = 0;
                    if (psiMethod.isConstructor()) {
                        if (psiMethod.getContainingClass().isEnum()) {
                            parameterOffset = 2;
                        } else if (PsiHelper.isNonStaticInnerClass(psiMethod.getContainingClass())) {
                            parameterOffset = 1;
                        }
                    }
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiParameter psiParameter = parameters[i];
                        if (psiParameter.getNameIdentifier() == null) continue;
                        int jvmIndex = parametersLvtIndices[i];
                        NamesAndDocsForParameter paramData = methodData.getParameter(parameterOffset + i, jvmIndex);
                        if (paramData != null && paramData.getName() != null && !PsiHelper.isRecordConstructor(psiMethod)) {
                            String paramName = (String)namer.apply(paramData.getName());
                            this.activeParameters.put(psiParameter, paramName);
                            this.replacements.replace(psiParameter.getNameIdentifier(), paramName);
                            renamedParameters.put(psiParameter.getName(), paramName);
                            hadReplacements = true;
                            parameterOrder.add(paramName);
                        } else {
                            parameterOrder.add(psiParameter.getName());
                        }
                        if (paramData == null || paramData.getJavadoc() == null) continue;
                        parameterJavadoc.put(Objects.requireNonNullElse(paramData.getName(), psiParameter.getName()), paramData.getJavadoc());
                    }
                    if (this.enableJavadoc) {
                        JavadocHelper.enrichJavadoc(psiMethod, methodData.getJavadoc(), parameterJavadoc, renamedParameters, parameterOrder, this.replacements);
                    }
                    if (hadReplacements) {
                        try {
                            element.acceptChildren(this);
                        }
                        finally {
                            for (PsiParameter parameter : parameters) {
                                this.activeParameters.remove(parameter);
                            }
                        }
                        return;
                    }
                }
            } else if (element instanceof PsiReferenceExpression && (refExpr = (PsiReferenceExpression)element).getReferenceNameElement() != null) {
                for (Map.Entry<PsiParameter, String> entry : this.activeParameters.entrySet()) {
                    if (!refExpr.isReferenceTo(entry.getKey())) continue;
                    this.replacements.replace(refExpr.getReferenceNameElement(), entry.getValue());
                    break;
                }
            }
        }
        element.acceptChildren(this);
    }

    private void applyJavadoc(PsiJavaDocumentedElement psiElement, List<String> javadoc, Replacements replacements) {
        if (this.enableJavadoc && !javadoc.isEmpty()) {
            JavadocHelper.enrichJavadoc(psiElement, javadoc, replacements);
        }
    }
}

