/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.interfaceinjection;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.neoforged.jst.api.Logger;

class StubStore {
    private final Logger logger;
    private final JavaPsiFacade facade;
    private final Map<String, String> jvmToFqn = new HashMap<String, String>();
    private final Map<String, Map<String, StubInterface>> stubs = new HashMap<String, Map<String, StubInterface>>();

    StubStore(Logger logger, JavaPsiFacade facade) {
        this.logger = logger;
        this.facade = facade;
    }

    public InterfaceInformation createStub(String jvm) {
        String generics = "";
        int typeParameterCount = 0;
        int genericsStart = jvm.indexOf(60);
        if (genericsStart != -1) {
            int genericsEnd = jvm.lastIndexOf(62);
            if (genericsEnd == -1 || genericsEnd < genericsStart) {
                this.logger.error("Interface injection %s has incomplete generics declarations", jvm);
            } else {
                generics = jvm.substring(genericsStart + 1, genericsEnd);
                if (generics.isBlank()) {
                    this.logger.error("Interface injection %s has blank type parameters", jvm);
                } else {
                    typeParameterCount = generics.replaceAll("<[^>]*>", "").split(",").length;
                }
            }
            jvm = jvm.substring(0, genericsStart);
        }
        return new InterfaceInformation(this.createStub(jvm, typeParameterCount), generics);
    }

    private synchronized String createStub(String jvm, int typeParameterCount) {
        Object fqn = this.jvmToFqn.get(jvm);
        if (fqn != null) {
            return fqn;
        }
        ArrayList<String> splitName = new ArrayList<String>(Arrays.asList(jvm.split("/")));
        String name = splitName.remove(splitName.size() - 1);
        String packageName = String.join((CharSequence)".", splitName);
        CharSequence[] byInner = name.split("\\$");
        fqn = packageName;
        if (!((String)fqn).isBlank()) {
            fqn = (String)fqn + ".";
        }
        fqn = (String)fqn + String.join((CharSequence)".", byInner);
        this.jvmToFqn.put(jvm, (String)fqn);
        if (this.facade.findClass((String)fqn, GlobalSearchScope.everythingScope(this.facade.getProject())) != null) {
            return fqn;
        }
        StubInterface stub = this.stubs.computeIfAbsent(packageName, $ -> new HashMap()).computeIfAbsent(byInner[0], arg_0 -> StubStore.lambda$createStub$1((String[])byInner, arg_0));
        for (int i = 1; i < byInner.length; ++i) {
            stub = stub.getChildren((String)byInner[i]);
        }
        stub.typeParameterCount().set(typeParameterCount);
        return fqn;
    }

    public synchronized void save(Path path) throws IOException {
        if (path.getParent() != null && !Files.isDirectory(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
            for (Map.Entry<String, Map<String, StubInterface>> entry : this.stubs.entrySet()) {
                String pkg = entry.getKey();
                Map<String, StubInterface> stubs = entry.getValue();
                Object baseDeclaration = pkg.isBlank() ? "" : "package " + pkg + ";\n\n";
                String baseFileName = pkg.isBlank() ? "" : pkg.replace('.', '/') + "/";
                for (StubInterface stub : stubs.values()) {
                    StringBuilder builder = new StringBuilder((String)baseDeclaration);
                    stub.save((String s2) -> builder.append((String)s2).append('\n'));
                    zos.putNextEntry(new ZipEntry(baseFileName + stub.name() + ".java"));
                    zos.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                    zos.closeEntry();
                }
            }
        }
    }

    private static /* synthetic */ StubInterface lambda$createStub$1(String[] byInner, String $) {
        return new StubInterface(byInner[0]);
    }

    record InterfaceInformation(String interfaceDeclaration, String generics) {
        @Override
        public String toString() {
            return this.generics.isBlank() ? this.interfaceDeclaration : this.interfaceDeclaration + "<" + this.generics + ">";
        }
    }

    public record StubInterface(String name, AtomicInteger typeParameterCount, Map<String, StubInterface> children) {
        public StubInterface(String name) {
            this(name, new AtomicInteger(), new HashMap<String, StubInterface>());
        }

        public StubInterface getChildren(String name) {
            return this.children.computeIfAbsent(name, StubInterface::new);
        }

        public void save(Consumer<String> consumer) {
            Object generics = "";
            if (this.typeParameterCount.get() > 0) {
                generics = "<" + IntStream.range(0, this.typeParameterCount.get()).mapToObj(i -> Character.toString((char)(65 + i))).collect(Collectors.joining(", ")) + ">";
            }
            consumer.accept("public interface " + this.name + (String)generics + " {");
            for (StubInterface child : this.children.values()) {
                child.save(str -> consumer.accept("    " + str));
            }
            consumer.accept("}");
        }
    }
}

