/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.interfaceinjection;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.interfaceinjection.StubStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectInterfacesVisitor
extends PsiRecursiveElementVisitor {
    private final Replacements replacements;
    private final MultiMap<String, String> interfaces;
    private final StubStore stubs;
    @Nullable
    private final String marker;

    InjectInterfacesVisitor(Replacements replacements, MultiMap<String, String> interfaces, StubStore stubs, @Nullable String marker) {
        this.replacements = replacements;
        this.interfaces = interfaces;
        this.stubs = stubs;
        this.marker = marker;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.getQualifiedName() == null) {
                return;
            }
            String className = ClassUtil.getJVMClassName(psiClass);
            this.inject(psiClass, this.interfaces.get(className.replace('.', '/')));
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                this.visitElement(innerClass);
            }
        }
    }

    @Override
    public void visitFile(@NotNull PsiFile file2) {
        file2.acceptChildren(this);
    }

    private void inject(PsiClass psiClass, Collection<String> targets) {
        if (targets.isEmpty() || psiClass.getImplementsList() == null) {
            return;
        }
        PsiReferenceList implementsList = psiClass.isInterface() ? psiClass.getExtendsList() : psiClass.getImplementsList();
        Set implementedInterfaces = Arrays.stream(implementsList.getReferencedTypes()).map(PsiClassType::resolve).filter(Objects::nonNull).map(PsiClass::getQualifiedName).collect(Collectors.toSet());
        String interfaceImplementation = targets.stream().distinct().map(this.stubs::createStub).filter(iface -> !implementedInterfaces.contains(iface.interfaceDeclaration())).map(StubStore.InterfaceInformation::toString).map(this::decorate).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
        if (implementsList.getChildren().length == 0) {
            StringBuilder text2 = new StringBuilder();
            if (!(psiClass.getLBrace().getPrevSibling() instanceof PsiWhiteSpace)) {
                text2.append(' ');
            }
            text2.append(psiClass.isInterface() ? "extends" : "implements").append(' ');
            text2.append(interfaceImplementation);
            text2.append(' ');
            this.replacements.insertBefore(psiClass.getLBrace(), text2.toString());
        } else {
            this.replacements.insertAfter(implementsList.getLastChild(), ", " + interfaceImplementation);
        }
    }

    private String decorate(String iface) {
        if (this.marker == null) {
            return iface;
        }
        return "@" + this.marker + " " + iface;
    }
}

