/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.accesstransformers;

import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.accesstransformer.parser.AccessTransformerFiles;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import net.neoforged.jst.accesstransformers.ApplyATsVisitor;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import picocli.CommandLine;

public class AccessTransformersTransformer
implements SourceTransformer {
    @CommandLine.Option(names={"--access-transformer"}, required=true)
    public List<Path> atFiles;
    @CommandLine.Option(names={"--access-transformer-validation"}, description={"The level of validation to use for ats"})
    public AccessTransformerValidation validation = AccessTransformerValidation.LOG;
    private AccessTransformerFiles ats;
    private Map<Target, Transformation> pendingATs;
    private Logger logger;
    private volatile boolean errored;

    @Override
    public void beforeRun(TransformContext context2) {
        this.ats = new AccessTransformerFiles();
        this.logger = context2.logger();
        for (Path path : this.atFiles) {
            try {
                this.ats.loadFromPath(path);
            }
            catch (IOException ex) {
                this.logger.error("Failed to parse access transformer file %s: %s", path, ex.getMessage());
                throw new UncheckedIOException(ex);
            }
        }
        this.pendingATs = new ConcurrentHashMap<Target, Transformation>(this.ats.getAccessTransformers());
    }

    @Override
    public boolean afterRun(TransformContext context2) {
        if (!this.pendingATs.isEmpty()) {
            this.pendingATs.forEach((target, transformation) -> {
                if (target instanceof Target.ClassTarget && target.className().contains("$")) {
                    return;
                }
                this.logger.error("Access transformer %s, targeting %s did not apply as its target doesn't exist", transformation, target);
            });
            this.errored = true;
        }
        return !this.errored || this.validation != AccessTransformerValidation.ERROR;
    }

    @Override
    public void visitFile(PsiFile psiFile, Replacements replacements) {
        ApplyATsVisitor visitor = new ApplyATsVisitor(this.ats, replacements, this.pendingATs, this.logger);
        visitor.visitFile(psiFile);
        if (visitor.errored) {
            this.errored = true;
        }
    }

    public static enum AccessTransformerValidation {
        LOG,
        ERROR;

    }
}

