/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.CodecEncoding;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PopulationCodec;
import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentHeader;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPDouble;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFieldRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFloat;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPInteger;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPInterfaceMethodRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPLong;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPMethodRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPNameAndType;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPString;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.utils.ExactMath;

public abstract class BandSet {
    protected Segment segment;
    protected SegmentHeader header;

    public BandSet(Segment segment) {
        this.segment = segment;
        this.header = segment.getSegmentHeader();
    }

    public int[] decodeBandInt(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] band;
        Codec codecUsed = codec;
        if (codec.getB() == 1 || count2 == 0) {
            return codec.decodeInts(count2, in);
        }
        int[] getFirst = codec.decodeInts(1, in);
        if (getFirst.length == 0) {
            return getFirst;
        }
        int first2 = getFirst[0];
        if (codec.isSigned() && first2 >= -256 && first2 <= -1) {
            codecUsed = CodecEncoding.getCodec(-1 - first2, this.header.getBandHeadersInputStream(), codec);
            band = codecUsed.decodeInts(count2, in);
        } else if (!codec.isSigned() && first2 >= codec.getL() && first2 <= codec.getL() + 255) {
            codecUsed = CodecEncoding.getCodec(first2 - codec.getL(), this.header.getBandHeadersInputStream(), codec);
            band = codecUsed.decodeInts(count2, in);
        } else {
            band = codec.decodeInts(count2 - 1, in, first2);
        }
        if (codecUsed instanceof PopulationCodec) {
            PopulationCodec popCodec = (PopulationCodec)codecUsed;
            int[] favoured = (int[])popCodec.getFavoured().clone();
            Arrays.sort(favoured);
            for (int i = 0; i < band.length; ++i) {
                Codec theCodec;
                boolean favouredValue = Arrays.binarySearch(favoured, band[i]) > -1;
                Codec codec2 = theCodec = favouredValue ? popCodec.getFavouredCodec() : popCodec.getUnfavouredCodec();
                if (!(theCodec instanceof BHSDCodec) || !((BHSDCodec)theCodec).isDelta()) continue;
                BHSDCodec bhsd = (BHSDCodec)theCodec;
                long cardinality = bhsd.cardinality();
                while ((long)band[i] > bhsd.largest()) {
                    int n = i;
                    band[n] = (int)((long)band[n] - cardinality);
                }
                while ((long)band[i] < bhsd.smallest()) {
                    band[i] = ExactMath.add(band[i], cardinality);
                }
            }
        }
        return band;
    }

    public int[][] decodeBandInt(String name, InputStream in, BHSDCodec defaultCodec, int[] counts) throws IOException, Pack200Exception {
        int[][] result2 = new int[counts.length][];
        int totalCount = 0;
        for (int count2 : counts) {
            totalCount += count2;
        }
        int[] twoDResult = this.decodeBandInt(name, in, defaultCodec, totalCount);
        int index = 0;
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = new int[counts[i]];
            for (int j = 0; j < result2[i].length; ++j) {
                result2[i][j] = twoDResult[index];
                ++index;
            }
        }
        return result2;
    }

    protected String[] getReferences(int[] ints, String[] reference) {
        String[] result2 = new String[ints.length];
        Arrays.setAll(result2, i -> reference[ints[i]]);
        return result2;
    }

    protected String[][] getReferences(int[][] ints, String[] reference) {
        String[][] result2 = new String[ints.length][];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = new String[ints[i].length];
            for (int j = 0; j < result2[i].length; ++j) {
                result2[i][j] = reference[ints[i][j]];
            }
        }
        return result2;
    }

    public CPClass[] parseCPClassReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPClass[] result2 = new CPClass[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = this.segment.getCpBands().cpClassValue(indices[i1]);
        }
        return result2;
    }

    public CPNameAndType[] parseCPDescriptorReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        CpBands cpBands = this.segment.getCpBands();
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPNameAndType[] result2 = new CPNameAndType[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            int index = indices[i1];
            result2[i1] = cpBands.cpNameAndTypeValue(index);
        }
        return result2;
    }

    public CPDouble[] parseCPDoubleReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPDouble[] result2 = new CPDouble[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = this.segment.getCpBands().cpDoubleValue(indices[i1]);
        }
        return result2;
    }

    public CPFieldRef[] parseCPFieldRefReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        CpBands cpBands = this.segment.getCpBands();
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPFieldRef[] result2 = new CPFieldRef[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            int index = indices[i1];
            result2[i1] = cpBands.cpFieldValue(index);
        }
        return result2;
    }

    public CPFloat[] parseCPFloatReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPFloat[] result2 = new CPFloat[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = this.segment.getCpBands().cpFloatValue(indices[i1]);
        }
        return result2;
    }

    public CPInterfaceMethodRef[] parseCPInterfaceMethodRefReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        CpBands cpBands = this.segment.getCpBands();
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPInterfaceMethodRef[] result2 = new CPInterfaceMethodRef[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = cpBands.cpIMethodValue(indices[i1]);
        }
        return result2;
    }

    public CPInteger[] parseCPIntReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] reference = this.segment.getCpBands().getCpInt();
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPInteger[] result2 = new CPInteger[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            int index = indices[i1];
            if (index < 0 || index >= reference.length) {
                throw new Pack200Exception("Something has gone wrong during parsing references, index = " + index + ", array size = " + reference.length);
            }
            result2[i1] = this.segment.getCpBands().cpIntegerValue(index);
        }
        return result2;
    }

    public CPLong[] parseCPLongReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        long[] reference = this.segment.getCpBands().getCpLong();
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPLong[] result2 = new CPLong[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            int index = indices[i1];
            if (index < 0 || index >= reference.length) {
                throw new Pack200Exception("Something has gone wrong during parsing references, index = " + index + ", array size = " + reference.length);
            }
            result2[i1] = this.segment.getCpBands().cpLongValue(index);
        }
        return result2;
    }

    public CPMethodRef[] parseCPMethodRefReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        CpBands cpBands = this.segment.getCpBands();
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPMethodRef[] result2 = new CPMethodRef[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = cpBands.cpMethodValue(indices[i1]);
        }
        return result2;
    }

    public CPUTF8[] parseCPSignatureReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPUTF8[] result2 = new CPUTF8[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = this.segment.getCpBands().cpSignatureValue(indices[i1]);
        }
        return result2;
    }

    protected CPUTF8[][] parseCPSignatureReferences(String name, InputStream in, BHSDCodec codec, int[] counts) throws IOException, Pack200Exception {
        CPUTF8[][] result2 = new CPUTF8[counts.length][];
        int sum = 0;
        for (int i = 0; i < counts.length; ++i) {
            result2[i] = new CPUTF8[counts[i]];
            sum += counts[i];
        }
        CPUTF8[] result1 = new CPUTF8[sum];
        int[] indices = this.decodeBandInt(name, in, codec, sum);
        for (int i1 = 0; i1 < sum; ++i1) {
            result1[i1] = this.segment.getCpBands().cpSignatureValue(indices[i1]);
        }
        int pos = 0;
        for (int i = 0; i < counts.length; ++i) {
            int num = counts[i];
            result2[i] = new CPUTF8[num];
            System.arraycopy(result1, pos, result2[i], 0, num);
            pos += num;
        }
        return result2;
    }

    public CPString[] parseCPStringReferences(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPString[] result2 = new CPString[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            result2[i1] = this.segment.getCpBands().cpStringValue(indices[i1]);
        }
        return result2;
    }

    public CPUTF8[] parseCPUTF8References(String name, InputStream in, BHSDCodec codec, int count2) throws IOException, Pack200Exception {
        int[] indices = this.decodeBandInt(name, in, codec, count2);
        CPUTF8[] result2 = new CPUTF8[indices.length];
        for (int i1 = 0; i1 < count2; ++i1) {
            int index = indices[i1];
            result2[i1] = this.segment.getCpBands().cpUTF8Value(index);
        }
        return result2;
    }

    public CPUTF8[][] parseCPUTF8References(String name, InputStream in, BHSDCodec codec, int[] counts) throws IOException, Pack200Exception {
        CPUTF8[][] result2 = new CPUTF8[counts.length][];
        int sum = 0;
        for (int i = 0; i < counts.length; ++i) {
            result2[i] = new CPUTF8[counts[i]];
            sum += counts[i];
        }
        CPUTF8[] result1 = new CPUTF8[sum];
        int[] indices = this.decodeBandInt(name, in, codec, sum);
        for (int i1 = 0; i1 < sum; ++i1) {
            int index = indices[i1];
            result1[i1] = this.segment.getCpBands().cpUTF8Value(index);
        }
        int pos = 0;
        for (int i = 0; i < counts.length; ++i) {
            int num = counts[i];
            result2[i] = new CPUTF8[num];
            System.arraycopy(result1, pos, result2[i], 0, num);
            pos += num;
        }
        return result2;
    }

    public long[] parseFlags(String name, InputStream in, int count2, BHSDCodec hiCodec, BHSDCodec loCodec) throws IOException, Pack200Exception {
        return this.parseFlags(name, in, new int[]{count2}, hiCodec, loCodec)[0];
    }

    public long[] parseFlags(String name, InputStream in, int count2, BHSDCodec codec, boolean hasHi) throws IOException, Pack200Exception {
        return this.parseFlags(name, in, new int[]{count2}, hasHi ? codec : null, codec)[0];
    }

    public long[][] parseFlags(String name, InputStream in, int[] counts, BHSDCodec hiCodec, BHSDCodec loCodec) throws IOException, Pack200Exception {
        int count2 = counts.length;
        if (count2 == 0) {
            return new long[][]{new long[0]};
        }
        int sum = 0;
        long[][] result2 = new long[count2][];
        for (int i = 0; i < count2; ++i) {
            result2[i] = new long[counts[i]];
            sum += counts[i];
        }
        int[] hi = null;
        if (hiCodec != null) {
            hi = this.decodeBandInt(name, in, hiCodec, sum);
        }
        int[] lo = this.decodeBandInt(name, in, loCodec, sum);
        int index = 0;
        for (int i = 0; i < result2.length; ++i) {
            for (int j = 0; j < result2[i].length; ++j) {
                result2[i][j] = hi != null ? (long)hi[index] << 32 | (long)lo[index] & 0xFFFFFFFFL : (long)lo[index];
                ++index;
            }
        }
        return result2;
    }

    public long[][] parseFlags(String name, InputStream in, int[] counts, BHSDCodec codec, boolean hasHi) throws IOException, Pack200Exception {
        return this.parseFlags(name, in, counts, hasHi ? codec : null, codec);
    }

    public String[] parseReferences(String name, InputStream in, BHSDCodec codec, int count2, String[] reference) throws IOException, Pack200Exception {
        return this.parseReferences(name, in, codec, new int[]{count2}, reference)[0];
    }

    public String[][] parseReferences(String name, InputStream in, BHSDCodec codec, int[] counts, String[] reference) throws IOException, Pack200Exception {
        int count2 = counts.length;
        if (count2 == 0) {
            return new String[][]{new String[0]};
        }
        String[][] result2 = new String[count2][];
        int sum = 0;
        for (int i = 0; i < count2; ++i) {
            result2[i] = new String[counts[i]];
            sum += counts[i];
        }
        String[] result1 = new String[sum];
        int[] indices = this.decodeBandInt(name, in, codec, sum);
        for (int i1 = 0; i1 < sum; ++i1) {
            int index = indices[i1];
            if (index < 0 || index >= reference.length) {
                throw new Pack200Exception("Something has gone wrong during parsing references, index = " + index + ", array size = " + reference.length);
            }
            result1[i1] = reference[index];
        }
        int pos = 0;
        for (int i = 0; i < count2; ++i) {
            int num = counts[i];
            result2[i] = new String[num];
            System.arraycopy(result1, pos, result2[i], 0, num);
            pos += num;
        }
        return result2;
    }

    public abstract void read(InputStream var1) throws IOException, Pack200Exception;

    public abstract void unpack() throws IOException, Pack200Exception;

    public void unpack(InputStream in) throws IOException, Pack200Exception {
        this.read(in);
        this.unpack();
    }
}

