/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.parchment;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import java.util.Optional;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsDatabase;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForClass;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForMethod;
import org.jetbrains.annotations.Nullable;

public class PsiParchmentHelper {
    private static final Key<Optional<NamesAndDocsForClass>> CLASS_DATA_KEY = Key.create("names_and_docs_for_class");
    private static final Key<Optional<NamesAndDocsForMethod>> METHOD_DATA_KEY = Key.create("names_and_docs_for_method");

    @Nullable
    public static NamesAndDocsForClass getClassData(NamesAndDocsDatabase namesAndDocs, @Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        Optional<NamesAndDocsForClass> classData = psiClass.getUserData(CLASS_DATA_KEY);
        if (classData != null) {
            return classData.orElse(null);
        }
        StringBuilder sb = new StringBuilder();
        PsiHelper.getBinaryClassName(psiClass, sb);
        classData = sb.isEmpty() ? Optional.empty() : Optional.ofNullable(namesAndDocs.getClass(sb.toString()));
        psiClass.putUserData(CLASS_DATA_KEY, classData);
        return classData.orElse(null);
    }

    @Nullable
    public static NamesAndDocsForMethod getMethodData(NamesAndDocsDatabase namesAndDocs, @Nullable PsiMethod psiMethod) {
        if (psiMethod == null) {
            return null;
        }
        Optional<NamesAndDocsForMethod> methodData = psiMethod.getUserData(METHOD_DATA_KEY);
        if (methodData != null) {
            return methodData.orElse(null);
        }
        methodData = Optional.empty();
        NamesAndDocsForClass classData = PsiParchmentHelper.getClassData(namesAndDocs, psiMethod.getContainingClass());
        if (classData != null) {
            String methodName = PsiHelper.getBinaryMethodName(psiMethod);
            Iterator<String> signatures = PsiHelper.getOverloadedSignatures(psiMethod);
            while (signatures.hasNext() && methodData.isEmpty()) {
                methodData = Optional.ofNullable(classData.getMethod(methodName, signatures.next()));
            }
        }
        psiMethod.putUserData(METHOD_DATA_KEY, methodData);
        return methodData.orElse(null);
    }
}

