/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.parchment;

import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.neoforged.jst.api.Replacements;
import org.jetbrains.annotations.Nullable;

public final class JavadocHelper {
    private static final List<String> TAGS_ORDER = List.of("author", "version", "param", "return", "throws", "exception", "see", "since", "serial", "deprecated");
    private static final Comparator<String> TAGS_COMPARATOR = Comparator.comparingInt(text2 -> {
        int idx = TAGS_ORDER.indexOf(text2);
        return idx != -1 ? idx : Integer.MAX_VALUE;
    });

    private JavadocHelper() {
    }

    public static void enrichJavadoc(PsiJavaDocumentedElement psiElement, List<String> javadoc, Replacements replacements) {
        JavadocHelper.enrichJavadoc(psiElement, javadoc, Map.of(), Map.of(), List.of(), replacements);
    }

    public static void enrichJavadoc(PsiJavaDocumentedElement psiElement, List<String> javadoc, Map<String, String> parameters, Map<String, String> renamedParameters, List<String> parameterOrder, Replacements replacements) {
        PsiDocComment existingDocComment = psiElement.getDocComment();
        if (existingDocComment != null) {
            if (javadoc.isEmpty() && parameters.isEmpty() && renamedParameters.isEmpty()) {
                return;
            }
            List<String> bodyLines = JavadocHelper.getMergedJavadocBody(existingDocComment, javadoc);
            ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
            HashMap<String, String> parameterDocs = new HashMap<String, String>();
            for (PsiDocTag tag : existingDocComment.getTags()) {
                String name = tag.getName();
                if ("param".equalsIgnoreCase(name) && tag.getValueElement() != null) {
                    String paramName = tag.getValueElement().getText().trim();
                    String paramDocText = JavadocHelper.assembleTagText(tag.getValueElement().getNextSibling());
                    paramName = renamedParameters.getOrDefault(paramName, paramName);
                    parameterDocs.put(paramName, paramDocText);
                    continue;
                }
                String text2 = JavadocHelper.assembleTagText(tag.getNameElement().getNextSibling());
                tags.add(new JavadocTag(tag.getName(), null, text2));
            }
            parameterDocs.putAll(parameters);
            int indent = JavadocHelper.getIndent(existingDocComment);
            replacements.replace(existingDocComment, JavadocHelper.formatJavadoc(indent, bodyLines, tags, parameterDocs, parameterOrder));
        } else {
            if (javadoc.isEmpty() && parameters.isEmpty()) {
                return;
            }
            int indent = 0;
            PsiElement psiElement2 = psiElement.getPrevSibling();
            if (psiElement2 instanceof PsiWhiteSpace) {
                PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement2;
                indent = JavadocHelper.getLastLineLength(psiWhiteSpace);
            }
            replacements.insertBefore(psiElement, JavadocHelper.formatJavadoc(indent, javadoc, List.of(), parameters, parameterOrder) + "\n" + " ".repeat(indent));
        }
    }

    private static String assembleTagText(PsiElement startingElement) {
        StringBuilder paramDocBuilder = new StringBuilder();
        for (PsiElement child = startingElement; child != null; child = child.getNextSibling()) {
            PsiDocToken docToken;
            if (child instanceof PsiDocToken && (docToken = (PsiDocToken)child).getTokenType() == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) continue;
            String lineText = child.getText();
            paramDocBuilder.append(lineText);
        }
        Pattern p = Pattern.compile("\\s+");
        Matcher m4 = p.matcher(paramDocBuilder);
        return m4.replaceAll(" ").trim();
    }

    private static List<String> getMergedJavadocBody(PsiDocComment existingDocComment, List<String> newLines) {
        ArrayList<String> bodyLines = new ArrayList<String>();
        for (PsiElement el : existingDocComment.getDescriptionElements()) {
            bodyLines.add(JavadocHelper.trimJavadocBodyLine(el.getText()));
        }
        JavadocHelper.removeLeadingAndTrailingEmptyLines(bodyLines);
        if (!bodyLines.isEmpty() && !newLines.isEmpty()) {
            bodyLines.add("<p>");
        }
        bodyLines.addAll(newLines);
        return bodyLines;
    }

    private static String trimJavadocBodyLine(String text2) {
        StringBuilder line = new StringBuilder(text2);
        if (!line.isEmpty() && line.charAt(0) == ' ') {
            line.deleteCharAt(0);
        }
        if (!line.isEmpty() && line.charAt(line.length() - 1) == '\n') {
            line.deleteCharAt(line.length() - 1);
        }
        if (!line.isEmpty() && line.charAt(line.length() - 1) == '\r') {
            line.deleteCharAt(line.length() - 1);
        }
        return line.toString();
    }

    private static void removeLeadingAndTrailingEmptyLines(List<String> bodyLines) {
        while (!bodyLines.isEmpty() && bodyLines.get(0).isBlank()) {
            bodyLines.remove(0);
        }
        while (!bodyLines.isEmpty() && bodyLines.get(bodyLines.size() - 1).isBlank()) {
            bodyLines.remove(bodyLines.size() - 1);
        }
    }

    public static int getIndent(PsiDocCommentBase comment) {
        int indentLength = 0;
        for (PsiElement child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiDocToken)) continue;
            PsiDocToken token2 = (PsiDocToken)child;
            PsiElement psiElement = child.getPrevSibling();
            if (!(psiElement instanceof PsiWhiteSpace)) continue;
            PsiWhiteSpace precedingWhitespace = (PsiWhiteSpace)psiElement;
            IElementType type = token2.getTokenType();
            if (type == JavaDocTokenType.DOC_COMMENT_START) {
                indentLength = Math.max(indentLength, JavadocHelper.getLastLineLength(precedingWhitespace));
                continue;
            }
            if (type != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS && type != JavaDocTokenType.DOC_COMMENT_END) continue;
            indentLength = Math.max(indentLength, JavadocHelper.getLastLineLength(precedingWhitespace) - 1);
        }
        return indentLength;
    }

    private static String formatJavadoc(int indent, List<String> descriptionLines, List<JavadocTag> tags, Map<String, String> parameterDocs, List<String> parameterOrder) {
        tags = new ArrayList<JavadocTag>(tags);
        parameterDocs.entrySet().stream().sorted(Comparator.comparingInt(entry -> {
            int idx = parameterOrder.indexOf(entry.getKey());
            return idx == -1 ? Integer.MAX_VALUE : idx;
        })).map(e -> new JavadocTag("param", (String)e.getKey(), (String)e.getValue())).forEach(tags::add);
        tags.sort(Comparator.comparing(JavadocTag::tagName, TAGS_COMPARATOR));
        String indentText = " ".repeat(indent);
        StringBuilder result2 = new StringBuilder();
        result2.append("/**\n");
        for (String line : descriptionLines) {
            result2.append(indentText).append(" * ").append(line);
            JavadocHelper.endLine(result2);
        }
        if (!descriptionLines.isEmpty() && !tags.isEmpty()) {
            result2.append(indentText).append(" *\n");
        }
        JavadocHelper.formatTags(tags, indentText, result2);
        result2.append(indentText).append(" */");
        return result2.toString();
    }

    private static void formatTags(List<JavadocTag> tags, String indentText, StringBuilder result2) {
        BreakIterator boundary = BreakIterator.getWordInstance(Locale.ENGLISH);
        tags.stream().collect(Collectors.groupingBy(JavadocTag::tagName)).forEach((tagName, javadocTags) -> {
            boolean groupedTag = tagName.equals("param") || tagName.equals("throws") || tagName.equals("exception");
            int firstColWidth = 0;
            if (groupedTag) {
                firstColWidth = javadocTags.stream().mapToInt(t2 -> t2.refersTo != null ? t2.refersTo.length() : 0).max().orElse(0);
            }
            for (JavadocTag tag : javadocTags) {
                result2.append(indentText).append(" *");
                int startOfLineContent = result2.length();
                result2.append(" @").append(tag.tagName);
                if (tag.refersTo != null) {
                    result2.append(' ').append(tag.refersTo);
                    int padding = firstColWidth - tag.refersTo.length();
                    for (int j = 0; j < padding; ++j) {
                        result2.append(' ');
                    }
                }
                result2.append(' ');
                int continuationIndent = result2.length() - startOfLineContent;
                String continuationIndentText = indentText + " *" + " ".repeat(continuationIndent);
                int maxLineLength = Math.max(40, 80 - continuationIndent);
                boundary.setText(tag.text);
                int start = boundary.first();
                int currentLineLength = 0;
                int end = boundary.next();
                while (end != -1) {
                    int wordLength = end - start;
                    if (currentLineLength + wordLength > maxLineLength) {
                        JavadocHelper.endLine(result2).append(continuationIndentText);
                        currentLineLength = 0;
                        while (start < end && tag.text.charAt(start) == ' ') {
                            ++start;
                        }
                    }
                    result2.append(tag.text, start, end);
                    currentLineLength += wordLength;
                    start = end;
                    end = boundary.next();
                }
                JavadocHelper.endLine(result2);
            }
        });
    }

    private static StringBuilder endLine(StringBuilder sb) {
        while (!sb.isEmpty() && sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return sb.append('\n');
    }

    public static int getLastLineLength(PsiWhiteSpace psiWhiteSpace) {
        int lastNewline = psiWhiteSpace.getText().lastIndexOf(10);
        if (lastNewline != -1) {
            return psiWhiteSpace.getTextLength() - lastNewline - 1;
        }
        return psiWhiteSpace.getTextLength();
    }

    private record JavadocTag(String tagName, @Nullable String refersTo, String text) {
    }
}

