/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.parchment;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.parchment.JavadocHelper;
import net.neoforged.jst.parchment.PsiParchmentHelper;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsDatabase;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForClass;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForField;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForMethod;
import net.neoforged.jst.parchment.namesanddocs.NamesAndDocsForParameter;
import org.jetbrains.annotations.NotNull;

class GatherReplacementsVisitor
extends PsiRecursiveElementVisitor {
    private final NamesAndDocsDatabase namesAndDocs;
    private final boolean enableJavadoc;
    private final Replacements replacements;
    private final Map<PsiParameter, NamesAndDocsForParameter> activeParameters = new IdentityHashMap<PsiParameter, NamesAndDocsForParameter>();

    public GatherReplacementsVisitor(NamesAndDocsDatabase namesAndDocs, boolean enableJavadoc, Replacements replacements) {
        this.namesAndDocs = namesAndDocs;
        this.enableJavadoc = enableJavadoc;
        this.replacements = replacements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitElement(@NotNull PsiElement element) {
        block19: {
            PsiReferenceExpression refExpr;
            block20: {
                NamesAndDocsForField fieldData;
                block18: {
                    NamesAndDocsForClass classData;
                    if (!(element instanceof PsiClass)) break block18;
                    PsiClass psiClass = (PsiClass)element;
                    if (psiClass.getQualifiedName() != null) {
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(element.getProject());
                        PsiClass foundClass = psiFacade.findClass(psiClass.getQualifiedName(), GlobalSearchScope.everythingScope(element.getProject()));
                        if (foundClass == null) {
                            throw new IllegalStateException("Failed to find how class " + psiClass.getQualifiedName() + " was loaded while processing it");
                        }
                        if (foundClass != psiClass) {
                            throw new IllegalStateException("Class " + psiClass + " was loaded from two different sources: " + psiClass.getContainingFile() + " and " + foundClass.getContainingFile());
                        }
                    }
                    if ((classData = PsiParchmentHelper.getClassData(this.namesAndDocs, psiClass)) == null) break block19;
                    this.applyJavadoc(psiClass, classData.getJavadoc(), this.replacements);
                    break block19;
                }
                if (!(element instanceof PsiField)) break block20;
                PsiField psiField = (PsiField)element;
                NamesAndDocsForClass classData = PsiParchmentHelper.getClassData(this.namesAndDocs, psiField.getContainingClass());
                NamesAndDocsForField namesAndDocsForField = fieldData = classData != null ? classData.getField(psiField.getName()) : null;
                if (fieldData == null) break block19;
                this.applyJavadoc(psiField, fieldData.getJavadoc(), this.replacements);
                break block19;
            }
            if (element instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)element;
                NamesAndDocsForMethod methodData = PsiParchmentHelper.getMethodData(this.namesAndDocs, psiMethod);
                if (methodData != null) {
                    HashMap<String, String> parameterJavadoc = new HashMap<String, String>();
                    HashMap<String, String> renamedParameters = new HashMap<String, String>();
                    ArrayList<String> parameterOrder = new ArrayList<String>();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    int[] parametersLvtIndices = PsiHelper.getParameterLvtIndices(psiMethod);
                    boolean hadReplacements = false;
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiParameter psiParameter = parameters[i];
                        if (psiParameter.getNameIdentifier() == null) continue;
                        int jvmIndex = parametersLvtIndices[i];
                        NamesAndDocsForParameter paramData = methodData.getParameter(jvmIndex);
                        if (paramData != null && paramData.getName() != null && !PsiHelper.isRecordConstructor(psiMethod)) {
                            this.activeParameters.put(psiParameter, paramData);
                            this.replacements.replace(psiParameter.getNameIdentifier(), paramData.getName());
                            renamedParameters.put(psiParameter.getName(), paramData.getName());
                            hadReplacements = true;
                            parameterOrder.add(paramData.getName());
                        } else {
                            parameterOrder.add(psiParameter.getName());
                        }
                        if (paramData == null || paramData.getJavadoc() == null) continue;
                        parameterJavadoc.put(Objects.requireNonNullElse(paramData.getName(), psiParameter.getName()), paramData.getJavadoc());
                    }
                    if (this.enableJavadoc) {
                        JavadocHelper.enrichJavadoc(psiMethod, methodData.getJavadoc(), parameterJavadoc, renamedParameters, parameterOrder, this.replacements);
                    }
                    if (hadReplacements) {
                        try {
                            element.acceptChildren(this);
                        }
                        finally {
                            for (PsiParameter parameter : parameters) {
                                this.activeParameters.remove(parameter);
                            }
                        }
                        return;
                    }
                }
            } else if (element instanceof PsiReferenceExpression && (refExpr = (PsiReferenceExpression)element).getReferenceNameElement() != null) {
                for (Map.Entry<PsiParameter, NamesAndDocsForParameter> entry : this.activeParameters.entrySet()) {
                    if (!refExpr.isReferenceTo(entry.getKey())) continue;
                    this.replacements.replace(refExpr.getReferenceNameElement(), entry.getValue().getName());
                    break;
                }
            }
        }
        element.acceptChildren(this);
    }

    private void applyJavadoc(PsiJavaDocumentedElement psiElement, List<String> javadoc, Replacements replacements) {
        if (this.enableJavadoc && !javadoc.isEmpty()) {
            JavadocHelper.enrichJavadoc(psiElement, javadoc, replacements);
        }
    }
}

