/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.intellij;

import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import net.neoforged.jst.cli.intellij.IntelliJEnvironmentImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathSetup {
    private ClasspathSetup() {
    }

    public static void addJdkModules(Path jdkHome, JavaCoreProjectEnvironment javaEnv) {
        VirtualFileSystem jrtFileSystem = javaEnv.getEnvironment().getJrtFileSystem();
        if (jrtFileSystem == null) {
            throw new IllegalStateException("No JRT file system was configured");
        }
        VirtualFile jdkVfsRoot = jrtFileSystem.findFileByPath(jdkHome.toAbsolutePath() + "!/");
        if (jdkVfsRoot == null) {
            System.err.println("Failed to load VFS-entry for JDK home " + jdkHome + ". Is it missing?");
            return;
        }
        VirtualFile modulesFolder = jdkVfsRoot.findChild("modules");
        if (modulesFolder == null) {
            System.err.println("VFS for JDK " + jdkHome + " doesn't have a modules subfolder");
            return;
        }
        int moduleCount = 0;
        List<String> modules = ClasspathSetup.readModulesFromReleaseFile(jdkHome);
        if (modules != null) {
            for (String module : modules) {
                VirtualFile moduleRoot = modulesFolder.findChild(module);
                if (moduleRoot == null || !moduleRoot.isDirectory()) {
                    System.err.println("Couldn't find module " + module + " even though it was listed in the release file of JDK " + jdkHome);
                    continue;
                }
                javaEnv.addSourcesToClasspath(moduleRoot);
                ++moduleCount;
            }
        } else {
            for (VirtualFile jrtChild : modulesFolder.getChildren()) {
                if (!jrtChild.isDirectory()) continue;
                javaEnv.addSourcesToClasspath(jrtChild);
                ++moduleCount;
            }
        }
        System.out.println("Added " + moduleCount + " modules from " + jdkHome);
    }

    public static void addLibraries(Path librariesPath, IntelliJEnvironmentImpl ijEnv) throws IOException {
        for (String libraryLine : Files.readAllLines(librariesPath)) {
            if ((libraryLine = libraryLine.trim()).startsWith("-e=")) {
                libraryLine = libraryLine.substring("-e=".length());
            }
            if (libraryLine.isBlank()) continue;
            Path libraryPath = Paths.get(libraryLine, new String[0]);
            if (!Files.exists(libraryPath, new LinkOption[0])) {
                throw new UncheckedIOException(new FileNotFoundException(libraryLine));
            }
            ijEnv.addJarToClassPath(libraryPath);
            System.out.println("Added " + libraryPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static List<String> readModulesFromReleaseFile(@NotNull Path jrtBaseDir) {
        try (InputStream stream = Files.newInputStream(jrtBaseDir.resolve("release"), new OpenOption[0]);){
            Properties p = new Properties();
            p.load(stream);
            String modules = p.getProperty("MODULES");
            if (modules == null) return null;
            List<String> list = StringUtil.split(StringUtil.unquoteString(modules), " ");
            return list;
        }
        catch (IOException | IllegalArgumentException e) {
            return null;
        }
    }
}

