/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import net.neoforged.jst.api.FileEntry;

final class PathFileEntry
implements FileEntry {
    private final Path path;
    private final String relativePath;
    private final boolean directory;
    private final FileTime lastModified;

    public PathFileEntry(Path relativeTo, Path path) {
        this.directory = Files.isDirectory(path, new LinkOption[0]);
        this.path = path;
        String relativized = relativeTo.relativize(path).toString();
        this.relativePath = relativized = relativized.replace('\\', '/');
        try {
            this.lastModified = Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean directory() {
        return this.directory;
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    public FileTime lastModified() {
        return this.lastModified;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }
}

