/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.accesstransformers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.ClassUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.neoforged.accesstransformer.parser.AccessTransformerFiles;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.api.Replacements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyATsVisitor
extends PsiRecursiveElementVisitor {
    private static final Set<String> ACCESS_MODIFIERS = Set.of("public", "private", "protected");
    private static final Set<String> MODIFIERS = Set.of(PsiModifier.MODIFIERS);
    public static final EnumMap<Transformation.Modifier, String> MODIFIER_TO_STRING = new EnumMap<Transformation.Modifier, String>(Map.of(Transformation.Modifier.PRIVATE, "private", Transformation.Modifier.PUBLIC, "public", Transformation.Modifier.PROTECTED, "protected"));
    private final AccessTransformerFiles ats;
    private final Replacements replacements;

    public ApplyATsVisitor(AccessTransformerFiles ats, Replacements replacements) {
        this.ats = ats;
        this.replacements = replacements;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        PsiMethod method;
        PsiClass cls;
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.getQualifiedName() != null) {
                Transformation methodWildcard;
                String className = ClassUtil.getJVMClassName(psiClass);
                if (!this.ats.containsClassTarget(className)) {
                    for (PsiClass innerClass : psiClass.getInnerClasses()) {
                        this.visitElement(innerClass);
                    }
                    return;
                }
                this.apply(this.ats.getAccessTransformers().get(new Target.ClassTarget(className)), psiClass, psiClass);
                Transformation fieldWildcard = this.ats.getAccessTransformers().get(new Target.WildcardFieldTarget(className));
                if (fieldWildcard != null) {
                    for (PsiField field : psiClass.getFields()) {
                        this.apply(fieldWildcard, field, psiClass);
                    }
                }
                if ((methodWildcard = this.ats.getAccessTransformers().get(new Target.WildcardMethodTarget(className))) != null) {
                    for (PsiMethod method2 : psiClass.getMethods()) {
                        this.apply(methodWildcard, method2, psiClass);
                    }
                }
            }
        } else if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            PsiClass cls2 = field.getContainingClass();
            if (cls2 != null && cls2.getQualifiedName() != null) {
                String className = ClassUtil.getJVMClassName(cls2);
                this.apply(this.ats.getAccessTransformers().get(new Target.FieldTarget(className, field.getName())), field, cls2);
            }
        } else if (element instanceof PsiMethod && (cls = (method = (PsiMethod)element).getContainingClass()) != null && cls.getQualifiedName() != null) {
            String className = ClassUtil.getJVMClassName(cls);
            this.apply(this.ats.getAccessTransformers().get(new Target.MethodTarget(className, PsiHelper.getBinaryMethodName(method), PsiHelper.getBinaryMethodSignature(method))), method, cls);
        }
        element.acceptChildren(this);
    }

    private void apply(@Nullable Transformation at, PsiModifierListOwner owner, PsiClass containingClass) {
        if (at == null || !at.isValid()) {
            return;
        }
        PsiModifierList modifiers = owner.getModifierList();
        Transformation.Modifier targetAcc = at.modifier();
        if (containingClass.isInterface() && owner instanceof PsiMethod && !modifiers.hasModifierProperty("static")) {
            if (targetAcc != Transformation.Modifier.PUBLIC) {
                System.err.println("Non-static interface methods can only be made public");
            } else {
                for (PsiElement kw2 : modifiers.getChildren()) {
                    if (!(kw2 instanceof PsiKeyword) || !kw2.getText().equals("private")) continue;
                    this.replacements.replace(kw2, "default");
                    break;
                }
            }
        } else if (targetAcc == Transformation.Modifier.DEFAULT || !modifiers.hasModifierProperty(MODIFIER_TO_STRING.get((Object)targetAcc))) {
            this.modify(targetAcc, modifiers, Arrays.stream(modifiers.getChildren()).filter(el -> el instanceof PsiKeyword).map(el -> (PsiKeyword)el).filter(kw -> ACCESS_MODIFIERS.contains(kw.getText())).findFirst());
        }
        Transformation.FinalState finalState = at.finalState();
        if (finalState == Transformation.FinalState.REMOVEFINAL && modifiers.hasModifierProperty("final")) {
            Arrays.stream(modifiers.getChildren()).filter(el -> el instanceof PsiKeyword).map(el -> (PsiKeyword)el).filter(kw -> kw.getText().equals("final")).findFirst().ifPresent(this.replacements::remove);
        }
    }

    private void modify(Transformation.Modifier targetAcc, PsiModifierList modifiers, Optional<PsiKeyword> existingModifier) {
        if (targetAcc == Transformation.Modifier.DEFAULT) {
            existingModifier.ifPresent(this.replacements::remove);
        } else if (existingModifier.isPresent()) {
            this.replacements.replace(existingModifier.get(), MODIFIER_TO_STRING.get((Object)targetAcc));
        } else if (modifiers.getChildren().length == 0) {
            this.replacements.insertAfter(modifiers, MODIFIER_TO_STRING.get((Object)targetAcc) + " ");
        } else {
            String modifierStr = MODIFIER_TO_STRING.get((Object)targetAcc);
            Arrays.stream(modifiers.getChildren()).filter(element -> element instanceof PsiKeyword && MODIFIERS.contains(element.getText())).findFirst().ifPresentOrElse(first2 -> this.replacements.insertBefore((PsiElement)first2, modifierStr + " "), () -> {
                PsiElement patt7717$temp = modifiers.getParent();
                if (patt7717$temp instanceof PsiClass) {
                    PsiClass cls = (PsiClass)patt7717$temp;
                    String typeKeyword = ApplyATsVisitor.detectKind(cls);
                    PsiElement next2 = modifiers;
                    while ((next2 = next2.getNextSibling()) != null) {
                        PsiKeyword kw;
                        if (!(next2 instanceof PsiKeyword) || !(kw = (PsiKeyword)next2).getText().equals(typeKeyword)) continue;
                        this.replacements.insertBefore(kw, modifierStr + " ");
                        break;
                    }
                } else {
                    PsiElement patt8378$temp = modifiers.getParent();
                    if (patt8378$temp instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)patt8378$temp;
                        if (method.getReturnTypeElement() == null) {
                            this.replacements.insertBefore(method.getNameIdentifier(), modifierStr + " ");
                        } else {
                            this.replacements.insertBefore(method.getReturnTypeElement(), modifierStr + " ");
                        }
                    } else {
                        PsiField field;
                        PsiElement patt8869$temp = modifiers.getParent();
                        if (patt8869$temp instanceof PsiField && (field = (PsiField)patt8869$temp).getTypeElement() != null) {
                            this.replacements.insertBefore(field.getTypeElement(), modifierStr + " ");
                        } else {
                            this.replacements.insertBefore(modifiers, modifierStr + " ");
                        }
                    }
                }
            });
        }
    }

    private static String detectKind(PsiClass cls) {
        if (cls.isRecord()) {
            return "record";
        }
        if (cls.isInterface()) {
            return "interface";
        }
        if (cls.isEnum()) {
            return "enum";
        }
        return "class";
    }
}

