/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.accesstransformers;

import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.accesstransformer.parser.AccessTransformerFiles;
import net.neoforged.jst.accesstransformers.ApplyATsVisitor;
import net.neoforged.jst.api.Replacements;
import net.neoforged.jst.api.SourceTransformer;
import net.neoforged.jst.api.TransformContext;
import picocli.CommandLine;

public class AccessTransformersTransformer
implements SourceTransformer {
    @CommandLine.Option(names={"--access-transformer"}, required=true)
    public List<Path> atFiles;
    private AccessTransformerFiles ats;

    @Override
    public void beforeRun(TransformContext context2) {
        this.ats = new AccessTransformerFiles();
        try {
            for (Path path : this.atFiles) {
                this.ats.loadFromPath(path);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void visitFile(PsiFile psiFile, Replacements replacements) {
        new ApplyATsVisitor(this.ats, replacements).visitFile(psiFile);
    }
}

