/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.neoforged.accesstransformer.parser.AtParser;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AccessTransformerFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger("AXFORM");
    private static final Marker AXFORM_MARKER = MarkerFactory.getMarker("AXFORM");
    private final Map<Target, Transformation> accessTransformers = new HashMap<Target, Transformation>();
    private final Map<Target, Transformation> accessTransformersExposed = Collections.unmodifiableMap(this.accessTransformers);
    private Set<String> targetedClassCache = Collections.emptySet();

    public void loadFromResource(String resourceName) throws URISyntaxException, IOException {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(resourceName).toURI());
        this.loadFromPath(path);
    }

    public void loadFromPath(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.loadAT(reader, path.getFileName().toString());
        }
    }

    public void loadAT(Reader reader, String originName) throws IOException {
        HashMap<Target, Transformation> localATCopy = new HashMap<Target, Transformation>(this.accessTransformers);
        AtParser.parse(reader, originName, this.mergeAccessTransformers(localATCopy));
        Map<Target, Transformation> invalidTransformers = this.invalidTransformers(localATCopy);
        if (!invalidTransformers.isEmpty()) {
            invalidTransformers.forEach((k, v) -> LOGGER.error(AXFORM_MARKER, "Invalid access transform final state for target {}. Referred in resources {}.", k, (Object)v.origins()));
            throw new IllegalArgumentException("Invalid AT final conflicts");
        }
        this.accessTransformers.clear();
        this.accessTransformers.putAll(localATCopy);
        this.targetedClassCache = this.accessTransformers.keySet().stream().map(Target::className).collect(Collectors.toSet());
        LOGGER.debug(AXFORM_MARKER, "Loaded access transformer {}", (Object)originName);
    }

    private BiConsumer<Target, Transformation> mergeAccessTransformers(Map<Target, Transformation> accessTransformers) {
        return (k, v) -> accessTransformers.merge((Target)k, (Transformation)v, Transformation::mergeStates);
    }

    private Map<Target, Transformation> invalidTransformers(HashMap<Target, Transformation> accessTransformers) {
        HashMap<Target, Transformation> invalid = new HashMap<Target, Transformation>();
        accessTransformers.forEach((target, transformation) -> {
            if (!transformation.isValid()) {
                invalid.put((Target)target, (Transformation)transformation);
            }
        });
        return invalid;
    }

    public Map<Target, Transformation> getAccessTransformers() {
        return this.accessTransformersExposed;
    }

    public boolean containsClassTarget(String name) {
        return this.getTargets().contains(name);
    }

    public Set<String> getTargets() {
        return this.targetedClassCache;
    }
}

