/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class BidirectionalMultiMap<K, V> {
    private final Map<K, Set<V>> keyToValues;
    private final Map<V, Set<K>> valueToKeys;

    public BidirectionalMultiMap() {
        this(new HashMap(), new HashMap());
    }

    public BidirectionalMultiMap(@NotNull Map<K, Set<V>> key2Values, @NotNull Map<V, Set<K>> value2Keys) {
        if (key2Values == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(0);
        }
        if (value2Keys == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(1);
        }
        this.keyToValues = key2Values;
        this.valueToKeys = value2Keys;
    }

    @NotNull
    public Set<V> getValues(K key) {
        Set<V> set = this.keyToValues.get(key);
        Set<Object> set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    public Set<K> getKeys(V value) {
        Set<K> set = this.valueToKeys.get(value);
        Set<Object> set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            BidirectionalMultiMap.$$$reportNull$$$0(3);
        }
        return set2;
    }

    public boolean containsKey(K key) {
        return this.keyToValues.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.valueToKeys.containsKey(value);
    }

    public boolean put(K key, V value) {
        Set<K> keys2 = this.valueToKeys.get(value);
        if (keys2 == null) {
            keys2 = this.createKeysSet();
            this.valueToKeys.put((Set<K>)value, (Set<V>)keys2);
        }
        keys2.add(key);
        Set<V> values2 = this.keyToValues.get(key);
        if (values2 == null) {
            values2 = this.createValuesSet();
            this.keyToValues.put(key, values2);
        }
        return values2.add(value);
    }

    @NotNull
    private Set<V> createValuesSet() {
        return new HashSet();
    }

    @NotNull
    private Set<K> createKeysSet() {
        return new HashSet();
    }

    public boolean removeKey(K key) {
        Set<V> values2 = this.keyToValues.get(key);
        if (values2 == null) {
            return false;
        }
        for (V v : values2) {
            Set<K> keys2 = this.valueToKeys.get(v);
            keys2.remove(key);
            if (!keys2.isEmpty()) continue;
            this.valueToKeys.remove(v);
        }
        this.keyToValues.remove(key);
        return true;
    }

    public void remove(K key, V value) {
        Set<V> values2 = this.keyToValues.get(key);
        Set<K> keys2 = this.valueToKeys.get(value);
        if (keys2 != null && values2 != null) {
            keys2.remove(key);
            values2.remove(value);
            if (keys2.isEmpty()) {
                this.valueToKeys.remove(value);
            }
            if (values2.isEmpty()) {
                this.keyToValues.remove(key);
            }
        }
    }

    public boolean isEmpty() {
        return this.keyToValues.isEmpty() && this.valueToKeys.isEmpty();
    }

    public boolean removeValue(V value) {
        Set<K> keys2 = this.valueToKeys.get(value);
        if (keys2 == null) {
            return false;
        }
        for (K k : keys2) {
            Set<V> values2 = this.keyToValues.get(k);
            values2.remove(value);
            if (!values2.isEmpty()) continue;
            this.keyToValues.remove(k);
        }
        this.valueToKeys.remove(value);
        return true;
    }

    public void clear() {
        this.keyToValues.clear();
        this.valueToKeys.clear();
    }

    public Set<K> getKeys() {
        return this.keyToValues.keySet();
    }

    public Set<V> getValues() {
        return this.valueToKeys.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key2Values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2Keys";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/BidirectionalMultiMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/BidirectionalMultiMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

