/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.progress.impl;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.platform.util.progress.ProgressReporter;
import com.intellij.platform.util.progress.RawProgressReporter;
import com.intellij.platform.util.progress.impl.CommonKt;
import com.intellij.platform.util.progress.impl.EmptyProgressReporter;
import com.intellij.platform.util.progress.impl.EmptyRawProgressReporter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH$J\u0011\u0010\f\u001a\u00020\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\rJ%\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0013\u0010\u0013\u001a\u000f\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015\u00a2\u0006\u0002\b\u0016H$J%\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0013\u0010\u0013\u001a\u000f\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015\u00a2\u0006\u0002\b\u0016H\u0002J#\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0013\u0010\u0013\u001a\u000f\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0019\u001a\u00020\u00012\u0013\u0010\u0013\u001a\u000f\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015\u00a2\u0006\u0002\b\u0016H\u0002J\u0006\u0010\u001a\u001a\u00020\u000bJ#\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00122\u0013\u0010\u0013\u001a\u000f\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015\u00a2\u0006\u0002\b\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/util/progress/impl/BaseProgressReporter;", "Lcom/intellij/platform/util/progress/ProgressReporter;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "cs", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "lastFraction", "Lcom/google/common/util/concurrent/AtomicDouble;", "asRawReporter", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "awaitCompletion", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "createStep", "duration", "", "text", "", "Lcom/intellij/platform/util/progress/impl/ProgressText;", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "determinateStep", "durationStep", "indeterminateStep", "rawReporter", "step", "endFraction", "intellij.platform.util.progress"})
public abstract class BaseProgressReporter
implements ProgressReporter {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicDouble lastFraction;

    public BaseProgressReporter(@NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter(parentScope, "parentScope");
        this.cs = com.intellij.util.CoroutineScopeKt.childScope$default(parentScope, null, false, 1, null);
        this.lastFraction = new AtomicDouble(0.0);
    }

    @NotNull
    protected final CoroutineScope getCs() {
        return this.cs;
    }

    @Override
    public final void close() {
        CoroutineScopeKt.cancel$default(this.cs, null, 1, null);
    }

    @Nullable
    public final Object awaitCompletion(@NotNull Continuation<? super Unit> $completion) {
        Object object = JobKt.getJob(this.cs.getCoroutineContext()).join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public final ProgressReporter step(double endFraction, @Nullable String text) {
        block2: {
            if (!(0.0 < endFraction) || !(endFraction <= 1.0)) {
                CommonKt.getLOG().error(new IllegalArgumentException("End fraction must be in (0.0; 1.0], got: " + endFraction));
                return this.createStep(0.0, text);
            }
            do lbl-1000:
            // 3 sources

            {
                block3: {
                    lastFractionValue = this.lastFraction.get();
                    if (!(lastFractionValue <= 0.0)) break block3;
                    if (!this.lastFraction.compareAndSet(lastFractionValue, endFraction)) ** GOTO lbl-1000
                    return this.createStep(endFraction, text);
                }
                if (!(lastFractionValue <= 1.0)) break block2;
                if (!(endFraction <= lastFractionValue)) continue;
                CommonKt.getLOG().error(new IllegalStateException("New end fraction " + endFraction + " must be greater than the previous end fraction " + lastFractionValue));
                return this.createStep(0.0, text);
            } while (!this.lastFraction.compareAndSet(lastFractionValue, endFraction));
            return this.createStep(endFraction - lastFractionValue, text);
        }
        CommonKt.getLOG().error(new IllegalStateException("Cannot start a child because this reporter is raw."));
        return EmptyProgressReporter.INSTANCE;
    }

    @Override
    @NotNull
    public final ProgressReporter durationStep(double duration, @Nullable String text2) {
        if (!(0.0 <= duration ? duration <= 1.0 : false)) {
            CommonKt.getLOG().error(new IllegalArgumentException("Duration is expected to be a value in [0.0; 1.0], got " + duration));
            return this.createStep(0.0, text2);
        }
        if (duration == 0.0) {
            return this.indeterminateStep(text2);
        }
        return this.determinateStep(duration, text2);
    }

    private final ProgressReporter indeterminateStep(String text2) {
        double lastFractionValue;
        block2: {
            do {
                lastFractionValue = this.lastFraction.get();
                if (!(lastFractionValue <= 0.0)) break block2;
            } while (!this.lastFraction.compareAndSet(lastFractionValue, lastFractionValue - 1.0));
            return this.createStep(0.0, text2);
        }
        if (lastFractionValue <= 1.0) {
            return this.createStep(0.0, text2);
        }
        CommonKt.getLOG().error(new IllegalStateException("Cannot start an indeterminate child because this reporter is raw."));
        return EmptyProgressReporter.INSTANCE;
    }

    private final ProgressReporter determinateStep(double duration, String text2) {
        double lastFractionValue;
        block4: {
            double newValue;
            block5: {
                while (true) {
                    lastFractionValue = this.lastFraction.get();
                    if (lastFractionValue <= 0.0) {
                        if (!this.lastFraction.compareAndSet(lastFractionValue, duration)) continue;
                        return this.createStep(duration, text2);
                    }
                    if (!(lastFractionValue < 1.0)) break block4;
                    newValue = lastFractionValue + duration;
                    if (newValue <= 1.0) {
                        if (!this.lastFraction.compareAndSet(lastFractionValue, newValue)) continue;
                        return this.createStep(duration, text2);
                    }
                    if (!(newValue < 1.0000000004656613)) break block5;
                    if (this.lastFraction.compareAndSet(lastFractionValue, 1.0)) break;
                }
                double effectiveDuration = 1.0 - lastFractionValue;
                return this.createStep(effectiveDuration, text2);
            }
            CommonKt.getLOG().error(new IllegalStateException("Total duration " + newValue + " must not exceed 1.0, duration: " + duration));
            return this.createStep(0.0, text2);
        }
        if (lastFractionValue == 1.0) {
            CommonKt.getLOG().error(new IllegalStateException("Total duration must not exceed 1.0, duration: " + duration));
            return this.createStep(0.0, text2);
        }
        CommonKt.getLOG().error(new IllegalStateException("Cannot start a child because this reporter is raw."));
        return EmptyProgressReporter.INSTANCE;
    }

    @NotNull
    protected abstract ProgressReporter createStep(double var1, @Nullable String var3);

    @Override
    @NotNull
    public final RawProgressReporter rawReporter() {
        double previousFraction = this.lastFraction.getAndSet(2.0);
        if (previousFraction == 2.0) {
            CommonKt.getLOG().error(new IllegalStateException("This reporter was already marked raw."));
            return EmptyRawProgressReporter.INSTANCE;
        }
        if (!(previousFraction == 0.0)) {
            CommonKt.getLOG().error(new IllegalStateException("This reporter already has child steps.Wrap the call into step(endFraction=...) and call rawReporter() inside the newly started child step."));
            return EmptyRawProgressReporter.INSTANCE;
        }
        return this.asRawReporter();
    }

    @NotNull
    protected abstract RawProgressReporter asRawReporter();
}

