/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import java.io.Serializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TextRange
implements Segment,
Serializable {
    private static final long serialVersionUID = -670091356599757430L;
    public static final TextRange EMPTY_RANGE = new TextRange(0, 0);
    public static final TextRange[] EMPTY_ARRAY = new TextRange[0];
    private final int myStartOffset;
    private final int myEndOffset;

    @Contract(pure=true)
    public TextRange(int startOffset, int endOffset) {
        this(startOffset, endOffset, true);
    }

    protected TextRange(int startOffset, int endOffset, boolean checkForProperTextRange) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        if (checkForProperTextRange) {
            TextRange.assertProperRange(this);
        }
    }

    @Override
    public final int getStartOffset() {
        return this.myStartOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(@NotNull TextRange range) {
        if (range == null) {
            TextRange.$$$reportNull$$$0(0);
        }
        return this.contains((Segment)range);
    }

    public boolean contains(@NotNull Segment range) {
        if (range == null) {
            TextRange.$$$reportNull$$$0(1);
        }
        return this.containsRange(range.getStartOffset(), range.getEndOffset());
    }

    public boolean containsRange(int startOffset, int endOffset) {
        return this.getStartOffset() <= startOffset && endOffset <= this.getEndOffset();
    }

    public static boolean containsRange(@NotNull Segment outer, @NotNull Segment inner) {
        if (outer == null) {
            TextRange.$$$reportNull$$$0(2);
        }
        if (inner == null) {
            TextRange.$$$reportNull$$$0(3);
        }
        return outer.getStartOffset() <= inner.getStartOffset() && inner.getEndOffset() <= outer.getEndOffset();
    }

    public boolean containsOffset(int offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    @NotNull
    @Contract(pure=true)
    public String substring(@NotNull String str) {
        if (str == null) {
            TextRange.$$$reportNull$$$0(4);
        }
        String string2 = str.substring(this.myStartOffset, this.myEndOffset);
        if (string2 == null) {
            TextRange.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public CharSequence subSequence(@NotNull CharSequence str) {
        if (str == null) {
            TextRange.$$$reportNull$$$0(6);
        }
        CharSequence charSequence = str.subSequence(this.myStartOffset, this.myEndOffset);
        if (charSequence == null) {
            TextRange.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            TextRange.$$$reportNull$$$0(8);
        }
        if (subRange.getStartOffset() > this.getLength()) {
            throw new IllegalArgumentException("SubRange: " + subRange + "; this=" + this);
        }
        if (subRange.getEndOffset() > this.getLength()) {
            throw new IllegalArgumentException("SubRange: " + subRange + "; this=" + this);
        }
        TextRange.assertProperRange(subRange);
        return new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
    }

    @NotNull
    public TextRange shiftRight(int delta) {
        if (delta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                TextRange.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        return new TextRange(this.myStartOffset + delta, this.myEndOffset + delta);
    }

    @NotNull
    public TextRange shiftLeft(int delta) {
        if (delta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                TextRange.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        return new TextRange(this.myStartOffset - delta, this.myEndOffset - delta);
    }

    @NotNull
    public TextRange grown(int lengthDelta) {
        if (lengthDelta == 0) {
            TextRange textRange = this;
            if (textRange == null) {
                TextRange.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        return TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange from(int offset, int length) {
        return TextRange.create(offset, offset + length);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange create(int startOffset, int endOffset) {
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static TextRange create(@NotNull Segment segment) {
        if (segment == null) {
            TextRange.$$$reportNull$$$0(12);
        }
        return TextRange.create(segment.getStartOffset(), segment.getEndOffset());
    }

    public static boolean areSegmentsEqual(@NotNull Segment segment1, @NotNull Segment segment2) {
        if (segment1 == null) {
            TextRange.$$$reportNull$$$0(13);
        }
        if (segment2 == null) {
            TextRange.$$$reportNull$$$0(14);
        }
        return segment1.getStartOffset() == segment2.getStartOffset() && segment1.getEndOffset() == segment2.getEndOffset();
    }

    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        if (original == null) {
            TextRange.$$$reportNull$$$0(15);
        }
        if (replacement == null) {
            TextRange.$$$reportNull$$$0(16);
        }
        String beginning = original.substring(0, this.getStartOffset());
        String ending = original.substring(this.getEndOffset());
        String string2 = beginning + replacement + ending;
        if (string2 == null) {
            TextRange.$$$reportNull$$$0(17);
        }
        return string2;
    }

    public boolean intersects(@NotNull TextRange textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(18);
        }
        return this.intersects((Segment)textRange);
    }

    public boolean intersects(@NotNull Segment textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(19);
        }
        return this.intersects(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersects(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) <= Math.min(this.myEndOffset, endOffset);
    }

    public boolean intersectsStrict(@NotNull TextRange textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(20);
        }
        return this.intersectsStrict(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public boolean intersectsStrict(int startOffset, int endOffset) {
        return Math.max(this.myStartOffset, startOffset) < Math.min(this.myEndOffset, endOffset);
    }

    public TextRange intersection(@NotNull TextRange range) {
        int newEnd;
        if (range == null) {
            TextRange.$$$reportNull$$$0(21);
        }
        if (this.equals(range)) {
            return this;
        }
        int newStart = Math.max(this.myStartOffset, range.getStartOffset());
        return TextRange.isProperRange(newStart, newEnd = Math.min(this.myEndOffset, range.getEndOffset())) ? new TextRange(newStart, newEnd) : null;
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange union(@NotNull TextRange textRange) {
        if (textRange == null) {
            TextRange.$$$reportNull$$$0(22);
        }
        if (this.equals(textRange)) {
            TextRange textRange2 = this;
            if (textRange2 == null) {
                TextRange.$$$reportNull$$$0(23);
            }
            return textRange2;
        }
        return new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
    }

    public boolean equalsToRange(int startOffset, int endOffset) {
        return startOffset == this.myStartOffset && endOffset == this.myEndOffset;
    }

    @NotNull
    public static TextRange allOf(@NotNull String s2) {
        if (s2 == null) {
            TextRange.$$$reportNull$$$0(24);
        }
        return new TextRange(0, s2.length());
    }

    public static void assertProperRange(@NotNull Segment range) throws AssertionError {
        if (range == null) {
            TextRange.$$$reportNull$$$0(25);
        }
        TextRange.assertProperRange(range, "");
    }

    public static void assertProperRange(@NotNull Segment range, @NotNull Object message) throws AssertionError {
        if (range == null) {
            TextRange.$$$reportNull$$$0(26);
        }
        if (message == null) {
            TextRange.$$$reportNull$$$0(27);
        }
        TextRange.assertProperRange(range.getStartOffset(), range.getEndOffset(), message);
    }

    public static void assertProperRange(int startOffset, int endOffset, @NotNull Object message) {
        if (message == null) {
            TextRange.$$$reportNull$$$0(28);
        }
        if (!TextRange.isProperRange(startOffset, endOffset)) {
            throw new IllegalArgumentException("Invalid range specified: (" + startOffset + ", " + endOffset + "); " + message);
        }
    }

    public static boolean isProperRange(int startOffset, int endOffset) {
        return startOffset <= endOffset && startOffset >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/TextRange";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/TextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftRight";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftLeft";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "grown";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substring";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "subSequence";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cutOut";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areSegmentsEqual";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "intersectsStrict";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "allOf";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "assertProperRange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

